<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Activity;
use Session;
use Auth;
use Illuminate\Support\Str;
use Image;

ini_set('max_execution_time', 300); //300 seconds = 5 minutes

class ActivityController extends Controller
{
    
    public function index(Request $request)
    {
        $activities = Activity::select('id','order_number','title','subtitle','text_color','bg_color','published','created_at')->orderBy('order_number','asc')->get();
        return view('activities.index', compact('activities'));
    }

    public function create()
    {
        return view('activities.create');
    }

    public function store(Request $request)
    {
        $activity = new Activity;
        $activity->title = $request->title;
        $activity->subtitle = $request->subtitle;
        $activity->description = $request->description;

        $activity->text_color = $request->text_color;
        $activity->bg_color = $request->bg_color;

        $activity->order_number = $request->order_number;

        $activity->slug = preg_replace('/[^A-Za-z0-9\-]/', '', str_replace(' ', '-', $request->title));

        $photos = array();

        if($request->hasFile('images')){
            foreach ($request->images as $key => $image) {
                $imageName = date('d-m-Y-H-i').'-'.Str::random(8).'.webp';
                $path = 'uploads/activities/'.$imageName;

                $destinationPath = public_path().'/'.$path;
                $img = Image::make($image->getRealPath());
                $img->save($destinationPath,60);

                array_push($photos, $path);
            }
            $activity->images = json_encode($photos);
        }

        $activity->img_1_link = $request->img_1_link;
        $activity->img_2_link = $request->img_2_link;
        $activity->img_3_link = $request->img_3_link;
        $activity->img_4_link = $request->img_4_link;
        $activity->img_5_link = $request->img_5_link;
        $activity->img_6_link = $request->img_6_link;

        if($activity->save()){
            flash(__('Activity has been inserted successfully'))->success();
            return redirect()->route('activities.index');
        } else {
            flash(__('Something went wrong'))->error();
            return back();
        }
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $activity = Activity::findOrFail(decrypt($id));
        return view('activities.edit', compact('activity'));
    }

    public function update(Request $request, $id)
    {
        $activity = Activity::findOrFail($id);
        $activity->title = $request->title;
        $activity->subtitle = $request->subtitle;
        $activity->description = $request->description;

        $activity->text_color = $request->text_color;
        $activity->bg_color = $request->bg_color;

        $activity->order_number = $request->order_number;

        $activity->slug = preg_replace('/[^A-Za-z0-9\-]/', '', str_replace(' ', '-', $request->title));

        $update_photos = array();

        if($request->has('previous_images')){
            $prev_images = $request->previous_images;
            $activities = $activity->images;
            if(count($prev_images) > 0){
                foreach (json_decode($activities) as $key => $image) {
                    if(!in_array($image,$prev_images)){
                        unlink(public_path($image));
                    } else {
                        array_push($update_photos, $image);
                    }
                }
            } 
        } else {
            if($request->hasFile('images')){
                $activities = $activity->images;
                if(isset($activities)){
                    foreach (json_decode($activities) as $key => $image) {
                        if(isset($image)){
                            unlink(public_path($image));
                        }
                    }
                }
            } else {
                $activities = $activity->images;
                if(isset($activities)){
                    foreach (json_decode($activities) as $key => $image) {
                        if(isset($image)){
                            unlink(public_path($image));
                            $activity->images =  array();
                        }
                    }
                }
            }
        }

        if($request->hasFile('images')){
            foreach ($request->images as $key => $image) {
                $imageName = date('d-m-Y-H-i').'-'.Str::random(8).'.webp';
                $path = 'uploads/activities/'.$imageName;

                $destinationPath = public_path().'/'.$path;
                $img = Image::make($image->getRealPath());
                $img->save($destinationPath,60);

                array_push($update_photos, $path);
            }
        }

        if(count($update_photos) > 0){
            $activity->images = json_encode($update_photos);
        }

        $activity->img_1_link = $request->img_1_link;
        $activity->img_2_link = $request->img_2_link;
        $activity->img_3_link = $request->img_3_link;
        $activity->img_4_link = $request->img_4_link;
        $activity->img_5_link = $request->img_5_link;
        $activity->img_6_link = $request->img_6_link;

        if($activity->save()){
            flash(__('Activity has been updated successfully'))->success();
            return redirect()->route('activities.index');
        } else {
            flash(__('Something went wrong'))->error();
            return back();
        }
    }

    public function destroy($id)
    {
        $activity = Activity::findOrFail($id);
        if($activity){
            if(Activity::destroy($id)){

                if(isset($activity->images)){
                    foreach (json_decode($activity->images) as $key => $image) {
                        if($image != null || $image != ''){
                            unlink(public_path($image));
                        }
                    }
                }

                flash(__('Activity has been deleted successfully'))->success();
                return redirect()->route('activities.index');
            } else {
                flash(__('Something went wrong'))->error();
                return back();
            }
        } else {
            flash(__('Something went wrong'))->error();
            return back();
        }
    }

    public function updatePublished(Request $request)
    {
        $activity = Activity::findOrFail($request->id);
        $activity->published = $request->published;
        if($activity->save()){
            return 1;
        }
        return 0;
    }
}
