<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Advertisement;

class AdvertisementController extends Controller
{
    public function index(Request $request) {
        $advertisements = Advertisement::select('id','name','price','published','created_at')->orderby('created_at','desc')->get();

        return view('backend.advertisements.index', compact('advertisements'));
    }

    public function create()
    {
        return view('backend.advertisements.create');
    }

    public function store(Request $request)
    {
        $advertisement = new Advertisement;
        $advertisement->name = $request->name;
        $advertisement->price = $request->price;

        if($advertisement->save()){
            flash(translate('Advertisement has been inserted successfully'))->success();
            return back();
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function edit($id)
    {
        $advertisement = Advertisement::findOrFail(decrypt($id));
        return view('backend.advertisements.edit', compact('advertisement'));
    }

    public function update(Request $request, $id)
    {
        $advertisement = Advertisement::findOrFail($id);
        $advertisement->name = $request->name;
        $advertisement->price = $request->price;
       
        if($advertisement->save()){
            flash(translate('Advertisement has been updated successfully'))->success();
            return back();
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function destroy($id)
    {
        if(Advertisement::destroy($id)){
            flash(translate('Advertisement has been deleted successfully'))->success();
            return redirect()->route('advertisements.index');
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function published(Request $request) {
        $advertisement = Advertisement::find($request->id);
        $advertisement->published = $request->published;
        if($advertisement->save()){
            return '1';
        }
        else {
            return '0';
        }
    }
}
