<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Benefit;
use Illuminate\Support\Str;
use Image;

class BenefitController extends Controller
{
    public function index(Request $request) {
        $benefits = Benefit::orderby('created_at','desc')->get();

        return view('backend.benefits.index', compact('benefits'));
    }

    public function create()
    {
        return view('backend.benefits.create');
    }

    public function store(Request $request)
    {
        $benefit = new Benefit;
        $benefit->details = $request->details;
        $benefit->order_number = $request->order_number;

        if($request->hasFile('icons')){

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'benefit.webp';
            $benefit->icons = 'uploads/benefits/'.$imageName;

            $image = $request->file('icons');
            $destinationPath = public_path().'/'.$benefit->icons;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $benefit->save();
        }

        if($benefit->save()){
            flash(translate('Benefit has been inserted successfully'))->success();
            return back();
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function edit($id)
    {
        $benefit = Benefit::findOrFail(decrypt($id));
        return view('backend.benefits.edit', compact('benefit'));
    }

    public function update(Request $request, $id)
    {
        $benefit = Benefit::findOrFail($id);
        $benefit->details = $request->details;
        $benefit->order_number = $request->order_number;

        if($request->hasFile('icons')){

            if($benefit->icons != null || $benefit->icons != ''){
                unlink(public_path($benefit->icons));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'benefit.webp';
            $benefit->icons = 'uploads/benefits/'.$imageName;

            $image = $request->file('icons');
            $destinationPath = public_path().'/'.$benefit->icons;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $benefit->save();
        }

        if($benefit->save()){
            flash(translate('Benefit has been updated successfully'))->success();
            return back();
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function destroy($id)
    {
        if(Benefit::destroy($id)){
            flash(translate('Benefit has been deleted successfully'))->success();
            return redirect()->route('benefits.index');
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }
}
