<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Currency;
use App\BusinessSetting;
use Artisan;
use Illuminate\Support\Str;
use Image;
use Storage;
use App\Email;

use App\Registration;
use App\RegDietary;
use App\RegService;
use App\RegSoftware;
use App\RegSpecialization;
use App\RegAdvertisement;
use App\RegSponsorship;

class BusinessSettingsController extends Controller
{
    public function registration_section(Request $request)
    {
        return view('backend.registration_section.index');
    }

    public function agenda_section(Request $request)
    {
        return view('backend.agenda_section.index');
    }

    public function nav_section(Request $request)
    {
        return view('backend.nav_section.index');
    }

    public function countdown_section(Request $request)
    {
        return view('backend.countdown_section.index');
    }

    //commons
    public function commons_secure_pass(Request $request)
    {
        return view('backend.common_secure_pass.index');
    }
    public function commons_sponsor(Request $request)
    {
        return view('backend.common_sponsor.index');
    }
    public function commons_download_delegate_list(Request $request)
    {
        return view('backend.common_download_delegate_list.index');
    }
    public function commons_discover(Request $request)
    {
        return view('backend.common_discover.index');
    }
    public function commons_newsletter(Request $request)
    {
        return view('backend.common_newsletter.index');
    }
    //end commons

    // dont delete this
    public function statistics(Request $request)
    {
        return view('backend.statistics.index');
    }

    public function director_section(Request $request)
    {
        return view('backend.director_section.index');
    }

    public function downloadables(Request $request)
    {
        return view('backend.downloadables_section.index');
    }

    public function last_conference_section(Request $request)
    {
        return view('backend.last_conference_section.index');
    }

    public function aftermovie_section(Request $request)
    {
        return view('backend.aftermovie_section.index');
    }

    public function hotel_section(Request $request)
    {
        return view('backend.hotel_section.index');
    }



    public function hotel_page(Request $request)
    {
        return view('backend.hotel_page.index');
    }

    public function banners(Request $request)
    {
        return view('backend.banners.index');
    }

    public function meeting_scheduler(Request $request)
    {
        return view('backend.meeting_scheduler.index');
    }

    public function visa(Request $request)
    {
        return view('backend.visa.index');
    }

    public function covid_info(Request $request)
    {
        return view('backend.covid_info.index');
    }

    public function contact_us(Request $request)
    {
        return view('backend.contact_us.index');
    }

    public function about_location(Request $request)
    {
        return view('backend.about_location.index');
    }

    public function sponsorship(Request $request)
    {
        return view('backend.sponsorship.index');
    }

    public function custom_css(Request $request)
    {
        return view('business_settings.custom_css');
    }

    public function inquiry(Request $request)
    {
        $emails = Email::orderby('created_at','desc')->get();
        return view('backend.inquiry.index', 
            compact(
                'emails'
            )
        );
    }

    public function inquiry_view($id)
    {
        $email = Email::findOrFail(decrypt($id));
        return view('backend.inquiry.view', compact('email'));
    }

    public function registrationsList(Request $request)
    {
        $registrations = Registration::whereNotNull('number_of_people_free')->orderby('created_at','desc')->get();

        return view('backend.registrations.index', 
            compact(
                'registrations'
            )
        );
    }

    public function registrationsView($id)
    {
        $registrant = Registration::findOrFail(decrypt($id));

        $mailName = $registrant->salutation . ' ' . $registrant->firstname . ' ' . $registrant->lastname;

        $colleague_id = $registrant->colleague_id;
        $number_of_people_free = json_decode($registrant->number_of_people_free);

        $personal = array(
            'salutation' => $registrant->salutation,
            'firstname' => $registrant->firstname,
            'lastname' => $registrant->lastname,
            'shirt_size' => $registrant->shirt_size,
            'designation' => $registrant->position,
            'email' => $registrant->email,
            'mobile' => $registrant->mobile,
            
        );

        $company_data = array(
            'company_name' => $registrant->company,
            'telephone' => $registrant->telephone,
            'website' => $registrant->website,
            'iata' => $registrant->iata,
            'address' => $registrant->address,
            'city' => $registrant->city,
            'country' => $registrant->country,
            'is_joining_city_tour' => $registrant->is_joining_city_tour
        );

        $data = array(
            'personal' => $personal,
            'name' => $mailName,
            'registered_name' => $number_of_people_free,
            'event_email' => config('mail.inquiry'),
            'conference_fee' => $registrant->conference_fee,
            'vip' => $registrant->vip,
            'total_price' => $registrant->total_price,
            'shirt-size' => $registrant->shirt_size,
            'dietaries' => $registrant->dietaries,
            'sponsors' => $registrant->sponsorship,
            'advertisements' => $registrant->advertisement,
            'specializations' => $registrant->specialization,
            'services' => $registrant->services,
           
            'softwares' => $registrant->software,
            'neutralities' => $registrant->neutralities,
            'nomination' => $registrant->nomination,
            'country_interested' => $registrant->country_interested,
            'emerging_regions_interested' => $registrant->emerging_regions_interested,
            'company_data' => $company_data,
            'checker' => $registrant->early_bird,
            'learn_about_us' => $registrant->learn_about_us,
            'comment' => $registrant->comment,
        );

        return view('backend.registrations.view', compact('data'));
    }
    //dont delete

    // dont delete

    public function statistics_update(Request $request)
    {
        $statistics_icon = BusinessSetting::where('type', 'statistics_icon')->first();
        $statistics_icon->value = $request->statistics_icon;
        $statistics_icon->save();

        $statistics_title = BusinessSetting::where('type', 'statistics_title')->first();
        $statistics_title->value = $request->statistics_title;
        $statistics_title->save();

        $statistics_data = BusinessSetting::where('type', 'statistics_data')->first();
        $statistics_data->value = $request->statistics_data;
        $statistics_data->save();

        $statistics_with_plus_icon = BusinessSetting::where('type', 'statistics_with_plus_icon')->first();
        if ($request->has('statistics_with_plus_icon')) {
            $statistics_with_plus_icon->value = 1;
            $statistics_with_plus_icon->save();
        } else {
            $statistics_with_plus_icon->value = 0;
            $statistics_with_plus_icon->save();
        }

        //2nd statistics
        $statistics_icon_1 = BusinessSetting::where('type', 'statistics_icon_1')->first();
        $statistics_icon_1->value = $request->statistics_icon_1;
        $statistics_icon_1->save();

        $statistics_title_1 = BusinessSetting::where('type', 'statistics_title_1')->first();
        $statistics_title_1->value = $request->statistics_title_1;
        $statistics_title_1->save();

        $statistics_data_1 = BusinessSetting::where('type', 'statistics_data_1')->first();
        $statistics_data_1->value = $request->statistics_data_1;
        $statistics_data_1->save();

        $statistics_with_plus_icon_1 = BusinessSetting::where('type', 'statistics_with_plus_icon_1')->first();
        if ($request->has('statistics_with_plus_icon_1')) {
            $statistics_with_plus_icon_1->value = 1;
            $statistics_with_plus_icon_1->save();
        }
        else{
            $statistics_with_plus_icon_1->value = 0;
            $statistics_with_plus_icon_1->save();
        }

        //3rd statistics
        $statistics_icon_2 = BusinessSetting::where('type', 'statistics_icon_2')->first();
        $statistics_icon_2->value = $request->statistics_icon_2;
        $statistics_icon_2->save();

        $statistics_title_2 = BusinessSetting::where('type', 'statistics_title_2')->first();
        $statistics_title_2->value = $request->statistics_title_2;
        $statistics_title_2->save();

        $statistics_data_2 = BusinessSetting::where('type', 'statistics_data_2')->first();
        $statistics_data_2->value = $request->statistics_data_2;
        $statistics_data_2->save();

        $statistics_with_plus_icon_2 = BusinessSetting::where('type', 'statistics_with_plus_icon_2')->first();
        if ($request->has('statistics_with_plus_icon_2')) {
            $statistics_with_plus_icon_2->value = 1;
            $statistics_with_plus_icon_2->save();
        } else {
            $statistics_with_plus_icon_2->value = 0;
            $statistics_with_plus_icon_2->save();
        }

        //4th statistics
        $statistics_icon_3 = BusinessSetting::where('type', 'statistics_icon_3')->first();
        $statistics_icon_3->value = $request->statistics_icon_3;
        $statistics_icon_3->save();

        $statistics_title_3 = BusinessSetting::where('type', 'statistics_title_3')->first();
        $statistics_title_3->value = $request->statistics_title_3;
        $statistics_title_3->save();

        $statistics_data_3 = BusinessSetting::where('type', 'statistics_data_3')->first();
        $statistics_data_3->value = $request->statistics_data_3;
        $statistics_data_3->save();

        $statistics_with_plus_icon_3 = BusinessSetting::where('type', 'statistics_with_plus_icon_3')->first();
        if ($request->has('statistics_with_plus_icon_3')) {
            $statistics_with_plus_icon_3->value = 1;
            $statistics_with_plus_icon_3->save();
        } else {
            $statistics_with_plus_icon_3->value = 0;
            $statistics_with_plus_icon_3->save();
        }

        $statistics_color = BusinessSetting::where('type', 'statistics_color')->first();
        $statistics_color->value = $request->statistics_color;
        $statistics_color->save();

        $statistics_bg_color = BusinessSetting::where('type', 'statistics_bg_color')->first();
        $statistics_bg_color->value = $request->statistics_bg_color;
        $statistics_bg_color->save();

        flash(translate("Settings updated successfully"))->success();
        return back();
    }

    public function director_section_update(Request $request)
    {
        $director_section_title = BusinessSetting::where('type', 'director_section_title')->first();
        $director_section_title->value = $request->director_section_title;
        $director_section_title->save();

        if($request->hasFile('director_section_photo')){

            $director_section_photo = BusinessSetting::where('type', 'director_section_photo')->first();

            if($director_section_photo->value != null || $director_section_photo->value != ''){
                unlink(public_path($director_section_photo->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'.webp';
            $director_section_photo->value = 'uploads/director_section/'.$imageName;

            $image = $request->file('director_section_photo');
            $destinationPath = public_path().'/'.$director_section_photo->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $director_section_photo->save();
        }

        $director_section_name = BusinessSetting::where('type', 'director_section_name')->first();
        $director_section_name->value = $request->director_section_name;
        $director_section_name->save();

        $director_section_designation = BusinessSetting::where('type', 'director_section_designation')->first();
        $director_section_designation->value = $request->director_section_designation;
        $director_section_designation->save();

        $director_section_message = BusinessSetting::where('type', 'director_section_message')->first();
        $director_section_message->value = $request->director_section_message;
        $director_section_message->save();

        flash(translate("Settings updated successfully"))->success();
        return back();
    }

    public function downloadables_update(Request $request)
    {

        if($request->hasFile('downloadables_section_image')){

            $downloadables_section_image = BusinessSetting::where('type', 'downloadables_section_image')->first();

            if($downloadables_section_image->value != null || $downloadables_section_image->value != ''){
                unlink(public_path($downloadables_section_image->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'downloadables.webp';
            $downloadables_section_image->value = 'uploads/sections/'.$imageName;

            $image = $request->file('downloadables_section_image');
            $destinationPath = public_path().'/'.$downloadables_section_image->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $downloadables_section_image->save();
        }

        $downloadables_section_title = BusinessSetting::where('type', 'downloadables_section_title')->first();
        $downloadables_section_title->value = $request->downloadables_section_title;
        $downloadables_section_title->save();

        $downloadables_section_dl_list_button_name = BusinessSetting::where('type', 'downloadables_section_dl_list_button_name')->first();
        $downloadables_section_dl_list_button_name->value = $request->downloadables_section_dl_list_button_name;
        $downloadables_section_dl_list_button_name->save();

        $downloadables_section_dl_list_button_link = BusinessSetting::where('type', 'downloadables_section_dl_list_button_link')->first();
        $downloadables_section_dl_list_button_link->value = $request->downloadables_section_dl_list_button_link;
        $downloadables_section_dl_list_button_link->save();

        $downloadables_section_dl_list_button_bg_color = BusinessSetting::where('type', 'downloadables_section_dl_list_button_bg_color')->first();
        $downloadables_section_dl_list_button_bg_color->value = $request->downloadables_section_dl_list_button_bg_color;
        $downloadables_section_dl_list_button_bg_color->save();

        $downloadables_section_dl_list_button_text_color = BusinessSetting::where('type', 'downloadables_section_dl_list_button_text_color')->first();
        $downloadables_section_dl_list_button_text_color->value = $request->downloadables_section_dl_list_button_text_color;
        $downloadables_section_dl_list_button_text_color->save();

        flash(translate("Settings updated successfully"))->success();
        return back();
    }

    public function last_conference_section_update(Request $request)
    {
        $last_conference_section_title = BusinessSetting::where('type', 'last_conference_section_title')->first();
        $last_conference_section_title->value = $request->last_conference_section_title;
        $last_conference_section_title->save();

        if(isset($request->last_conference_section_details)) {
            $last_conference_section_details = BusinessSetting::where('type', 'last_conference_section_details')->first();
            $last_conference_section_details->value = $request->last_conference_section_details;
            $last_conference_section_details->save();
        } else {
            $last_conference_section_details = BusinessSetting::where('type', 'last_conference_section_details')->first();
            $last_conference_section_details->value = $request->last_conference_section_details;
            $last_conference_section_details->save();
        }

        $last_conference_section_button_name = BusinessSetting::where('type', 'last_conference_section_button_name')->first();
        $last_conference_section_button_name->value = $request->last_conference_section_button_name;
        $last_conference_section_button_name->save();

        $last_conference_section_button_link = BusinessSetting::where('type', 'last_conference_section_button_link')->first();
        $last_conference_section_button_link->value = $request->last_conference_section_button_link;
        $last_conference_section_button_link->save();

        $last_conference_section_image_link_1 = BusinessSetting::where('type', 'last_conference_section_image_link_1')->first();
        $last_conference_section_image_link_1->value = $request->last_conference_section_image_link_1;
        $last_conference_section_image_link_1->save();

        $last_conference_section_image_link_2 = BusinessSetting::where('type', 'last_conference_section_image_link_2')->first();
        $last_conference_section_image_link_2->value = $request->last_conference_section_image_link_2;
        $last_conference_section_image_link_2->save();

        $last_conference_section_image_link_3 = BusinessSetting::where('type', 'last_conference_section_image_link_3')->first();
        $last_conference_section_image_link_3->value = $request->last_conference_section_image_link_3;
        $last_conference_section_image_link_3->save();

        $last_conference_section_image_link_4 = BusinessSetting::where('type', 'last_conference_section_image_link_4')->first();
        $last_conference_section_image_link_4->value = $request->last_conference_section_image_link_4;
        $last_conference_section_image_link_4->save();

        $last_conference_section_image_link_5 = BusinessSetting::where('type', 'last_conference_section_image_link_5')->first();
        $last_conference_section_image_link_5->value = $request->last_conference_section_image_link_5;
        $last_conference_section_image_link_5->save();

        $last_conference_section_image_link_6 = BusinessSetting::where('type', 'last_conference_section_image_link_6')->first();
        $last_conference_section_image_link_6->value = $request->last_conference_section_image_link_6;
        $last_conference_section_image_link_6->save();

        flash(translate("Settings updated successfully"))->success();
        return back();
    }

    public function aftermovie_section_update(Request $request)
    {

        if($request->hasFile('aftermovie_section_bg_image')){

            $aftermovie_section_bg_image = BusinessSetting::where('type', 'aftermovie_section_bg_image')->first();

            if($aftermovie_section_bg_image->value != null || $aftermovie_section_bg_image->value != ''){
                unlink(public_path($aftermovie_section_bg_image->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'aftermovie_bg.webp';
            $aftermovie_section_bg_image->value = 'uploads/sections/'.$imageName;

            $image = $request->file('aftermovie_section_bg_image');
            $destinationPath = public_path().'/'.$aftermovie_section_bg_image->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $aftermovie_section_bg_image->save();
        }

        if($request->hasFile('aftermovie_section_display_image')){

            $aftermovie_section_display_image = BusinessSetting::where('type', 'aftermovie_section_display_image')->first();

            if($aftermovie_section_display_image->value != null || $aftermovie_section_display_image->value != ''){
                unlink(public_path($aftermovie_section_display_image->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'aftermovie.webp';
            $aftermovie_section_display_image->value = 'uploads/sections/'.$imageName;

            $image = $request->file('aftermovie_section_display_image');
            $destinationPath = public_path().'/'.$aftermovie_section_display_image->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $aftermovie_section_display_image->save();
        }

        $aftermovie_section_title = BusinessSetting::where('type', 'aftermovie_section_title')->first();
        $aftermovie_section_title->value = $request->aftermovie_section_title;
        $aftermovie_section_title->save();

        $aftermovie_section_descriptions = BusinessSetting::where('type', 'aftermovie_section_descriptions')->first();
        $aftermovie_section_descriptions->value = $request->aftermovie_section_descriptions;
        $aftermovie_section_descriptions->save();

        $aftermovie_section_btn_name = BusinessSetting::where('type', 'aftermovie_section_btn_name')->first();
        $aftermovie_section_btn_name->value = $request->aftermovie_section_btn_name;
        $aftermovie_section_btn_name->save();

        $aftermovie_section_btn_link = BusinessSetting::where('type', 'aftermovie_section_btn_link')->first();
        $aftermovie_section_btn_link->value = $request->aftermovie_section_btn_link;
        $aftermovie_section_btn_link->save();

        flash(translate("Settings updated successfully"))->success();
        return back();
    }

    public function hotel_section_update(Request $request)
    {
        if($request->hasFile('banners_hotel_desktop')){

            $banners_hotel_desktop = BusinessSetting::where('type', 'banners_hotel_desktop')->first();

            if($banners_hotel_desktop->value != null || $banners_hotel_desktop->value != ''){
                unlink(public_path($banners_hotel_desktop->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'hotel.webp';
            $banners_hotel_desktop->value = 'uploads/banners/'.$imageName;

            $image = $request->file('banners_hotel_desktop');
            $destinationPath = public_path().'/'.$banners_hotel_desktop->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $banners_hotel_desktop->save();
        }

        if($request->hasFile('banners_hotel_mobile')){

            $banners_hotel_mobile = BusinessSetting::where('type', 'banners_hotel_mobile')->first();

            if($banners_hotel_mobile->value != null || $banners_hotel_mobile->value != ''){
                unlink(public_path($banners_hotel_mobile->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'hotel.webp';
            $banners_hotel_mobile->value = 'uploads/banners/'.$imageName;

            $image = $request->file('banners_hotel_mobile');
            $destinationPath = public_path().'/'.$banners_hotel_mobile->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $banners_hotel_mobile->save();
        }

        if($request->hasFile('hotel_section_image1')){

            $hotel_section_image1 = BusinessSetting::where('type', 'hotel_section_image1')->first();

            if($hotel_section_image1->value != null || $hotel_section_image1->value != ''){
                unlink(public_path($hotel_section_image1->value));
            }

            $imageName1 = date('d-m-Y-H-i').'-'.Str::random(5).'h1.webp';
            $hotel_section_image1->value = 'uploads/hotel/'.$imageName1;

            $image1 = $request->file('hotel_section_image1');
            $destinationPath1 = public_path().'/'.$hotel_section_image1->value;
            $img1 = Image::make($image1->getRealPath());
            $img1->save($destinationPath1,90);

            $hotel_section_image1->save();
        }

        if($request->hasFile('hotel_section_image2')){

            $hotel_section_image2 = BusinessSetting::where('type', 'hotel_section_image2')->first();

            if($hotel_section_image2->value != null || $hotel_section_image2->value != ''){
                unlink(public_path($hotel_section_image2->value));
            }

            $imageName2 = date('d-m-Y-H-i').'-'.Str::random(5).'h2.webp';
            $hotel_section_image2->value = 'uploads/hotel/'.$imageName2;

            $image2 = $request->file('hotel_section_image2');
            $destinationPath2 = public_path().'/'.$hotel_section_image2->value;
            $img2 = Image::make($image2->getRealPath());
            $img2->save($destinationPath2,90);

            $hotel_section_image2->save();
        }

        if($request->hasFile('hotel_section_image3')){

            $hotel_section_image3 = BusinessSetting::where('type', 'hotel_section_image3')->first();

            if($hotel_section_image3->value != null || $hotel_section_image3->value != ''){
                unlink(public_path($hotel_section_image3->value));
            }

            $imageName3 = date('d-m-Y-H-i').'-'.Str::random(5).'h3.webp';
            $hotel_section_image3->value = 'uploads/hotel/'.$imageName3;

            $image3 = $request->file('hotel_section_image3');
            $destinationPath3 = public_path().'/'.$hotel_section_image3->value;
            $img3 = Image::make($image3->getRealPath());
            $img3->save($destinationPath3,90);

            $hotel_section_image3->save();
        }

        if($request->hasFile('hotel_section_image4')){

            $hotel_section_image4 = BusinessSetting::where('type', 'hotel_section_image4')->first();

            if($hotel_section_image4->value != null || $hotel_section_image4->value != ''){
                unlink(public_path($hotel_section_image4->value));
            }

            $imageName4 = date('d-m-Y-H-i').'-'.Str::random(5).'h4.webp';
            $hotel_section_image4->value = 'uploads/hotel/'.$imageName4;

            $image4 = $request->file('hotel_section_image4');
            $destinationPath4 = public_path().'/'.$hotel_section_image4->value;
            $img4 = Image::make($image4->getRealPath());
            $img4->save($destinationPath4,90);

            $hotel_section_image4->save();
        }

        if($request->hasFile('hotel_section_image5')){

            $hotel_section_image5 = BusinessSetting::where('type', 'hotel_section_image5')->first();

            if($hotel_section_image5->value != null || $hotel_section_image5->value != ''){
                unlink(public_path($hotel_section_image5->value));
            }

            $imageName5 = date('d-m-Y-H-i').'-'.Str::random(5).'h5.webp';
            $hotel_section_image5->value = 'uploads/hotel/'.$imageName5;

            $image5 = $request->file('hotel_section_image5');
            $destinationPath5 = public_path().'/'.$hotel_section_image5->value;
            $img5 = Image::make($image5->getRealPath());
            $img5->save($destinationPath5,90);

            $hotel_section_image5->save();
        }

        if($request->hasFile('hotel_section_image6')){

            $hotel_section_image6 = BusinessSetting::where('type', 'hotel_section_image6')->first();

            if($hotel_section_image6->value != null || $hotel_section_image6->value != ''){
                unlink(public_path($hotel_section_image6->value));
            }

            $imageName6 = date('d-m-Y-H-i').'-'.Str::random(5).'h6.webp';
            $hotel_section_image6->value = 'uploads/hotel/'.$imageName6;

            $image6 = $request->file('hotel_section_image6');
            $destinationPath6 = public_path().'/'.$hotel_section_image6->value;
            $img6 = Image::make($image6->getRealPath());
            $img6->save($destinationPath6,90);

            $hotel_section_image6->save();
        }

        if(isset($request->hotel_section_home_title)) {
            $hotel_section_home_title = BusinessSetting::where('type', 'hotel_section_home_title')->first();
            $hotel_section_home_title->value = $request->hotel_section_home_title;
            $hotel_section_home_title->save();
        }

        if(isset($request->hotel_section_main_title)) {
            $hotel_section_main_title = BusinessSetting::where('type', 'hotel_section_main_title')->first();
            $hotel_section_main_title->value = $request->hotel_section_main_title;
            $hotel_section_main_title->save();
        }

        if(isset($request->hotel_section_short_description)) {
            $hotel_section_short_description = BusinessSetting::where('type', 'hotel_section_short_description')->first();
            $hotel_section_short_description->value = $request->hotel_section_short_description;
            $hotel_section_short_description->save();
        }

        if(isset($request->hotel_section_home_description)) {
            $hotel_section_home_description = BusinessSetting::where('type', 'hotel_section_home_description')->first();
            $hotel_section_home_description->value = $request->hotel_section_home_description;
            $hotel_section_home_description->save();
        }

        if(isset($request->hotel_section_description)) {
            $hotel_section_description = BusinessSetting::where('type', 'hotel_section_description')->first();
            $hotel_section_description->value = $request->hotel_section_description;
            $hotel_section_description->save();
        }

        if(isset($request->hotel_section_location)) {
            $hotel_section_location = BusinessSetting::where('type', 'hotel_section_location')->first();
            $hotel_section_location->value = $request->hotel_section_location;
            $hotel_section_location->save();
        } else {
            $hotel_section_location = BusinessSetting::where('type', 'hotel_section_location')->first();
            $hotel_section_location->value = $request->hotel_section_location;
            $hotel_section_location->save();
        }

        if(isset($request->hotel_section_contact_number)) {
            $hotel_section_contact_number = BusinessSetting::where('type', 'hotel_section_contact_number')->first();
            $hotel_section_contact_number->value = $request->hotel_section_contact_number;
            $hotel_section_contact_number->save();
        } else {
            $hotel_section_contact_number = BusinessSetting::where('type', 'hotel_section_contact_number')->first();
            $hotel_section_contact_number->value = $request->hotel_section_contact_number;
            $hotel_section_contact_number->save();
        }

        if(isset($request->hotel_section_email)) {
            $hotel_section_email = BusinessSetting::where('type', 'hotel_section_email')->first();
            $hotel_section_email->value = $request->hotel_section_email;
            $hotel_section_email->save();
        } else {
            $hotel_section_email = BusinessSetting::where('type', 'hotel_section_email')->first();
            $hotel_section_email->value = $request->hotel_section_email;
            $hotel_section_email->save();
        }

        if(isset($request->hotel_section_room_rates)) {
            $hotel_section_room_rates = BusinessSetting::where('type', 'hotel_section_room_rates')->first();
            $hotel_section_room_rates->value = $request->hotel_section_room_rates;
            $hotel_section_room_rates->save();
        } else {
            $hotel_section_room_rates = BusinessSetting::where('type', 'hotel_section_room_rates')->first();
            $hotel_section_room_rates->value = $request->hotel_section_room_rates;
            $hotel_section_room_rates->save();
        }

        if(isset($request->hotel_section_inclusions)) {
            $hotel_section_inclusions = BusinessSetting::where('type', 'hotel_section_inclusions')->first();
            $hotel_section_inclusions->value = $request->hotel_section_inclusions;
            $hotel_section_inclusions->save();
        } else {
            $hotel_section_inclusions = BusinessSetting::where('type', 'hotel_section_inclusions')->first();
            $hotel_section_inclusions->value = $request->hotel_section_inclusions;
            $hotel_section_inclusions->save();
        }

        if(isset($request->hotel_section_note)) {
            $hotel_section_note = BusinessSetting::where('type', 'hotel_section_note')->first();
            $hotel_section_note->value = $request->hotel_section_note;
            $hotel_section_note->save();
        } else {
            $hotel_section_note = BusinessSetting::where('type', 'hotel_section_note')->first();
            $hotel_section_note->value = $request->hotel_section_note;
            $hotel_section_note->save();
        }

        flash(translate("Settings updated successfully"))->success();
        return back();
    }

    public function banner_image_update(Request $request)
    {
        if($request->hasFile('orientation_website_banner')){

            $orientation_website_banner = BusinessSetting::where('type', 'orientation_website_banner')->first();

            if($orientation_website_banner->value != null || $orientation_website_banner->value != ''){
                unlink(public_path($orientation_website_banner->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'.webp';
            $orientation_website_banner->value = 'uploads/orientation_website_banner/'.$imageName;

            $image = $request->file('orientation_website_banner');
            $destinationPath = public_path().'/'.$orientation_website_banner->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $orientation_website_banner->save();
        }

        flash(translate("Settings updated successfully"))->success();
        return back();
    }
    
    public function countdown_section_update(Request $request)
    {
        $home_timer_time_left_before_event = BusinessSetting::where('type', 'home_timer_time_left_before_event')->first();
        $home_timer_time_left_before_event->value = $request->home_timer_time_left_before_event;
        $home_timer_time_left_before_event->save();

        $home_timer_launch_of_scheduler = BusinessSetting::where('type', 'home_timer_launch_of_scheduler')->first();
        $home_timer_launch_of_scheduler->value = $request->home_timer_launch_of_scheduler;
        $home_timer_launch_of_scheduler->save();

        flash(translate("Settings updated successfully"))->success();
        return back();
    }

    public function registration_section_update(Request $request)
    {
        $registration_section_link = BusinessSetting::where('type', 'registration_section_link')->first();
        $registration_section_link->value = $request->registration_section_link;
        $registration_section_link->save();

        flash(translate("Settings updated successfully"))->success();
        return back();
    }

    public function agenda_section_update(Request $request)
    {
        $agenda_section_title_and_time = BusinessSetting::where('type', 'agenda_section_title_and_time')->first();
        $agenda_section_title_and_time->value = $request->agenda_section_title_and_time;
        $agenda_section_title_and_time->save();

        $agenda_section_date = BusinessSetting::where('type', 'agenda_section_date')->first();
        $agenda_section_date->value = $request->agenda_section_date;
        $agenda_section_date->save();

        $agenda_items = BusinessSetting::where('type', 'agenda_items')->first();
        $agenda_items->value = implode('|',$request->agenda_items);
        $agenda_items->save();

        flash(translate("Settings updated successfully"))->success();
        return back();
    }

    public function nav_section_update(Request $request)
    {
        $nav_main_page_link = BusinessSetting::where('type', 'nav_main_page_link')->first();
        $nav_main_page_link->value = $request->nav_main_page_link;
        $nav_main_page_link->save();

        $nav_main_page_css_style = BusinessSetting::where('type', 'nav_main_page_css_style')->first();
        $nav_main_page_css_style->value = $request->nav_main_page_css_style;
        $nav_main_page_css_style->save();

        $nav_agenda_css_style = BusinessSetting::where('type', 'nav_agenda_css_style')->first();
        $nav_agenda_css_style->value = $request->nav_agenda_css_style;
        $nav_agenda_css_style->save();

        $nav_contact_us_css_style = BusinessSetting::where('type', 'nav_contact_us_css_style')->first();
        $nav_contact_us_css_style->value = $request->nav_contact_us_css_style;
        $nav_contact_us_css_style->save();

        $nav_register_now_css_style = BusinessSetting::where('type', 'nav_register_now_css_style')->first();
        $nav_register_now_css_style->value = $request->nav_register_now_css_style;
        $nav_register_now_css_style->save();

        flash(translate("Settings updated successfully"))->success();
        return back();
    }

    public function banners_update(Request $request)
    {
        //about us
        if($request->hasFile('banners_about_us_desktop')){

            $banners_about_us_desktop = BusinessSetting::where('type', 'banners_about_us_desktop')->first();

            if($banners_about_us_desktop->value != null || $banners_about_us_desktop->value != ''){
                unlink(public_path($banners_about_us_desktop->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'about_us.webp';
            $banners_about_us_desktop->value = 'uploads/banners/'.$imageName;

            $image = $request->file('banners_about_us_desktop');
            $destinationPath = public_path().'/'.$banners_about_us_desktop->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $banners_about_us_desktop->save();
        }

        if($request->hasFile('banners_about_us_mobile')){

            $banners_about_us_mobile = BusinessSetting::where('type', 'banners_about_us_mobile')->first();

            if($banners_about_us_mobile->value != null || $banners_about_us_mobile->value != ''){
                unlink(public_path($banners_about_us_mobile->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'about_us.webp';
            $banners_about_us_mobile->value = 'uploads/banners/'.$imageName;

            $image = $request->file('banners_about_us_mobile');
            $destinationPath = public_path().'/'.$banners_about_us_mobile->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $banners_about_us_mobile->save();
        }

        //agenda
        if(isset($request->agenda_page_title)){
            $agenda_page_title = BusinessSetting::where('type', 'agenda_page_title')->first();
            $agenda_page_title->value = $request->agenda_page_title;
            $agenda_page_title->save();
        }

        if($request->hasFile('banners_agenda_desktop')){

            $banners_agenda_desktop = BusinessSetting::where('type', 'banners_agenda_desktop')->first();

            if($banners_agenda_desktop->value != null || $banners_agenda_desktop->value != ''){
                unlink(public_path($banners_agenda_desktop->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'agenda.webp';
            $banners_agenda_desktop->value = 'uploads/banners/'.$imageName;

            $image = $request->file('banners_agenda_desktop');
            $destinationPath = public_path().'/'.$banners_agenda_desktop->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $banners_agenda_desktop->save();
        }

        if($request->hasFile('banners_agenda_mobile')){

            $banners_agenda_mobile = BusinessSetting::where('type', 'banners_agenda_mobile')->first();

            if($banners_agenda_mobile->value != null || $banners_agenda_mobile->value != ''){
                unlink(public_path($banners_agenda_mobile->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'agenda.webp';
            $banners_agenda_mobile->value = 'uploads/banners/'.$imageName;

            $image = $request->file('banners_agenda_mobile');
            $destinationPath = public_path().'/'.$banners_agenda_mobile->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $banners_agenda_mobile->save();
        }

        //meeting cost
        if(isset($request->meeting_cost_page_title)){
            $meeting_cost_page_title = BusinessSetting::where('type', 'meeting_cost_page_title')->first();
            $meeting_cost_page_title->value = $request->meeting_cost_page_title;
            $meeting_cost_page_title->save();
        }

        if(isset($request->meeting_cost_page_description)){
            $meeting_cost_page_description = BusinessSetting::where('type', 'meeting_cost_page_description')->first();
            $meeting_cost_page_description->value = $request->meeting_cost_page_description;
            $meeting_cost_page_description->save();
        }

        if(isset($request->meeting_cost_page_css)){
            $meeting_cost_page_css = BusinessSetting::where('type', 'meeting_cost_page_css')->first();
            $meeting_cost_page_css->value = $request->meeting_cost_page_css;
            $meeting_cost_page_css->save();
        }

        if(isset($request->meeting_cost_page_design)){
            $meeting_cost_page_design = BusinessSetting::where('type', 'meeting_cost_page_design')->first();
            $meeting_cost_page_design->value = $request->meeting_cost_page_design;
            $meeting_cost_page_design->save();
        }

        if($request->hasFile('banners_meeting_cost_desktop')){

            $banners_meeting_cost_desktop = BusinessSetting::where('type', 'banners_meeting_cost_desktop')->first();

            if($banners_meeting_cost_desktop->value != null || $banners_meeting_cost_desktop->value != ''){
                unlink(public_path($banners_meeting_cost_desktop->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'meeting_cost.webp';
            $banners_meeting_cost_desktop->value = 'uploads/banners/'.$imageName;

            $image = $request->file('banners_meeting_cost_desktop');
            $destinationPath = public_path().'/'.$banners_meeting_cost_desktop->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $banners_meeting_cost_desktop->save();
        }

        if($request->hasFile('banners_meeting_cost_mobile')){

            $banners_meeting_cost_mobile = BusinessSetting::where('type', 'banners_meeting_cost_mobile')->first();

            if($banners_meeting_cost_mobile->value != null || $banners_meeting_cost_mobile->value != ''){
                unlink(public_path($banners_meeting_cost_mobile->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'meeting_cost.webp';
            $banners_meeting_cost_mobile->value = 'uploads/banners/'.$imageName;

            $image = $request->file('banners_meeting_cost_mobile');
            $destinationPath = public_path().'/'.$banners_meeting_cost_mobile->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $banners_meeting_cost_mobile->save();
        }

        //meeting scheduler
        if(isset($request->meeting_scheduler_title)){
            $meeting_scheduler_title = BusinessSetting::where('type', 'meeting_scheduler_title')->first();
            $meeting_scheduler_title->value = $request->meeting_scheduler_title;
            $meeting_scheduler_title->save();
        }

        if(isset($request->meeting_scheduler_details)){
            $meeting_scheduler_details = BusinessSetting::where('type', 'meeting_scheduler_details')->first();
            $meeting_scheduler_details->value = $request->meeting_scheduler_details;
            $meeting_scheduler_details->save();
        }

        if($request->hasFile('banners_meeting_scheduler_desktop')){

            $banners_meeting_scheduler_desktop = BusinessSetting::where('type', 'banners_meeting_scheduler_desktop')->first();

            if($banners_meeting_scheduler_desktop->value != null || $banners_meeting_scheduler_desktop->value != ''){
                unlink(public_path($banners_meeting_scheduler_desktop->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'meeting_scheduler.webp';
            $banners_meeting_scheduler_desktop->value = 'uploads/banners/'.$imageName;

            $image = $request->file('banners_meeting_scheduler_desktop');
            $destinationPath = public_path().'/'.$banners_meeting_scheduler_desktop->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $banners_meeting_scheduler_desktop->save();
        }

        if($request->hasFile('banners_meeting_scheduler_mobile')){

            $banners_meeting_scheduler_mobile = BusinessSetting::where('type', 'banners_meeting_scheduler_mobile')->first();

            if($banners_meeting_scheduler_mobile->value != null || $banners_meeting_scheduler_mobile->value != ''){
                unlink(public_path($banners_meeting_scheduler_mobile->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'meeting_scheduler.webp';
            $banners_meeting_scheduler_mobile->value = 'uploads/banners/'.$imageName;

            $image = $request->file('banners_meeting_scheduler_mobile');
            $destinationPath = public_path().'/'.$banners_meeting_scheduler_mobile->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $banners_meeting_scheduler_mobile->save();
        }

        //visa
        if($request->hasFile('banners_visa_desktop')){

            $banners_visa_desktop = BusinessSetting::where('type', 'banners_visa_desktop')->first();

            if($banners_visa_desktop->value != null || $banners_visa_desktop->value != ''){
                unlink(public_path($banners_visa_desktop->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'visa.webp';
            $banners_visa_desktop->value = 'uploads/banners/'.$imageName;

            $image = $request->file('banners_visa_desktop');
            $destinationPath = public_path().'/'.$banners_visa_desktop->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $banners_visa_desktop->save();
        }

        if($request->hasFile('banners_visa_mobile')){

            $banners_visa_mobile = BusinessSetting::where('type', 'banners_visa_mobile')->first();

            if($banners_visa_mobile->value != null || $banners_visa_mobile->value != ''){
                unlink(public_path($banners_visa_mobile->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'visa.webp';
            $banners_visa_mobile->value = 'uploads/banners/'.$imageName;

            $image = $request->file('banners_visa_mobile');
            $destinationPath = public_path().'/'.$banners_visa_mobile->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $banners_visa_mobile->save();
        }

        //covid_info
        if($request->hasFile('banners_covid_info_desktop')){

            $banners_covid_info_desktop = BusinessSetting::where('type', 'banners_covid_info_desktop')->first();

            if($banners_covid_info_desktop->value != null || $banners_covid_info_desktop->value != ''){
                unlink(public_path($banners_covid_info_desktop->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'covid_info.webp';
            $banners_covid_info_desktop->value = 'uploads/banners/'.$imageName;

            $image = $request->file('banners_covid_info_desktop');
            $destinationPath = public_path().'/'.$banners_covid_info_desktop->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $banners_covid_info_desktop->save();
        }

        if($request->hasFile('banners_covid_info_mobile')){

            $banners_covid_info_mobile = BusinessSetting::where('type', 'banners_covid_info_mobile')->first();

            if($banners_covid_info_mobile->value != null || $banners_covid_info_mobile->value != ''){
                unlink(public_path($banners_covid_info_mobile->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'covid_info.webp';
            $banners_covid_info_mobile->value = 'uploads/banners/'.$imageName;

            $image = $request->file('banners_covid_info_mobile');
            $destinationPath = public_path().'/'.$banners_covid_info_mobile->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $banners_covid_info_mobile->save();
        }

        if(isset($request->covid_info_title)){
            $covid_info_title = BusinessSetting::where('type', 'covid_info_title')->first();
            $covid_info_title->value = $request->covid_info_title;
            $covid_info_title->save();
        }
        if(isset($request->covid_info_descriptions)){
            $covid_info_descriptions = BusinessSetting::where('type', 'covid_info_descriptions')->first();
            $covid_info_descriptions->value = $request->covid_info_descriptions;
            $covid_info_descriptions->save();
        }

        //about_location
        if(isset($request->about_location_slug)){
            $about_location_slug = BusinessSetting::where('type', 'about_location_slug')->first();
            $about_location_slug->value = $request->about_location_slug;
            $about_location_slug->save();
        }

        if($request->hasFile('banners_about_location_desktop')){

            $banners_about_location_desktop = BusinessSetting::where('type', 'banners_about_location_desktop')->first();

            if($banners_about_location_desktop->value != null || $banners_about_location_desktop->value != ''){
                unlink(public_path($banners_about_location_desktop->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'about_location.webp';
            $banners_about_location_desktop->value = 'uploads/banners/'.$imageName;

            $image = $request->file('banners_about_location_desktop');
            $destinationPath = public_path().'/'.$banners_about_location_desktop->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $banners_about_location_desktop->save();
        }

        if($request->hasFile('banners_about_location_mobile')){

            $banners_about_location_mobile = BusinessSetting::where('type', 'banners_about_location_mobile')->first();

            if($banners_about_location_mobile->value != null || $banners_about_location_mobile->value != ''){
                unlink(public_path($banners_about_location_mobile->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'about_location.webp';
            $banners_about_location_mobile->value = 'uploads/banners/'.$imageName;

            $image = $request->file('banners_about_location_mobile');
            $destinationPath = public_path().'/'.$banners_about_location_mobile->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $banners_about_location_mobile->save();
        }

        if(isset($request->about_location_title)){
            $about_location_title = BusinessSetting::where('type', 'about_location_title')->first();
            $about_location_title->value = $request->about_location_title;
            $about_location_title->save();
        }

        if(isset($request->about_location_details)){
            $about_location_details = BusinessSetting::where('type', 'about_location_details')->first();
            $about_location_details->value = $request->about_location_details;
            $about_location_details->save();
        }

        if($request->hasFile('about_location_collage')){

            $about_location_collage = BusinessSetting::where('type', 'about_location_collage')->first();

            if($about_location_collage->value != null || $about_location_collage->value != ''){
                unlink(public_path($about_location_collage->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'about_location.webp';
            $about_location_collage->value = 'uploads/banners/'.$imageName;

            $image = $request->file('about_location_collage');
            $destinationPath = public_path().'/'.$about_location_collage->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $about_location_collage->save();
        }

        if(isset($request->about_location_useful_article_title)){
            $about_location_useful_article_title = BusinessSetting::where('type', 'about_location_useful_article_title')->first();
            $about_location_useful_article_title->value = $request->about_location_useful_article_title;
            $about_location_useful_article_title->save();
        }

        if(isset($request->about_location_useful_article_link_1)){
            $about_location_useful_article_link_1 = BusinessSetting::where('type', 'about_location_useful_article_link_1')->first();
            $about_location_useful_article_link_1->value = $request->about_location_useful_article_link_1;
            $about_location_useful_article_link_1->save();
        }

        if($request->hasFile('about_location_useful_article_bg_img_1')){

            $about_location_useful_article_bg_img_1 = BusinessSetting::where('type', 'about_location_useful_article_bg_img_1')->first();

            if($about_location_useful_article_bg_img_1->value != null || $about_location_useful_article_bg_img_1->value != ''){
                unlink(public_path($about_location_useful_article_bg_img_1->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'useful_link_bg.webp';
            $about_location_useful_article_bg_img_1->value = 'uploads/banners/'.$imageName;

            $image = $request->file('about_location_useful_article_bg_img_1');
            $destinationPath = public_path().'/'.$about_location_useful_article_bg_img_1->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $about_location_useful_article_bg_img_1->save();
        }

        if(isset($request->about_location_useful_article_link_2)){
            $about_location_useful_article_link_2 = BusinessSetting::where('type', 'about_location_useful_article_link_2')->first();
            $about_location_useful_article_link_2->value = $request->about_location_useful_article_link_2;
            $about_location_useful_article_link_2->save();
        }

        if($request->hasFile('about_location_useful_article_bg_img_2')){

            $about_location_useful_article_bg_img_2 = BusinessSetting::where('type', 'about_location_useful_article_bg_img_2')->first();

            if($about_location_useful_article_bg_img_2->value != null || $about_location_useful_article_bg_img_2->value != ''){
                unlink(public_path($about_location_useful_article_bg_img_2->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'useful_link_bg.webp';
            $about_location_useful_article_bg_img_2->value = 'uploads/banners/'.$imageName;

            $image = $request->file('about_location_useful_article_bg_img_2');
            $destinationPath = public_path().'/'.$about_location_useful_article_bg_img_2->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $about_location_useful_article_bg_img_2->save();
        }

        if(isset($request->about_location_useful_article_link_3)){
            $about_location_useful_article_link_3 = BusinessSetting::where('type', 'about_location_useful_article_link_3')->first();
            $about_location_useful_article_link_3->value = $request->about_location_useful_article_link_3;
            $about_location_useful_article_link_3->save();
        }

        if($request->hasFile('about_location_useful_article_bg_img_3')){

            $about_location_useful_article_bg_img_3 = BusinessSetting::where('type', 'about_location_useful_article_bg_img_3')->first();

            if($about_location_useful_article_bg_img_3->value != null || $about_location_useful_article_bg_img_3->value != ''){
                unlink(public_path($about_location_useful_article_bg_img_3->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'useful_link_bg.webp';
            $about_location_useful_article_bg_img_3->value = 'uploads/banners/'.$imageName;

            $image = $request->file('about_location_useful_article_bg_img_3');
            $destinationPath = public_path().'/'.$about_location_useful_article_bg_img_3->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $about_location_useful_article_bg_img_3->save();
        }

        if(isset($request->about_location_useful_article_link_4)){
            $about_location_useful_article_link_4 = BusinessSetting::where('type', 'about_location_useful_article_link_4')->first();
            $about_location_useful_article_link_4->value = $request->about_location_useful_article_link_4;
            $about_location_useful_article_link_4->save();
        }

        if($request->hasFile('about_location_useful_article_bg_img_4')){

            $about_location_useful_article_bg_img_4 = BusinessSetting::where('type', 'about_location_useful_article_bg_img_4')->first();

            if($about_location_useful_article_bg_img_4->value != null || $about_location_useful_article_bg_img_4->value != ''){
                unlink(public_path($about_location_useful_article_bg_img_4->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'useful_link_bg.webp';
            $about_location_useful_article_bg_img_4->value = 'uploads/banners/'.$imageName;

            $image = $request->file('about_location_useful_article_bg_img_4');
            $destinationPath = public_path().'/'.$about_location_useful_article_bg_img_4->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $about_location_useful_article_bg_img_4->save();
        }

        //contact us
        if($request->hasFile('banners_contact_us_desktop')){

            $banners_contact_us_desktop = BusinessSetting::where('type', 'banners_contact_us_desktop')->first();

            if($banners_contact_us_desktop->value != null || $banners_contact_us_desktop->value != ''){
                unlink(public_path($banners_contact_us_desktop->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'contact_us.webp';
            $banners_contact_us_desktop->value = 'uploads/banners/'.$imageName;

            $image = $request->file('banners_contact_us_desktop');
            $destinationPath = public_path().'/'.$banners_contact_us_desktop->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $banners_contact_us_desktop->save();
        }

        if($request->hasFile('banners_contact_us_mobile')){

            $banners_contact_us_mobile = BusinessSetting::where('type', 'banners_contact_us_mobile')->first();

            if($banners_contact_us_mobile->value != null || $banners_contact_us_mobile->value != ''){
                unlink(public_path($banners_contact_us_mobile->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'contact_us.webp';
            $banners_contact_us_mobile->value = 'uploads/banners/'.$imageName;

            $image = $request->file('banners_contact_us_mobile');
            $destinationPath = public_path().'/'.$banners_contact_us_mobile->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $banners_contact_us_mobile->save();
        }

        //sposorships
        if($request->hasFile('banners_sponsorship_desktop')){

            $banners_sponsorship_desktop = BusinessSetting::where('type', 'banners_sponsorship_desktop')->first();

            if($banners_sponsorship_desktop->value != null || $banners_sponsorship_desktop->value != ''){
                unlink(public_path($banners_sponsorship_desktop->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'sponsorship.webp';
            $banners_sponsorship_desktop->value = 'uploads/banners/'.$imageName;

            $image = $request->file('banners_sponsorship_desktop');
            $destinationPath = public_path().'/'.$banners_sponsorship_desktop->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $banners_sponsorship_desktop->save();
        }

        if($request->hasFile('banners_sponsorship_mobile')){

            $banners_sponsorship_mobile = BusinessSetting::where('type', 'banners_sponsorship_mobile')->first();

            if($banners_sponsorship_mobile->value != null || $banners_sponsorship_mobile->value != ''){
                unlink(public_path($banners_sponsorship_mobile->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'sponsorship.webp';
            $banners_sponsorship_mobile->value = 'uploads/banners/'.$imageName;

            $image = $request->file('banners_sponsorship_mobile');
            $destinationPath = public_path().'/'.$banners_sponsorship_mobile->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $banners_sponsorship_mobile->save();
        }

        if(isset($request->sponsorships_page_title)){
            $sponsorships_page_title = BusinessSetting::where('type', 'sponsorships_page_title')->first();
            $sponsorships_page_title->value = $request->sponsorships_page_title;
            $sponsorships_page_title->save();
        }
        if(isset($request->sponsorships_page_details)){
            $sponsorships_page_details = BusinessSetting::where('type', 'sponsorships_page_details')->first();
            $sponsorships_page_details->value = $request->sponsorships_page_details;
            $sponsorships_page_details->save();
        }
        if(isset($request->sponsorships_page_whatsapp_number)){
            $sponsorships_page_whatsapp_number = BusinessSetting::where('type', 'sponsorships_page_whatsapp_number')->first();
            $sponsorships_page_whatsapp_number->value = $request->sponsorships_page_whatsapp_number;
            $sponsorships_page_whatsapp_number->save();
        } else {
            $sponsorships_page_whatsapp_number = BusinessSetting::where('type', 'sponsorships_page_whatsapp_number')->first();
            $sponsorships_page_whatsapp_number->value = $request->sponsorships_page_whatsapp_number;
            $sponsorships_page_whatsapp_number->save();
        }

        //benefits
        if(isset($request->benefit_section_title)){
            $benefit_section_title = BusinessSetting::where('type', 'benefit_section_title')->first();
            $benefit_section_title->value = $request->benefit_section_title;
            $benefit_section_title->save();
        }
        if(isset($request->benefit_section_description)){
            $benefit_section_description = BusinessSetting::where('type', 'benefit_section_description')->first();
            $benefit_section_description->value = $request->benefit_section_description;
            $benefit_section_description->save();
        }

        flash(translate("Settings updated successfully"))->success();
        return back();
    }

    public function meeting_scheduler_update(Request $request)
    {
        $meeting_scheduler_title_1 = BusinessSetting::where('type', 'meeting_scheduler_title_1')->first();
        $meeting_scheduler_title_1->value = $request->meeting_scheduler_title_1;
        $meeting_scheduler_title_1->save();

        if($request->hasFile('meeting_scheduler_icon_1')){

            $meeting_scheduler_icon_1 = BusinessSetting::where('type', 'meeting_scheduler_icon_1')->first();

            if($meeting_scheduler_icon_1->value != null || $meeting_scheduler_icon_1->value != ''){
                unlink(public_path($meeting_scheduler_icon_1->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'icons.webp';
            $meeting_scheduler_icon_1->value = 'uploads/icons/'.$imageName;

            $image = $request->file('meeting_scheduler_icon_1');
            $destinationPath = public_path().'/'.$meeting_scheduler_icon_1->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $meeting_scheduler_icon_1->save();
        }

        $meeting_scheduler_title_2 = BusinessSetting::where('type', 'meeting_scheduler_title_2')->first();
        $meeting_scheduler_title_2->value = $request->meeting_scheduler_title_2;
        $meeting_scheduler_title_2->save();

        if($request->hasFile('meeting_scheduler_icon_2')){

            $meeting_scheduler_icon_2 = BusinessSetting::where('type', 'meeting_scheduler_icon_2')->first();

            if($meeting_scheduler_icon_2->value != null || $meeting_scheduler_icon_2->value != ''){
                unlink(public_path($meeting_scheduler_icon_2->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'icons.webp';
            $meeting_scheduler_icon_2->value = 'uploads/icons/'.$imageName;

            $image = $request->file('meeting_scheduler_icon_2');
            $destinationPath = public_path().'/'.$meeting_scheduler_icon_2->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $meeting_scheduler_icon_2->save();
        }

        $meeting_scheduler_title_3 = BusinessSetting::where('type', 'meeting_scheduler_title_3')->first();
        $meeting_scheduler_title_3->value = $request->meeting_scheduler_title_3;
        $meeting_scheduler_title_3->save();

        if($request->hasFile('meeting_scheduler_icon_3')){

            $meeting_scheduler_icon_3 = BusinessSetting::where('type', 'meeting_scheduler_icon_3')->first();

            if($meeting_scheduler_icon_3->value != null || $meeting_scheduler_icon_3->value != ''){
                unlink(public_path($meeting_scheduler_icon_3->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'icons.webp';
            $meeting_scheduler_icon_3->value = 'uploads/icons/'.$imageName;

            $image = $request->file('meeting_scheduler_icon_3');
            $destinationPath = public_path().'/'.$meeting_scheduler_icon_3->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $meeting_scheduler_icon_3->save();
        }

        $meeting_scheduler_title_4 = BusinessSetting::where('type', 'meeting_scheduler_title_4')->first();
        $meeting_scheduler_title_4->value = $request->meeting_scheduler_title_4;
        $meeting_scheduler_title_4->save();

        if($request->hasFile('meeting_scheduler_icon_4')){

            $meeting_scheduler_icon_4 = BusinessSetting::where('type', 'meeting_scheduler_icon_4')->first();

            if($meeting_scheduler_icon_4->value != null || $meeting_scheduler_icon_4->value != ''){
                unlink(public_path($meeting_scheduler_icon_4->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'icons.webp';
            $meeting_scheduler_icon_4->value = 'uploads/icons/'.$imageName;

            $image = $request->file('meeting_scheduler_icon_4');
            $destinationPath = public_path().'/'.$meeting_scheduler_icon_4->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $meeting_scheduler_icon_4->save();
        }

        $meeting_scheduler_title_5 = BusinessSetting::where('type', 'meeting_scheduler_title_5')->first();
        $meeting_scheduler_title_5->value = $request->meeting_scheduler_title_5;
        $meeting_scheduler_title_5->save();

        if($request->hasFile('meeting_scheduler_icon_5')){

            $meeting_scheduler_icon_5 = BusinessSetting::where('type', 'meeting_scheduler_icon_5')->first();

            if($meeting_scheduler_icon_5->value != null || $meeting_scheduler_icon_5->value != ''){
                unlink(public_path($meeting_scheduler_icon_5->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'icons.webp';
            $meeting_scheduler_icon_5->value = 'uploads/icons/'.$imageName;

            $image = $request->file('meeting_scheduler_icon_5');
            $destinationPath = public_path().'/'.$meeting_scheduler_icon_5->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $meeting_scheduler_icon_5->save();
        }

        flash(translate("Settings updated successfully"))->success();
        return back();
    }

    public function custom_css_update(Request $request)
    {
        $custom_css = BusinessSetting::where('type', 'custom_css')->first();
        $custom_css->value = $request->custom_css;
        $custom_css->save();

        flash(translate("Settings updated successfully"))->success();
        return back();
    }
    
    public function end_of_reg(Request $request)
    {
        return view('backend.end_of_reg.index');
    }

    public function end_of_reg_update(Request $request)
    {
        $statistics_icon_3 = BusinessSetting::where('type', 'end_of_reg_details')->first();
        $statistics_icon_3->value = $request->end_of_reg_details;
        $statistics_icon_3->save();

        flash(translate("Settings updated successfully"))->success();
        return back();
    }
    //dont delete

    //start commons updates
    public function common_secure_pass_update(Request $request)
    {

        if($request->hasFile('common_secure_pass_background_image')){

            $common_secure_pass_background_image = BusinessSetting::where('type', 'common_secure_pass_background_image')->first();

            if($common_secure_pass_background_image->value != null || $common_secure_pass_background_image->value != ''){
                unlink(public_path($common_secure_pass_background_image->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'.webp';
            $common_secure_pass_background_image->value = 'uploads/commons/'.$imageName;

            $image = $request->file('common_secure_pass_background_image');
            $destinationPath = public_path().'/'.$common_secure_pass_background_image->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $common_secure_pass_background_image->save();
        }

        $common_secure_pass_title = BusinessSetting::where('type', 'common_secure_pass_title')->first();
        $common_secure_pass_title->value = $request->common_secure_pass_title;
        $common_secure_pass_title->save();

        $common_secure_pass_description = BusinessSetting::where('type', 'common_secure_pass_description')->first();
        $common_secure_pass_description->value = $request->common_secure_pass_description;
        $common_secure_pass_description->save();

        $common_secure_pass_button_name = BusinessSetting::where('type', 'common_secure_pass_button_name')->first();
        $common_secure_pass_button_name->value = $request->common_secure_pass_button_name;
        $common_secure_pass_button_name->save();

        $common_secure_pass_button_link = BusinessSetting::where('type', 'common_secure_pass_button_link')->first();
        $common_secure_pass_button_link->value = $request->common_secure_pass_button_link;
        $common_secure_pass_button_link->save();

        $common_secure_pass_button_bg_color = BusinessSetting::where('type', 'common_secure_pass_button_bg_color')->first();
        $common_secure_pass_button_bg_color->value = $request->common_secure_pass_button_bg_color;
        $common_secure_pass_button_bg_color->save();

        $common_secure_pass_button_text_color = BusinessSetting::where('type', 'common_secure_pass_button_text_color')->first();
        $common_secure_pass_button_text_color->value = $request->common_secure_pass_button_text_color;
        $common_secure_pass_button_text_color->save();

        flash(translate("Settings updated successfully"))->success();
        return back();
    }

    public function common_sponsor_update(Request $request)
    {

        if($request->hasFile('common_sponsor_background_image')){

            $common_sponsor_background_image = BusinessSetting::where('type', 'common_sponsor_background_image')->first();

            if($common_sponsor_background_image->value != null || $common_sponsor_background_image->value != ''){
                unlink(public_path($common_sponsor_background_image->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'.webp';
            $common_sponsor_background_image->value = 'uploads/commons/'.$imageName;

            $image = $request->file('common_sponsor_background_image');
            $destinationPath = public_path().'/'.$common_sponsor_background_image->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $common_sponsor_background_image->save();
        }

        $common_sponsor_title = BusinessSetting::where('type', 'common_sponsor_title')->first();
        $common_sponsor_title->value = $request->common_sponsor_title;
        $common_sponsor_title->save();

        $common_sponsor_description = BusinessSetting::where('type', 'common_sponsor_description')->first();
        $common_sponsor_description->value = $request->common_sponsor_description;
        $common_sponsor_description->save();

        $common_sponsor_button_name = BusinessSetting::where('type', 'common_sponsor_button_name')->first();
        $common_sponsor_button_name->value = $request->common_sponsor_button_name;
        $common_sponsor_button_name->save();

        $common_sponsor_button_link = BusinessSetting::where('type', 'common_sponsor_button_link')->first();
        $common_sponsor_button_link->value = $request->common_sponsor_button_link;
        $common_sponsor_button_link->save();

        $common_sponsor_button_bg_color = BusinessSetting::where('type', 'common_sponsor_button_bg_color')->first();
        $common_sponsor_button_bg_color->value = $request->common_sponsor_button_bg_color;
        $common_sponsor_button_bg_color->save();

        $common_sponsor_button_text_color = BusinessSetting::where('type', 'common_sponsor_button_text_color')->first();
        $common_sponsor_button_text_color->value = $request->common_sponsor_button_text_color;
        $common_sponsor_button_text_color->save();

        flash(translate("Settings updated successfully"))->success();
        return back();
    }

    public function common_download_delegate_list_update(Request $request)
    {

        if($request->hasFile('common_download_delegate_list_background_image')){

            $common_download_delegate_list_background_image = BusinessSetting::where('type', 'common_download_delegate_list_background_image')->first();

            if($common_download_delegate_list_background_image->value != null || $common_download_delegate_list_background_image->value != ''){
                unlink(public_path($common_download_delegate_list_background_image->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'cddlu.webp';
            $common_download_delegate_list_background_image->value = 'uploads/commons/'.$imageName;

            $image = $request->file('common_download_delegate_list_background_image');
            $destinationPath = public_path().'/'.$common_download_delegate_list_background_image->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $common_download_delegate_list_background_image->save();
        }

        $common_download_delegate_list_title = BusinessSetting::where('type', 'common_download_delegate_list_title')->first();
        $common_download_delegate_list_title->value = $request->common_download_delegate_list_title;
        $common_download_delegate_list_title->save();

        $common_download_delegate_list_description = BusinessSetting::where('type', 'common_download_delegate_list_description')->first();
        $common_download_delegate_list_description->value = $request->common_download_delegate_list_description;
        $common_download_delegate_list_description->save();

        $common_download_delegate_list_button_name = BusinessSetting::where('type', 'common_download_delegate_list_button_name')->first();
        $common_download_delegate_list_button_name->value = $request->common_download_delegate_list_button_name;
        $common_download_delegate_list_button_name->save();

        $common_download_delegate_list_button_link = BusinessSetting::where('type', 'common_download_delegate_list_button_link')->first();
        $common_download_delegate_list_button_link->value = $request->common_download_delegate_list_button_link;
        $common_download_delegate_list_button_link->save();

        $common_download_delegate_list_button_bg_color = BusinessSetting::where('type', 'common_download_delegate_list_button_bg_color')->first();
        $common_download_delegate_list_button_bg_color->value = $request->common_download_delegate_list_button_bg_color;
        $common_download_delegate_list_button_bg_color->save();

        $common_download_delegate_list_button_text_color = BusinessSetting::where('type', 'common_download_delegate_list_button_text_color')->first();
        $common_download_delegate_list_button_text_color->value = $request->common_download_delegate_list_button_text_color;
        $common_download_delegate_list_button_text_color->save();

        flash(translate("Settings updated successfully"))->success();
        return back();
    }

    public function common_discover_update(Request $request)
    {

        if($request->hasFile('common_discover_background_image')){

            $common_discover_background_image = BusinessSetting::where('type', 'common_discover_background_image')->first();

            if($common_discover_background_image->value != null || $common_discover_background_image->value != ''){
                unlink(public_path($common_discover_background_image->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'discover.webp';
            $common_discover_background_image->value = 'uploads/commons/'.$imageName;

            $image = $request->file('common_discover_background_image');
            $destinationPath = public_path().'/'.$common_discover_background_image->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $common_discover_background_image->save();
        }

        $common_discover_title = BusinessSetting::where('type', 'common_discover_title')->first();
        $common_discover_title->value = $request->common_discover_title;
        $common_discover_title->save();

        $common_discover_description = BusinessSetting::where('type', 'common_discover_description')->first();
        $common_discover_description->value = $request->common_discover_description;
        $common_discover_description->save();

        $common_discover_button_name = BusinessSetting::where('type', 'common_discover_button_name')->first();
        $common_discover_button_name->value = $request->common_discover_button_name;
        $common_discover_button_name->save();

        $common_discover_button_link = BusinessSetting::where('type', 'common_discover_button_link')->first();
        $common_discover_button_link->value = $request->common_discover_button_link;
        $common_discover_button_link->save();

        flash(translate("Settings updated successfully"))->success();
        return back();
    }

    public function common_newsletter_update(Request $request)
    {

        if($request->hasFile('common_newsletter_background_image')){

            $common_newsletter_background_image = BusinessSetting::where('type', 'common_newsletter_background_image')->first();

            if($common_newsletter_background_image->value != null || $common_newsletter_background_image->value != ''){
                unlink(public_path($common_newsletter_background_image->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'.webp';
            $common_newsletter_background_image->value = 'uploads/commons/'.$imageName;

            $image = $request->file('common_newsletter_background_image');
            $destinationPath = public_path().'/'.$common_newsletter_background_image->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $common_newsletter_background_image->save();
        }

        $common_newsletter_title = BusinessSetting::where('type', 'common_newsletter_title')->first();
        $common_newsletter_title->value = $request->common_newsletter_title;
        $common_newsletter_title->save();

        $common_newsletter_description = BusinessSetting::where('type', 'common_newsletter_description')->first();
        $common_newsletter_description->value = $request->common_newsletter_description;
        $common_newsletter_description->save();

        $common_newsletter_button_name = BusinessSetting::where('type', 'common_newsletter_button_name')->first();
        $common_newsletter_button_name->value = $request->common_newsletter_button_name;
        $common_newsletter_button_name->save();

        $common_newsletter_button_link = BusinessSetting::where('type', 'common_newsletter_button_link')->first();
        $common_newsletter_button_link->value = $request->common_newsletter_button_link;
        $common_newsletter_button_link->save();

        if(isset($request->common_newsletter_button_data_target)){
            $common_newsletter_button_data_target = BusinessSetting::where('type', 'common_newsletter_button_data_target')->first();
            $common_newsletter_button_data_target->value = $request->common_newsletter_button_data_target;
            $common_newsletter_button_data_target->save();
        } else {
            $common_newsletter_button_data_target = BusinessSetting::where('type', 'common_newsletter_button_data_target')->first();
            $common_newsletter_button_data_target->value = $request->common_newsletter_button_data_target;
            $common_newsletter_button_data_target->save();
        }

        if(isset($request->common_newsletter_button_link_javascript)){
            $common_newsletter_button_link_javascript = BusinessSetting::where('type', 'common_newsletter_button_link_javascript')->first();
            $common_newsletter_button_link_javascript->value = $request->common_newsletter_button_link_javascript;
            $common_newsletter_button_link_javascript->save();
        } else {
            $common_newsletter_button_link_javascript = BusinessSetting::where('type', 'common_newsletter_button_link_javascript')->first();
            $common_newsletter_button_link_javascript->value = $request->common_newsletter_button_link_javascript;
            $common_newsletter_button_link_javascript->save();
        }

        $common_newsletter_button_bg_color = BusinessSetting::where('type', 'common_newsletter_button_bg_color')->first();
        $common_newsletter_button_bg_color->value = $request->common_newsletter_button_bg_color;
        $common_newsletter_button_bg_color->save();

        $common_newsletter_button_text_color = BusinessSetting::where('type', 'common_newsletter_button_text_color')->first();
        $common_newsletter_button_text_color->value = $request->common_newsletter_button_text_color;
        $common_newsletter_button_text_color->save();

        flash(translate("Settings updated successfully"))->success();
        return back();
    }
    //end commons updates




    public function activation(Request $request)
    {
        //CoreComponentRepository::instantiateShopRepository();
    	return view('business_settings.activation');
    }

    public function social_login(Request $request)
    {
        //CoreComponentRepository::instantiateShopRepository();
        return view('business_settings.social_login');
    }

    public function google_analytics(Request $request)
    {
        //CoreComponentRepository::instantiateShopRepository();
        return view('business_settings.google_analytics');
    }

    public function google_maps(Request $request)
    {
        //CoreComponentRepository::instantiateShopRepository();
        return view('business_settings.google_maps');
    }

    public function google_recaptcha(Request $request)
    {
        return view('business_settings.google_recaptcha');
    }

    public function smtp_settings(Request $request)
    {
        return view('business_settings.smtp_settings');
    }

    public function facebook_chat(Request $request)
    {
        return view('business_settings.facebook_chat');
    }

    /**
     * Update the API key's for GOOGLE analytics.
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function google_analytics_update(Request $request)
    {
        $path = base_path('.env');

        $driver = '"'.config('services.TRACKING_ID') .'"';
        $TRACKING_ID = '"'.$request->TRACKING_ID.'"';

        if (file_exists($path)) {
            if($request->TRACKING_ID){
                file_put_contents($path, str_replace(
                    'TRACKING_ID='.$driver, 'TRACKING_ID='.$TRACKING_ID, file_get_contents($path)
                ));
            }
            Artisan::call('config:cache');
        }

        $business_settings = BusinessSetting::where('type', 'google_analytics')->first();

        if ($request->has('google_analytics')) {
            $business_settings->value = 1;
            $business_settings->save();
        }
        else{
            $business_settings->value = 0;
            $business_settings->save();
        }

        flash(translate("Settings updated successfully"))->success();
        return back();
    }

    public function google_maps_update(Request $request)
    {
        $path = base_path('.env');

        $driver = '"'.config('services.GMAPS_API') .'"';
        $GMAPS_API = '"'.$request->GMAPS_API.'"';

        if (file_exists($path)) {
            if($request->GMAPS_API){
                file_put_contents($path, str_replace(
                    'GMAPS_API='.$driver, 'GMAPS_API='.$GMAPS_API, file_get_contents($path)
                ));
            }
            Artisan::call('config:cache');
        }

        $business_settings = BusinessSetting::where('type', 'google_maps')->first();

        if ($request->has('google_maps')) {
            $business_settings->value = 1;
            $business_settings->save();
        }
        else{
            $business_settings->value = 0;
            $business_settings->save();
        }

        flash(translate("Settings updated successfully"))->success();
        return back();
    }

    public function google_recaptcha_update(Request $request)
    {
        $path = base_path('.env');

        $driver = '"'.config('services.recaptcha.sitekey') .'"';
        $CAPTCHA_KEY = '"'.$request->CAPTCHA_KEY.'"';

        if (file_exists($path)) {
            if($request->CAPTCHA_KEY){
                file_put_contents($path, str_replace(
                    'CAPTCHA_KEY='.$driver, 'CAPTCHA_KEY='.$CAPTCHA_KEY, file_get_contents($path)
                ));
            }
            Artisan::call('config:cache');
        }

        Artisan::call('config:cache');
        flash(translate("Settings updated successfully"))->success();
        return back();
    }

    /**
     * Update the API key's for facebook chat.
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function facebook_chat_update(Request $request)
    {
        $path = base_path('.env');

        $driver = '"'.config('services.FACEBOOK_PAGE_ID') .'"';
        $FACEBOOK_PAGE_ID = '"'.$request->FACEBOOK_PAGE_ID.'"';

        if (file_exists($path)) {
            if($request->FACEBOOK_PAGE_ID){
                file_put_contents($path, str_replace(
                    'FACEBOOK_PAGE_ID='.$driver, 'FACEBOOK_PAGE_ID='.$FACEBOOK_PAGE_ID, file_get_contents($path)
                ));
            }
            Artisan::call('config:cache');
        }

        $business_settings = BusinessSetting::where('type', 'facebook_chat')->first();

        if ($request->has('facebook_chat')) {
            $business_settings->value = 1;
            $business_settings->save();
        }
        else{
            $business_settings->value = 0;
            $business_settings->save();
        }

        Artisan::call('config:cache');
        flash(translate("Settings updated successfully"))->success();
        return back();
    }

    public function facebook_pixel_update(Request $request)
    {
        $path = base_path('.env');

        $driver = '"'.config('services.FACEBOOK_PIXEL_ID') .'"';
        $FACEBOOK_PIXEL_ID = '"'.$request->FACEBOOK_PIXEL_ID.'"';

        if (file_exists($path)) {
            if($request->FACEBOOK_PIXEL_ID){
                file_put_contents($path, str_replace(
                    'FACEBOOK_PIXEL_ID='.$driver, 'FACEBOOK_PIXEL_ID='.$FACEBOOK_PIXEL_ID, file_get_contents($path)
                ));
            }
            Artisan::call('config:cache');
        }

        $business_settings = BusinessSetting::where('type', 'facebook_pixel')->first();

        if ($request->has('facebook_pixel')) {
            $business_settings->value = 1;
            $business_settings->save();
        }
        else{
            $business_settings->value = 0;
            $business_settings->save();
        }

        Artisan::call('config:cache');
        flash(translate("Settings updated successfully"))->success();
        return back();
    }

    /**
     * Update the API key's for other methods.
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function smtpSettings(Request $request)
    {
        $path = base_path('.env');

        $driver = '"'.config('mail.driver') .'"';
        $MAIL_DRIVER = '"'.$request->MAIL_DRIVER.'"';

        $host = '"'.config('mail.host') .'"';
        $MAIL_HOST = '"'.$request->MAIL_HOST.'"';

        $port = '"'.config('mail.port') .'"';
        $MAIL_PORT = '"'.$request->MAIL_PORT.'"';

        $username = '"'.config('mail.username') .'"';
        $MAIL_USERNAME = '"'.$request->MAIL_USERNAME.'"';

        $password = '"'.config('mail.password') .'"';
        $MAIL_PASSWORD = '"'.$request->MAIL_PASSWORD.'"';

        $encryption = '"'.config('mail.encryption') .'"';
        $MAIL_ENCRYPTION = '"'.$request->MAIL_ENCRYPTION.'"';

        $fromAdd = '"'.config('mail.from.address') .'"';
        $MAIL_FROM_ADDRESS = '"'.$request->MAIL_FROM_ADDRESS.'"';

        $fromName = '"'.config('mail.from.name') .'"';
        $MAIL_FROM_NAME = '"'.$request->MAIL_FROM_NAME.'"';

        $inquiryMail = '"'.config('mail.inquiry') .'"';
        $INQUIRY_EMAIL_RECEIVER = '"'.$request->INQUIRY_EMAIL_RECEIVER.'"';

        $mailgunD = '"'.config('services.mailgun.domain') .'"';
        $MAILGUN_DOMAIN = '"'.$request->MAILGUN_DOMAIN.'"';

        $mailgunS = '"'.config('services.mailgun.secret') .'"';
        $MAILGUN_SECRET = '"'.$request->MAILGUN_SECRET.'"';

        if (file_exists($path)) {
            if($request->MAIL_DRIVER){
                file_put_contents($path, str_replace(
                    'MAIL_DRIVER='.$driver, 'MAIL_DRIVER='.$MAIL_DRIVER, file_get_contents($path)
                ));
            }

            if($request->MAIL_HOST){
                file_put_contents($path, str_replace(
                    'MAIL_HOST='.$host, 'MAIL_HOST='.$MAIL_HOST, file_get_contents($path)
                ));
            }
            
            if($request->MAIL_PORT){
                file_put_contents($path, str_replace(
                    'MAIL_PORT='.$port, 'MAIL_PORT='.$MAIL_PORT, file_get_contents($path)
                ));
                cache()->clear();
            }
            
            if($request->MAIL_USERNAME){
                file_put_contents($path, str_replace(
                    'MAIL_USERNAME='.$username, 'MAIL_USERNAME='.$MAIL_USERNAME, file_get_contents($path)
                ));
            }

            if($request->MAIL_PASSWORD){
                file_put_contents($path, str_replace(
                    'MAIL_PASSWORD='.$password, 'MAIL_PASSWORD='.$MAIL_PASSWORD, file_get_contents($path)
                ));
            }

            if($request->MAIL_ENCRYPTION){
                file_put_contents($path, str_replace(
                    'MAIL_ENCRYPTION='.$encryption, 'MAIL_ENCRYPTION='.$MAIL_ENCRYPTION, file_get_contents($path)
                ));
            }

            if($request->MAIL_FROM_ADDRESS){
                file_put_contents($path, str_replace(
                    'MAIL_FROM_ADDRESS='.$fromAdd, 'MAIL_FROM_ADDRESS='.$MAIL_FROM_ADDRESS, file_get_contents($path)
                ));
                
            }

            if($request->MAIL_FROM_NAME){
                file_put_contents($path, str_replace(
                    'MAIL_FROM_NAME='.$fromName, 'MAIL_FROM_NAME='.$MAIL_FROM_NAME, file_get_contents($path)
                ));
            }

            if($request->INQUIRY_EMAIL_RECEIVER){
                file_put_contents($path, str_replace(
                    'INQUIRY_EMAIL_RECEIVER='.$inquiryMail, 'INQUIRY_EMAIL_RECEIVER='.$INQUIRY_EMAIL_RECEIVER, file_get_contents($path)
                ));
            }

            if($request->MAILGUN_DOMAIN){
                file_put_contents($path, str_replace(
                    'MAILGUN_DOMAIN='.$mailgunD, 'MAILGUN_DOMAIN='.$MAILGUN_DOMAIN, file_get_contents($path)
                ));
            }

            if($request->MAILGUN_SECRET){
                file_put_contents($path, str_replace(
                    'MAILGUN_SECRET='.$mailgunS, 'MAILGUN_SECRET='.$MAILGUN_SECRET, file_get_contents($path)
                ));
            }
        }

        Artisan::call('config:cache');
        flash("Settings updated successfully")->success();
        return back();
    }

    /**
     * Update the API key's for other methods.
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function env_key_update(Request $request)
    {
        foreach ($request->types as $key => $type) {
                $this->overWriteEnvFile($type, $request[$type]);
        }

        flash(translate("Settings updated successfully"))->success();
        return back();
    }

    /**
     * overWrite the Env File values.
     * @param  String type
     * @param  String value
     * @return \Illuminate\Http\Response
     */
    public function overWriteEnvFile($type, $val)
    {
        if(env('DEMO_MODE') != 'On'){
            $path = base_path('.env');
            if (file_exists($path)) {
                $val = '"'.trim($val).'"';
                if(is_numeric(strpos(file_get_contents($path), $type)) && strpos(file_get_contents($path), $type) >= 0){
                    file_put_contents($path, str_replace(
                        $type.'="'.env($type).'"', $type.'='.$val, file_get_contents($path)
                    ));
                }
                else{
                    file_put_contents($path, file_get_contents($path)."\r\n".$type.'='.$val);
                }
            }
        }
    }

    public function seller_verification_form(Request $request)
    {
    	return view('business_settings.seller_verification_form');
    }

    /**
     * Update sell verification form.
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function seller_verification_form_update(Request $request)
    {
        $form = array();
        $select_types = ['select', 'multi_select', 'radio'];
        $j = 0;
        for ($i=0; $i < count($request->type); $i++) {
            $item['type'] = $request->type[$i];
            $item['label'] = $request->label[$i];
            if(in_array($request->type[$i], $select_types)){
                $item['options'] = json_encode($request['options_'.$request->option[$j]]);
                $j++;
            }
            array_push($form, $item);
        }
        $business_settings = BusinessSetting::where('type', 'verification_form')->first();
        $business_settings->value = json_encode($form);
        if($business_settings->save()){
            flash(translate("Verification form updated successfully"))->success();
            return back();
        }
    }

    public function update(Request $request)
    {
        foreach ($request->types as $key => $type) {
            $business_settings = BusinessSetting::where('type', $type)->first();
            if($business_settings!=null){
                $business_settings->value = $request[$type];
                $business_settings->save();
            }
            else{
                $business_settings = new BusinessSetting;
                $business_settings->type = $type;
                $business_settings->value = $request[$type];
                $business_settings->save();
            }
        }
        flash(translate("Settings updated successfully"))->success();
        return back();
    }

    public function updateActivationSettings(Request $request)
    {
        $env_changes = ['FORCE_HTTPS'];
        if (in_array($request->type, $env_changes)) {

            return $this->updateActivationSettingsInEnv($request);
        }


        $business_settings = BusinessSetting::where('type', $request->type)->first();
        if($business_settings!=null){
            if ($request->type == 'maintenance_mode' && $request->value == '1') {
                if(env('DEMO_MODE') != 'On'){
                    Artisan::call('down');
                }
            }
            elseif ($request->type == 'maintenance_mode' && $request->value == '0') {
                if(env('DEMO_MODE') != 'On') {
                    Artisan::call('up');
                }
            }
            $business_settings->value = $request->value;
            $business_settings->save();
        }
        else{
            $business_settings = new BusinessSetting;
            $business_settings->type = $request->type;
            $business_settings->value = $request->value;
            $business_settings->save();
        }
        return '1';
    }

    public function updateActivationSettingsInEnv($request)
    {
        if ($request->type == 'FORCE_HTTPS' && $request->value == '1') {
            $this->overWriteEnvFile($request->type, 'On');

            if(strpos(env('APP_URL'), 'http:') !== FALSE) {
                $this->overWriteEnvFile('APP_URL', str_replace("http:", "https:", env('APP_URL')));
            }

        }
        elseif ($request->type == 'FORCE_HTTPS' && $request->value == '0') {
            $this->overWriteEnvFile($request->type, 'Off');
            if(strpos(env('APP_URL'), 'https:') !== FALSE) {
                $this->overWriteEnvFile('APP_URL', str_replace("https:", "http:", env('APP_URL')));
            }

        }

        return '1';
    }

}
