<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Dietary;

class DietaryController extends Controller
{
    public function index(Request $request) {
        $dietaries = Dietary::select('id','name','published','created_at')->orderby('created_at','desc')->get();

        return view('backend.dietaries.index', compact('dietaries'));
    }

    public function create()
    {
        return view('backend.dietaries.create');
    }

    public function store(Request $request)
    {
        $dietary = new Dietary;
        $dietary->name = $request->name;

        if($dietary->save()){
            flash(translate('Dietary has been inserted successfully'))->success();
            return back();
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function edit($id)
    {
        $dietary = Dietary::findOrFail(decrypt($id));
        return view('backend.dietaries.edit', compact('dietary'));
    }

    public function update(Request $request, $id)
    {
        $dietary = Dietary::findOrFail($id);
        $dietary->name = $request->name;
       
        if($dietary->save()){
            flash(translate('Dietary has been updated successfully'))->success();
            return back();
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function destroy($id)
    {
        if(Dietary::destroy($id)){
            flash(translate('Dietary has been deleted successfully'))->success();
            return redirect()->route('dietaries.index');
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function published(Request $request) {
        $dietary = Dietary::find($request->id);
        $dietary->published = $request->published;
        if($dietary->save()){
            return '1';
        }
        else {
            return '0';
        }
    }
}
