<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\GeneralSetting;
use ImageOptimizer;
use Image;
use App\Http\Controllers\BusinessSettingsController;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Str;

class GeneralSettingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $generalsetting = GeneralSetting::first();
        return view("general_settings.index", compact("generalsetting"));
    }

    public function logo()
    {
        $generalsetting = GeneralSetting::first();
        return view("general_settings.logo", compact("generalsetting"));
    }

    //updates the logo and favicons of the system
    public function storeLogo(Request $request)
    {
        $generalsetting = GeneralSetting::first();

        if($request->hasFile('logo')){
            if(isset($generalsetting->logo )){
                unlink(public_path($generalsetting->logo));
            }

            $image = $request->file('logo');
            $imageName = date('dmYHi').''.Str::random(8).'.png';
            $generalsetting->logo = 'uploads/logo/'.$imageName;
            $destinationPath = public_path().'/'.$generalsetting->logo;

            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,85);
        }

        if($request->hasFile('conference_logo')){
            if(isset($generalsetting->conference_logo)){
                unlink(public_path($generalsetting->conference_logo));
            }

            $imageCL = $request->file('conference_logo');
            $imageNameCL = date('dmYHi').''.Str::random(8).'cl.png';
            $generalsetting->conference_logo = 'uploads/logo/'.$imageNameCL;
            $destinationPathCL = public_path().'/'.$generalsetting->conference_logo;

            $imgCL = Image::make($imageCL->getRealPath());
            $imgCL->save($destinationPathCL,85);
        }

        if($request->hasFile('hotel_logo')){
            if(isset($generalsetting->hotel_logo)){
                unlink(public_path($generalsetting->hotel_logo));
            }

            $imageHL = $request->file('hotel_logo');
            $imageNameHL = date('dmYHi').''.Str::random(8).'hl.png';
            $generalsetting->hotel_logo = 'uploads/logo/'.$imageNameHL;
            $destinationPathHL = public_path().'/'.$generalsetting->hotel_logo;

            $imgHL = Image::make($imageHL->getRealPath());
            $imgHL->save($destinationPathHL,85);
        }

        if($request->hasFile('company_logo')){
            if(isset($generalsetting->company_logo)){
                unlink(public_path($generalsetting->company_logo));
            }

            $imageCOML = $request->file('company_logo');
            $imageNameCOML = date('dmYHi').''.Str::random(8).'COML.png';
            $generalsetting->company_logo = 'uploads/logo/'.$imageNameCOML;
            $destinationPathCOML = public_path().'/'.$generalsetting->company_logo;

            $imgCOML = Image::make($imageCOML->getRealPath());
            $imgCOML->save($destinationPathCOML,85);
        }

        if($request->hasFile('footer_logo')){
            if(isset($generalsetting->footer_logo)){
                unlink(public_path($generalsetting->footer_logo));
            }

            $imagefl = $request->file('footer_logo');
            $imageNamefl = date('d-m-Y-H-i').'-'.Str::random(5).'fl.webp';
            $generalsetting->footer_logo = 'uploads/logo/'.$imageNamefl;
            $destinationPathfl = public_path().'/'.$generalsetting->footer_logo;

            $imgfl = Image::make($imagefl->getRealPath());
            $imgfl->save($destinationPathfl,75); 
        }

        if($request->hasFile('admin_logo')){
            if(isset($generalsetting->admin_logo)){
                unlink(public_path($generalsetting->admin_logo));
            }
            $image1 = $request->file('admin_logo');
            $imageName1 = date('d-m-Y-H-i').'-'.Str::random(5).'al.webp';
            $generalsetting->admin_logo = 'uploads/admin_logo/'.$imageName1;
            $destinationPath1 = public_path().'/'.$generalsetting->admin_logo;

            $img1 = Image::make($image1->getRealPath());
            $img1->save($destinationPath1,80);
        }

        if($request->hasFile('favicon')){
            if(isset($generalsetting->favicon)){
                unlink(public_path($generalsetting->favicon));
            }
            $image2 = $request->file('favicon');
            $imageName2 = date('d-m-Y-H-i').'-'.Str::random(5).'f.png';
            $generalsetting->favicon = 'uploads/favicon/'.$imageName2;
            $destinationPath2 = public_path().'/'.$generalsetting->favicon;

            $img2 = Image::make($image2->getRealPath());
            $img2->save($destinationPath2,80); 
        }

        if($request->hasFile('admin_login_background')){
            if(isset($generalsetting->admin_login_background)){
                unlink(public_path($generalsetting->admin_login_background));
            }
            $image3 = $request->file('admin_login_background');
            $imageName3 = date('d-m-Y-H-i').'-'.Str::random(5).'alb.webp';
            $generalsetting->admin_login_background = 'uploads/admin_login_background/'.$imageName3;
            $destinationPath3 = public_path().'/'.$generalsetting->admin_login_background;

            $img3 = Image::make($image3->getRealPath());
            $img3->save($destinationPath3,80); 
        }

        if($request->hasFile('admin_login_sidebar')){
            if(isset($generalsetting->admin_login_sidebar)){
                unlink(public_path($generalsetting->admin_login_sidebar));
            }
            $image4 = $request->file('admin_login_sidebar');
            $imageName4 = date('d-m-Y-H-i').'-'.Str::random(5).'als.webp';
            $generalsetting->admin_login_sidebar = 'uploads/admin_login_sidebar/'.$imageName4;
            $destinationPath4 = public_path().'/'.$generalsetting->admin_login_sidebar;

            $img4 = Image::make($image4->getRealPath());
            $img4->save($destinationPath4,80);
        }

        if($generalsetting->save()){
            flash(translate('Logo settings has been updated successfully'))->success();
            return redirect()->route('generalsettings.logo');
        }
        else{
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $generalsetting = GeneralSetting::first();
        $generalsetting->site_name = $request->name;
        $generalsetting->description = $request->description;
        $generalsetting->site_year = $request->site_year;

        $generalsetting->conference_name = $request->conference_name;
        $generalsetting->conference_hotel = $request->conference_hotel;
        $generalsetting->conference_location = $request->conference_location;
        $generalsetting->conference_date = $request->conference_date;

        $generalsetting->email = $request->email;

        $generalsetting->contact_us = $request->contact_us;

        $generalsetting->facebook = $request->facebook;
        $generalsetting->instagram = $request->instagram;
        $generalsetting->linkedIn = $request->linkedIn;
        $generalsetting->youtube = $request->youtube;

        $generalsetting->frontend_color = $request->frontend_color;

        if($generalsetting->save()){

            $path = base_path('.env');

            $cName = '"'.config('app.name') .'"';
            $name = '"'.$request->name.'"';

            $cUrl = '"'.config('app.url') .'"';
            $url = '"'.$request->url.'"';

            $cTimezone = '"'.config('app.timezone') .'"';
            $time = '"'.$request->timezone.'"';

            if (file_exists($path)) {
                file_put_contents($path, str_replace(
                    'APP_NAME='.$cName, 'APP_NAME='.$name, file_get_contents($path)
                ));
                file_put_contents($path, str_replace(
                    'APP_URL='.$cUrl, 'APP_URL='.$url, file_get_contents($path)
                ));
                // file_put_contents($path, str_replace(
                //     'APP_TIMEZONE='.$cTimezone, 'APP_TIMEZONE='.$time, file_get_contents($path)
                // ));
            }

            Artisan::call('config:cache');
            flash(translate('GeneralSetting has been updated successfully'))->success();
            return redirect()->route('generalsettings.index');
        }
        else{
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function cookies(Request $request)
    {
        return view("general_settings.cookie");
    }

    public function cookiesStore(Request $request)
    {
        $business_settings = \App\BusinessSetting::where('type', 'cookies_agreement_text')->first();
        $business_settings->value = $request->cookies_agreement_text;
        if($business_settings->save()) {
            $business_settings_on = \App\BusinessSetting::where('type', 'show_cookies_agreement')->first();
            if ($request->has('show_cookies_agreement')) {
                $business_settings_on->value = "on";
                $business_settings_on->save();
            } else{
                $business_settings_on->value = "off";
                $business_settings_on->save();
            }
            flash(translate('Cookie Agreement has been updated successfully'))->success();
            return redirect()->route('cookies.index');
        } else{
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function aboutUs(Request $request)
    {
        return view("general_settings.about_us");
    }

    public function aboutUsStore(Request $request)
    {
        $business_settings = \App\BusinessSetting::where('type', 'about_us')->first();
        $business_settings->value = $request->about_us;
        if($business_settings->save()) {
            $business_settings1 = \App\BusinessSetting::where('type', 'mission')->first();
            $business_settings1->value = $request->mission;
            $business_settings1->save();

            $business_settings2 = \App\BusinessSetting::where('type', 'vision')->first();
            $business_settings2->value = $request->vision;
            $business_settings2->save();

            $business_settings3 = \App\BusinessSetting::where('type', 'core_values')->first();
            $business_settings3->value = $request->core_values;
            $business_settings3->save();
            flash(translate('About Us has been updated successfully'))->success();
            return redirect()->route('about_us.index');
        } else{
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}