<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Session;
use Auth;
use Hash;
use App\User;
use App\BusinessSetting;
use App\Agenda;
use App\MeetingCost;
use App\Email;

use App\Specialization;
use App\Service;
use App\Software;
use App\Sponsorship;
use App\Advertisement;
use App\Registration;
use App\RegDietary;
use App\RegService;
use App\RegSoftware;
use App\RegSpecialization;
use App\RegAdvertisement;
use App\RegSponsorship;
use App\Dietary;
use App\Neutrality;
use App\RegNeutrality;

use ImageOptimizer;
use Cookie;
use Illuminate\Support\Str;
use App\Mail\SecondEmailVerifyMailManager;
use Mail;
use Artisan;
use Image;
use App\Mail\InvoiceEmailManager;
use App\Mail\InquiryNotification;
use App\Mail\Inquiry;
use App\Benefit;

ini_set('max_execution_time', 300); //300 seconds = 5 minutes

class HomeController extends Controller
{

    public function index()
    {
        $generalsetting = \App\GeneralSetting::first();
        $benefits = Benefit::orderby('order_number','asc')->get();

        return view('frontend.index', 
            compact(
                'generalsetting',
                'benefits'
            )
        );
    }

    public function about_us()
    {
        $generalsetting = \App\GeneralSetting::first();

        return view('frontend.about_us', 
            compact(
                'generalsetting'
            )
        );
    }

    public function agenda()
    {
        $agendas = Agenda::orderby('date','asc')->get();

        return view('frontend.agenda', 
            compact(
                'agendas'
            )
        );
    }

    public function meeting_cost()
    {
        $generalsetting = \App\GeneralSetting::first();
        $meetingCosts = MeetingCost::orderby('created_at','asc')->get();

        return view('frontend.meeting_cost', 
            compact(
                'generalsetting',
                'meetingCosts'
            )
        );
    }

    public function meeting_scheduler()
    {
        $generalsetting = \App\GeneralSetting::first();

        return view('frontend.meeting_scheduler', 
            compact(
                'generalsetting',
            )
        );
    }

    public function visa()
    {
        return view('frontend.visa');
    }

    public function covid_info()
    {
        return view('frontend.covid_info');
    }

    public function about_location($slug)
    {
        return view('frontend.about_location');
    }

    public function hotel()
    {
        return view('frontend.hotel');
    }

    public function contact_us()
    {
        return view('frontend.contact_us');
    }

    public function history()
    {
        return view('frontend.history');
    }

    public function sendEmail(Request $request)
    {
        try {
            

            $this->validate($request, [
                'name' => 'required',
                'company_name' => 'required',
                'email' => 'required',
                'phone_number' => 'required',
                'mobile_number' => 'required',
                'website_url' => 'required',
                'message' => 'required',
                'g-recaptcha-response' => 'required'
            ],
            [
                'g-recaptcha-response.required' => 'Recaptcha is required!',
            ]);
            
             // $secretAPIkey = '6Lf2CSgaAAAAAPOaKVQX5tO_sx1XE4v8dCxYimJ1';
                $secretAPIkey = '6LezdagiAAAAAGfJufib4kZxZb6CfQJfvPS9V9aq';
    
            $verifyResponse = file_get_contents('https://www.google.com/recaptcha/api/siteverify?secret='.$secretAPIkey.'&response='.$request['g-recaptcha-response']);
    
            $response = json_decode($verifyResponse);
            
            if($response->success){

                $emailForm = new Email;
                $emailForm->company_name = $request->company_name;
                $emailForm->name = $request->name;
                $emailForm->email = $request->email;
                $emailForm->phone_number = $request->phone_number;
                $emailForm->mobile_number = $request->mobile_number;
                $emailForm->website_url = $request->website_url;
                $emailForm->message = $request->message;
                $emailForm->save();
    
                $mailEmail = $request->event_email;
    
                $name = $request->name;
                $sender_email = $request->email;
    
                $data = array(
                    'name' => $request->name,
                    'company' => $request->company_name,
                    'email' => $request->email,
                    'phone_number' => $request->phone_number,
                    'mobile_number' => $request->mobile_number,
                    'website' => $request->website_url,
                    'comment' => $request->message
                );
    
                Mail::send('mails.contact', $data, function ($message) use ($mailEmail, $name, $sender_email) {
                    $message->to($mailEmail);
                    $message->subject('New online inquiry to Emerge Event from '.$name);
                    $message->from($sender_email, $name);
                });
    
                Mail::send('mails.contact_sender', $data, function ($message) use ($mailEmail,$sender_email) {
                    $message->to($sender_email);
                    $message->subject('Your online inquiry to Emerge Event');
                    $message->from($mailEmail, config('mail.from.name'));
                });
    
    
                return response()->json(['res_code' => 0, 'res_msg' => 'Thank you for contacting us. Our team will get in touch with you shortly.']);
                
            } else {
                return response()->json(['res_code' => 1, 'res_msg' => 'Please verify that you are a human!.']);
            }

        } catch (\Exception  $exception) {
            return response()->json(['res_code' => 1, 'res_msg' => 'error', 'error' => $exception]);
        }
        // return back()->withInput();
    }

    public function sponsorship()
    {

        $sponsorships = Sponsorship::orderBy('order_number','asc')->whereNotIn('published', [0])->get();
        
        return view('frontend.sponsorship',
            compact(
                'sponsorships',
            )
        );
    }

    public function registration()
    {
        $generalsetting = \App\GeneralSetting::first();

        $dietaries = Dietary::where('published', 1)->orderby('created_at','asc')->get();
        $specializations = Specialization::where('published', 1)->orderby('created_at','asc')->get();
        $softwares = Software::where('published', 1)->orderby('created_at','asc')->get();
        $neutralities = Neutrality::where('published', 1)->orderby('created_at','asc')->get();
        $services = Service::where('published', 1)->orderby('created_at','asc')->get();
        $sponsorships = Sponsorship::where('published', 1)->orderby('created_at','asc')->get();
        $advertisements = Advertisement::where('published', 1)->orderby('created_at','asc')->get();

        $conference_cost = MeetingCost::where('vip',0)->first();
        $vip_cost = MeetingCost::where('vip',1)->first();

        return view('frontend.registration', 
            compact(
                'generalsetting',
                'dietaries',
                'specializations',
                'softwares',
                'services',
                'neutralities',
                'sponsorships',
                'advertisements',
                'conference_cost',
                'vip_cost',
            )
        );
    }

    public function submitRegistration(Request $request)
    {
        $generalsetting = \App\GeneralSetting::first();

        $id = 0;
        $rand =  rand(10, 1000);
        for ($i = 0; $i < $request->dynamic_count; ++$i) {
            $registration = new Registration;
            $registration->salutation = $request->salutation[$i];
            $registration->firstname = $request->firstname[$i];
            $registration->lastname = $request->lastname[$i];
            $registration->position = $request->designation[$i];
            $registration->email = $request->email[$i];
            $registration->mobile = $request->mobile[$i];
            $registration->shirt_size = $request->shirt_size[$i];
            $registration->company = $request->company;
            $registration->telephone = $request->telephone;
            $registration->website = $request->website;
            $registration->iata = $request->iata;
            $registration->address = $request->address;
            $registration->city = $request->city;
            $registration->country = $request->country;

            if (isset($request->checkbox_vip)) {
                $registration->vip = $request->checkbox_vip;
            }

            $registration->conference_fee = $request->conference_fee;
            $registration->early_bird = $request->earlybird_status;
            $registration->total_price = $request->total_price;
            $registration->learn_about_us = isset($request->learn) ? $request->learn : $request->learnOthers ;
            $registration->comment = $request->message;

            $registration->colleague_id = $rand;
            $registration->country_interested = $request->country_interested;
            $registration->emerging_regions_interested = $request->emerge_regions;
            $registration->is_joining_city_tour = $request->is_joining_city_tour;
            $registration->save();

            $current_id = $registration->id;

            if (isset($request->dietary)) {
                foreach ($request->dietary as $item) {
                    $dietary = new RegDietary;
                    $dietary->reg_id = $current_id;
                    $dietary->dietary = $item;
                    $dietary->save();
                }
            }

            if ($request->otherdietary != "") {
                $dietary = new RegDietary;
                $dietary->reg_id = $current_id;
                $dietary->dietary = 'Others: ' . $request->otherdietary;
                $dietary->save();
            }
            if ($request->allergy != "") {
                $dietary = new RegDietary;
                $dietary->reg_id = $current_id;
                $dietary->dietary = 'Allergy: ' . $request->allergy;
                $dietary->save();
            }
        }

        $id = $registration->id - $request->dynamic_count + 1;

        // save specialization
        if (isset($request->specializations)) {
            foreach ($request->specializations as $item) {
                $specialization = new RegSpecialization;
                $specialization->reg_id = $id;
                $specialization->specialization = $item;
                $specialization->save();
            }
        }

        // save services
        if (isset($request->services)) {
            foreach ($request->services as $item) {
                $services = new RegService;
                $services->reg_id = $id;
                $services->service = $item;
                $services->save();
            }
        }

        // save services
        if (isset($request->others_services)) {
            $services = new RegService;
            $services->reg_id = $id;
            $services->service = $request->others_services;
            $services->save();
        }

        // save neutralities
        if (isset($request->neutralities)) {
            $neutrality = new RegNeutrality;
            $neutrality->reg_id = $id;
            $neutrality->neutrality = $request->neutralities;
            $neutrality->save();
        }

        // save software
        if (isset($request->softwares)) {
            foreach ($request->softwares as $item) {
                $softwares = new RegSoftware;
                $softwares->reg_id = $id;
                $softwares->software = $item;
                $softwares->save();
            }
        }

        // save premium sponsors
        if (isset($request->premium_sponsor)) {
            $arr = json_decode($request->premium_sponsor, true);
            $premium_sponsorship = new RegSponsorship;
            $premium_sponsorship->reg_id = $id;
            $premium_sponsorship->sponsorship = $arr['id'];
            $premium_sponsorship->save();
        }

        // save sponsors
        if (isset($request->sponsorship)) {
            foreach ($request->sponsorship as $item) {
                $sponsorship = new RegSponsorship;
                $sponsorship->reg_id = $id;
                $sponsorship->sponsorship = $item;
                $sponsorship->save();
            }
        }

        if (isset($request->advertisement)) {
            foreach ($request->advertisement as $item) {
                $advertisement = new RegAdvertisement;
                $advertisement->reg_id = $id;
                $advertisement->advertisement = $item;
                $advertisement->save();
            }
        }

        $registrant = Registration::find($id);

        $conference_cost = MeetingCost::where('vip',0)->first();
        $vip_cost = MeetingCost::where('vip',1)->first();

        $dateToday = date('F d, Y, h:i:s a');
        $price_ends = date('F d, Y', strtotime($conference_cost->early_bird_rate_date))." 12:00:00 pm"; //June 22, 2023
        $checker_for_early_bird = ( strtotime($dateToday) < strtotime($price_ends) ) ? 1 : 0 ;

        $regular_fee = ($checker_for_early_bird == 1 ? $conference_cost->early_bird_rate_price : $conference_cost->regular_rate_price);

        $number_of_people_free = collect([]);
        $mailName = $request->salutation[0] . ' ' . $request->firstname[0] . ' ' . $request->lastname[0];
        $arrayNames = collect([]);

        if (isset($request->premium_sponsor)) {
            $arr = json_decode($request->premium_sponsor, true);
        } else {
            $arr['id'] = 0;
        }

        $dynamic_count = $request->dynamic_count;

        if (isset($request->checkbox_vip)) {
            $dynamic_count = $dynamic_count - 1;
        }

        if ($arr['id'] == 1) { //Diamond
            $dynamic_count = $dynamic_count - 1;
            var_dump('diamond');
            for ($x = 0; $x < $request->dynamic_count; ++$x) {
                $number_of_people_free->push([
                    'name' => $request->salutation[$x] . ' ' .  $request->firstname[$x] . ' ' .  $request->lastname[$x],
                    'fee' => ($x >= $arr['total_free_conference_pass'] ? '$' . $regular_fee : 'Free')
                ]);
            }

        } elseif ($arr['id'] == 2) { //Gold

            var_dump('gold');
            for ($x = 0; $x < $request->dynamic_count; ++$x) {
                $number_of_people_free->push([
                    'name' => $request->salutation[$x] . ' ' .  $request->firstname[$x] . ' ' .  $request->lastname[$x],
                    'fee' => ($x >= $arr['total_free_conference_pass'] ? '$' . $regular_fee : 'Free')
                ]);
            }
            
        } elseif ($arr['id'] == 3) {  //Silver

            var_dump('silver');
            for ($x = 0; $x < $request->dynamic_count; ++$x) {
                $number_of_people_free->push([
                    'name' => $request->salutation[$x] . ' ' .  $request->firstname[$x] . ' ' .  $request->lastname[$x],
                    'fee' => ($x >= $arr['total_free_conference_pass'] ? '$' . $regular_fee : 'Free')
                ]);
            }

        } else {

            if (isset($request->sponsorship)) {

                foreach ($request->sponsorship as $item) {
                    //rw tech sponsorship id=15
                    if($item == 15){
                        $dynamic_count = $dynamic_count - 1;
                        
                        for ($x = 0; $x < $request->dynamic_count; ++$x) {
                            $number_of_people_free->push([
                                'name' => $request->salutation[$x] . ' ' .  $request->firstname[$x] . ' ' .  $request->lastname[$x],
                                'fee' => ($dynamic_count >= 1 ? '$' . $regular_fee : 'Free')
                            ]);
                        }

                    }

                }

            } else {
                for ($x = 0; $x < $request->dynamic_count; ++$x) {

                    if($x == 0){

                        if (isset($request->checkbox_vip)) {
                            $number_of_people_free->push([
                                'name' => $request->salutation[$x] . ' ' .  $request->firstname[$x] . ' ' .  $request->lastname[$x],
                                'fee' => 'Free'
                            ]);
                        } else {
                            $number_of_people_free->push([
                                'name' => $request->salutation[$x] . ' ' .  $request->firstname[$x] . ' ' .  $request->lastname[$x],
                                'fee' => '$' . $regular_fee
                            ]);
                        }

                    } else {

                        $number_of_people_free->push([
                            'name' => $request->salutation[$x] . ' ' .  $request->firstname[$x] . ' ' .  $request->lastname[$x],
                            'fee' => '$' . $regular_fee
                        ]);

                    }

                }


            }
            
        }

        $registrant->number_of_people_free = json_encode($number_of_people_free);
        $registrant->save();

        $mailToEmail = $request->email[0];
        $mailToEmailTo = config('mail.inquiry');

        $personal = array(
            'salutation' => $request->salutation[0],
            'firstname' => $request->firstname[0],
            'lastname' => $request->lastname[0],
            'shirt_size' => $request->shirt_size[0],
            'designation' => $request->designation[0],
            'email' => $request->email[0],
            'mobile' => $request->mobile[0],
        );

        $company_data = array(
            'company_name' => $request->company,
            'telephone' => $request->telephone,
            'website' => $request->website,
            'iata' => $request->iata,
            'address' => $request->address,
            'city' => $request->city,
            'country' => $request->country,
            'is_joining_city_tour' => $request->is_joining_city_tour
        );

        $data = array(
            'personal' => $personal,
            'name' => $mailName,
            // 'registerd' => $registrant,
            'registered_name' => $number_of_people_free,
            'event_email' => config('mail.inquiry'),
            'regular_fee' => $regular_fee,
            'conference_fee' => $request->conference_fee,
            'vip' => $request->checkbox_vip,
            'golf' => $request->golf,
            'spouse' => $request->spouse,
            'total_price' => $request->total_price,
            'shirt-size' => $registrant->shirt_size,
            'dietaries' => $registrant->dietaries,
            'sponsors' => $registrant->sponsorship,
            'advertisements' => $registrant->advertisement,
            'specializations' => $registrant->specialization,
            'services' => $registrant->services,
            'other_services' => $request->others_services,
            'softwares' => $registrant->software,
            'neutralities' => $registrant->neutralities,
            'country_interested' => $registrant->country_interested,
            'emerging_regions_interested' => $registrant->emerging_regions_interested,
            'company_data' => $company_data,
            'checker' => $checker_for_early_bird,
            'learn_about_us' => isset($request->learn) ? $request->learn : $request->learnOthers,
            'comment' => $request->message,
            'generalsetting' => $generalsetting,
            // 'discounts' => $discounts,
        );


        Mail::send('mails.registration', $data, function ($message) use ($mailToEmail) {
            $message->to($mailToEmail);
            $message->subject('Your online registration to EMERGE 2nd Conference Original Event');
            $message->from(config('mail.inquiry'), config('mail.from.name'));
        });

        Mail::send('mails.admin-registration-template', $data, function ($message) use ($mailToEmailTo, $mailName) {
            $message->to($mailToEmailTo);
            $message->subject('New Online Registration to EMERGE 2nd Conference Original Event from ' . $mailName);
            $message->from(config('mail.inquiry'), config('mail.from.name'));
        });

        return back()->with([
            'success' => 'Successfully sent and we’ll get back to you the soonest',
            'total_price' => $request->total_price,
        ]);
    }

    public function login()
    {
        if(Auth::check()){
            return redirect()->route('home');
        }
        return view('frontend.user_login');
    }

    public function admin_dashboard(Request $request)
    {
        $from_date = $request->has('from_date') ? \Carbon\Carbon::parse($request->from_date)->format('Y-m-d') : date('Y-m-d');
        $to_date = $request->has('to_date') ? \Carbon\Carbon::parse($request->to_date)->format('Y-m-d') : date('Y-m-d');

        return view('dashboard', compact('from_date','to_date'));
    }

    public function profile(Request $request)
    {
        if(Auth::user()->user_type == 'customer'){
            return view('frontend.customer.profile');
        }
        elseif(Auth::user()->user_type == 'seller'){
            return view('frontend.seller.profile');
        }
    }

    public function mail_callback(Request $request){
        if($request->has('new_email_verificiation_code') && $request->has('email')) {
            $verification_code_of_url_param =  $request->input('new_email_verificiation_code');
            $user = User::where('new_email_verificiation_code', $verification_code_of_url_param)->first();

            if($user != null) {

                $user->email = $request->input('email');
                $user->new_email_verificiation_code = null;
                $user->save();

                auth()->login($user, true);

                flash(translate('Email Changed successfully'))->success();
                return redirect()->route('dashboard');
            }
        }

        flash(translate('Email was not verified. Please resend your mail!'))->error();
        return redirect()->route('dashboard');

    }

    public function data_deletion_callback(Request $request){
        $signed_request = $request->signed_request;
        $data = $this->parse_signed_request($signed_request);
        $provider_id = $data['user_id'];

        $this->deletion($provider_id);

        // Start data deletion
        $app_url            = config('app.url');
        $status_url         = $app_url.'/deletion/'.$provider_id; // URL to track the deletion
        $confirmation_code  = 'abc123'; // unique code for the deletion request

        $data = array(
            'url'               => $status_url,
            'confirmation_code' => $confirmation_code
        );

        echo json_encode($data);
    }

    public function parse_signed_request($signed_request) {
        list($encoded_sig, $payload) = explode('.', $signed_request);
      
        $secret = "3cbdde5126488384838278550af145f2"; // Use your app secret here
      
        // decode the data
        $sig = $this->base64_url_decode($encoded_sig);
        $data = json_decode($this->base64_url_decode($payload), true);
      
        // confirm the signature
        $expected_sig = hash_hmac('sha256', $payload, $secret, $raw = true);
        if ($sig !== $expected_sig) {
          error_log('Bad Signed JSON signature!');
          return null;
        }
      
        return $data;
    }
      
    public function base64_url_decode($input) {
        return base64_decode(strtr($input, '-_', '+/'));
    }

    public function customer_update_profile(Request $request)
    {
        if(env('DEMO_MODE') == 'On'){
            flash(translate('Sorry! the action is not permitted in demo '))->error();
            return back();
        }

        $user = Auth::user();
        $user->name = $request->name;
        $user->address = $request->address;
        $user->country = $request->country;
        $user->city = $request->city;
        $user->postal_code = $request->postal_code;
        $user->phone = $request->phone;

        if($request->new_password != null && ($request->new_password == $request->confirm_password)){
            $user->password = Hash::make($request->new_password);
        }

        if($request->hasFile('photo')){
            // $user->avatar_original = $request->photo->store('uploads/users');
            if(isset($user->avatar_original)){
                unlink(public_path($user->avatar_original));
            }
            $imageName = date('d-m-Y-H-i').'-'.Str::random(8).'.webp';
            $user->avatar_original = 'uploads/users/'.$imageName;
            $image = $request->file('photo');
            $destinationPath = public_path().'/'.$user->avatar_original;

            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,60);
        }

        if($user->save()){
            flash(translate('Your Profile has been updated successfully!'))->success();
            return back();
        }

        flash(translate('Sorry! Something went wrong.'))->error();
        return back();
    }

    public function inquiry(Request $request){
        try {
            Mail::to($request->email)->send(new InquiryNotification($request));
            Mail::to(config('mail.inquiry'))->send(new Inquiry($request));
            return response()->json($request, 200);
        } catch (\Exception $th) {
            return response()->json($th, 402);
        }

    }

    public function sendContact(Request $request)
    {
        $this->validate($request,[
            'lastname'      => 'required|max:100',
            'firstname'     => 'required|max:100',
            'message'       => 'required|max:255',
            'email'         => 'required|email',
        ]);

        $array['view'] = 'emails.invoice';
        $array['subject'] = 'Inquiry From Website';
        $array['from'] = $request->email;
        $array['content'] = $request->message." <br><br> FullName: ".$request->lastname.", ".$request->firstname;

        try {
            Mail::to(config('mail.inquiry'))->queue(new InvoiceEmailManager($array));
        } catch (\Exception $e) {
            return 'error '.$e;
        }

        return "success";
    }

    // Ajax call
    public function new_verify(Request $request)
    {
        $email = $request->email;
        if(isUnique($email) == '0') {
            $response['status'] = 2;
            $response['message'] = 'Email already exists!';
            return json_encode($response);
        }

        $response = $this->send_verification_mail($request, $email);
        return json_encode($response);
    }

    // Form request
    public function update_email(Request $request)
    {
        $email = $request->email;
        if(isUnique($email)) {
            $this->send_verification_mail($request, $email);
            flash(translate('A verification mail has been sent to the mail you provided us with.'))->success();
            return back();

        }

        flash(translate('Email already exists!'))->warning();
        return back();
    }

    public function send_verification_mail($request, $email)
    {
        $response['status'] = 0;
        $response['message'] = 'Unknown';

        $verification_code = Str::random(32);

        $array['subject'] = 'Email Verification';
        $array['from'] = env('MAIL_USERNAME');
        $array['content'] = 'Verify your account';
        $array['link'] = route('mail_callback').'?new_email_verificiation_code='.$verification_code.'&email='.$email;
        $array['sender'] = Auth::user()->name;
        $array['details'] = "Email Second";

        $user = Auth::user();
        $user->new_email_verificiation_code = $verification_code;
        $user->save();

        try {
            Mail::to($email)->queue(new SecondEmailVerifyMailManager($array));

            $response['status'] = 1;
            $response['message'] = translate("Your verification mail has been Sent to your email.");

        } catch (\Exception $e) {
            // return $e->getMessage();
            $response['status'] = 0;
            $response['message'] = $e->getMessage();
        }

        return $response;
    }

    public function configClear(){
        Artisan::call('config:clear');
        return '<h1>Configurations cleared</h1>';
    }

    public function cacheClear(){
        Artisan::call('cache:clear');
        return '<h1>Cache cleared</h1>';
    }

    public function configCache(){
        Artisan::call('config:cache');
        return '<h1>Configurations cache cleared</h1>';
    }

    public function viewClear(){
        Artisan::call('view:clear');
        return '<h1>Configurations view cleared</h1>';
    }

    public function routeCache(){
        Artisan::call('route:cache');
        return '<h1>Route Cache successfully</h1>';
    }

    public function cache(){
        return view('cache_management.cache');
    }

    public function cache_website(Request $request){
        if($request->has('type')){
            $value = $request->type;
            Artisan::call($value);
            return '1';
        } else {
            return '0';
        }
        return '0';
    }

    public function sitemap(){
        return base_path('sitemap.xml');
    }

    public function delete($id)
    {
        $customer_id = Customer::where("user_id",$id)->first()->id;
        if(Customer::destroy($customer_id)){
            User::destroy($id);
            
            flash(translate('Account has been deleted successfully'))->success();
            return back();
        }

        flash(translate('Something went wrong'))->error();
        return back();
    }

    public function deletion($id)
    {
        $user_id = User::where("provider_id",$id)->first()->id;
        if(User::destroy($user_id)){
            $customer_id = Customer::where("user_id",$user_id)->first()->id;
            Customer::destroy($customer_id);
            return array('status' => 200, 'content' => 'Successful');
        } else {
            return array('status' => 400, 'content' => 'Invalid request');
        }

        // $customer_id = Customer::where("user_id",$id)->first()->id;
        // if(Customer::destroy($customer_id)){
        //     User::destroy($id);
            
        //     flash(translate('Account has been deleted successfully'))->success();
        //     return back();
        // }

        // flash(translate('Something went wrong'))->error();
        // return back();
    }
}
