<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\MeetingCost;

class MeetingCostController extends Controller
{
    public function index(Request $request) {
        $meetingCosts = MeetingCost::orderby('created_at','desc')->get();

        return view('backend.meeting_costs.index', compact('meetingCosts'));
    }

    public function create()
    {
        return view('backend.meeting_costs.create');
    }

    public function store(Request $request)
    {
        $meetingCost = new MeetingCost;
        $meetingCost->title = $request->title;
        $meetingCost->early_bird_rate_price = $request->early_bird_rate_price;
        $meetingCost->early_bird_rate_date = $request->early_bird_rate_date;
        $meetingCost->regular_rate_price = $request->regular_rate_price;
        $meetingCost->meeting_cost_details = $request->meeting_cost_details;

        if($meetingCost->save()){
            flash(translate('Meeting Cost has been inserted successfully'))->success();
            return back();
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function edit($id)
    {
        $meetingCost = MeetingCost::findOrFail(decrypt($id));
        return view('backend.meeting_costs.edit', compact('meetingCost'));
    }

    public function update(Request $request, $id)
    {
        $meetingCost = MeetingCost::findOrFail($id);
        $meetingCost->title = $request->title;
        $meetingCost->early_bird_rate_price = $request->early_bird_rate_price;
        $meetingCost->early_bird_rate_date = $request->early_bird_rate_date;
        $meetingCost->regular_rate_price = $request->regular_rate_price;
        $meetingCost->meeting_cost_details = $request->meeting_cost_details;

        if($meetingCost->save()){
            flash(translate('Meeting Cost has been updated successfully'))->success();
            return back();
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function destroy($id)
    {
        if(MeetingCost::destroy($id)){
            flash(translate('Meeting Cost has been deleted successfully'))->success();
            return redirect()->route('meeting_costs.index');
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function isVip(Request $request)
    {
        $meetingCost = MeetingCost::find($request->id);
        $meetingCost->vip = $request->published;
        if($meetingCost->save()){
            return '1';
        }
        else {
            return '0';
        }
    }

    public function isSoldOut(Request $request)
    {
        $meetingCost = MeetingCost::find($request->id);
        $meetingCost->is_sold_out = $request->status;
        if($meetingCost->save()){
            return '1';
        }
        else {
            return '0';
        }
    }
}
