<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Slider;
use Illuminate\Support\Str;
use Image;
use App\BusinessSetting;

class SliderController extends Controller
{
    public function index()
    {
        $sliders = Slider::select('id','orders','photo','published','created_at')->orderby('created_at','desc')->get();

        return view('backend.sliders.index', compact('sliders'));
    }

    public function create()
    {
        return view('backend.sliders.create');
    }

    public function store(Request $request)
    {
        if($request->hasFile('photo')){
            $slider = new Slider;
            $slider->orders = $request->order;

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'.webp';
            $slider->photo = 'uploads/sliders/'.$imageName;

            $image = $request->file('photo');
            $destinationPath = public_path().'/'.$slider->photo;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,60);
            
            $slider->save();
            flash(translate('Slider has been inserted successfully'))->success();
        }
        return back();
    }

    public function edit($id)
    {
        $slider = Slider::findOrFail(decrypt($id));
        return view('backend.sliders.edit', compact('slider'));
    }

    public function update(Request $request, $id){
        $slider = Slider::findOrFail($id);
        $slider->orders = $request->order;
        
        if($request->hasFile('photo')){
            if($slider->photo != null || $slider->photo != ''){
                unlink(public_path($slider->photo));
            }
            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'.webp';
            $slider->photo = 'uploads/sliders/'.$imageName;

            $image = $request->file('photo');
            $destinationPath = public_path().'/'.$slider->photo;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,60);
        }
        
        if($slider->save()){
            flash(translate('Slider has been updated successfully'))->success();
            return back();
        }

        flash(translate('Something went wrong'))->error();
        return back();
    }

    public function slider_section_update(Request $request)
    {
        if($request->hasFile('sliders_logo')){

            $sliders_logo = BusinessSetting::where('type', 'sliders_logo')->first();

            if($sliders_logo->value != null || $sliders_logo->value != ''){
                unlink(public_path($sliders_logo->value));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'slide-logo.webp';
            $sliders_logo->value = 'uploads/logo/'.$imageName;

            $image = $request->file('sliders_logo');
            $destinationPath = public_path().'/'.$sliders_logo->value;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,100);

            $sliders_logo->save();
        }

        $sliders_title = BusinessSetting::where('type', 'sliders_title')->first();
        $sliders_title->value = $request->sliders_title;
        $sliders_title->save();

        $sliders_sub_title = BusinessSetting::where('type', 'sliders_sub_title')->first();
        $sliders_sub_title->value = $request->sliders_sub_title;
        $sliders_sub_title->save();

        $sliders_network_hash = BusinessSetting::where('type', 'sliders_network_hash')->first();
        $sliders_network_hash->value = $request->sliders_network_hash;
        $sliders_network_hash->save();

        $sliders_teaser_video = BusinessSetting::where('type', 'sliders_teaser_video')->first();
        $sliders_teaser_video->value = $request->sliders_teaser_video;
        $sliders_teaser_video->save();

        $sliders_hotel_book_link = BusinessSetting::where('type', 'sliders_hotel_book_link')->first();
        $sliders_hotel_book_link->value = $request->sliders_hotel_book_link;
        $sliders_hotel_book_link->save();

        flash(translate("Settings updated successfully"))->success();
        return back();
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function updatePublished(Request $request)
    {
        $slider = Slider::find($request->id);
        $slider->published = $request->published;
        if($slider->save()){
            return '1';
        }
        else {
            return '0';
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $slider = Slider::findOrFail($id);
        if(Slider::destroy($id)){
            if($slider->photo != null || $slider->photo != ''){
                unlink(public_path($slider->photo));
            }
            flash(translate('Slider has been deleted successfully'))->success();
        } else {
            flash(translate('Something went wrong'))->error();
        }
        return back();
    }
}
