<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Specialization;

class SpecializationController extends Controller
{
    public function index(Request $request) {
        $specializations = Specialization::select('id','name','published','order_number','created_at')->orderby('created_at','desc')->get();

        return view('backend.specializations.index', compact('specializations'));
    }

    public function create()
    {
        return view('backend.specializations.create');
    }

    public function store(Request $request)
    {
        $specialization = new Specialization;
        $specialization->name = $request->name;
        $specialization->order_number = $request->order_number;

        if($specialization->save()){
            flash(translate('Specialization has been inserted successfully'))->success();
            return back();
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function edit($id)
    {
        $specialization = Specialization::findOrFail(decrypt($id));
        return view('backend.specializations.edit', compact('specialization'));
    }

    public function update(Request $request, $id)
    {
        $specialization = Specialization::findOrFail($id);
        $specialization->name = $request->name;
        $specialization->order_number = $request->order_number;
       
        if($specialization->save()){
            flash(translate('Specialization has been updated successfully'))->success();
            return back();
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function destroy($id)
    {
        if(Specialization::destroy($id)){
            flash(translate('Specialization has been deleted successfully'))->success();
            return redirect()->route('specializations.index');
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function published(Request $request) {
        $specialization = Specialization::find($request->id);
        $specialization->published = $request->published;
        if($specialization->save()){
            return '1';
        }
        else {
            return '0';
        }
    }
}
