<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Sponsor;
use App\Sponsorship;

use Illuminate\Support\Str;
use Image;

class SponsorPerSponsoshipPackageController extends Controller
{
    public function index(Request $request) {
        $sponsors = Sponsor::select('id','sponsorship_id','logo','website_link','created_at')->orderby('created_at','desc')->get();

        return view('backend.sponsors.index', compact('sponsors'));
    }

    public function create()
    {
        $sponsorships = Sponsorship::select('id','name')->orderby('order_number','asc')->get();
        return view('backend.sponsors.create', compact('sponsorships'));
    }

    public function store(Request $request)
    {
        $sponsor = new Sponsor;
        $sponsor->sponsorship_id = $request->sponsorship_id;
        $sponsor->website_link = $request->website_link;

        if($request->hasFile('logo')){

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'.webp';
            $sponsor->logo = 'uploads/sponsors/'.$imageName;

            $image = $request->file('logo');
            $destinationPath = public_path().'/'.$sponsor->logo;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,90);

        }

        if($sponsor->save()){
            flash(translate('Sponsor has been inserted successfully'))->success();
            return back();
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function edit($id)
    {
        $sponsor = Sponsor::findOrFail(decrypt($id));
        $sponsorships = Sponsorship::select('id','name')->orderby('order_number','asc')->get();
        return view('backend.sponsors.edit', compact('sponsor','sponsorships'));
    }

    public function update(Request $request, $id)
    {
        $sponsor = Sponsor::findOrFail($id);
        $sponsor->sponsorship_id = $request->sponsorship_id;
        $sponsor->website_link = $request->website_link;

        if($request->hasFile('logo')){

            if($sponsor->logo != null || $sponsor->logo != ''){
                unlink(public_path($sponsor->logo));
            }

            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'.webp';
            $sponsor->logo = 'uploads/sponsors/'.$imageName;

            $image = $request->file('logo');
            $destinationPath = public_path().'/'.$sponsor->logo;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,90);

        }
       
        if($sponsor->save()){
            flash(translate('Sponsor has been updated successfully'))->success();
            return back();
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function destroy($id)
    {
        $sponsor = Sponsor::findOrFail($id);
        if(Sponsor::destroy($id)){
            if($sponsor->logo != null){
                if($sponsor->logo != null || $sponsor->logo != ''){
                    unlink(public_path($sponsor->logo));
                }
            }
            flash(translate('Sponsor has been deleted successfully'))->success();
            return redirect()->route('sponsors.index');
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
        
    }
   
}
