@extends('layouts.app')

@section('content')

<div class="col-lg-10 col-lg-offset-1 pad-btm-34">
    <div class="panel">
        <div class="panel-heading">
            <h3 class="panel-title">{{translate('Update Activity Information')}}</h3>
        </div>

        <!--Horizontal Form-->
        <!--===================================================-->
        <form class="form-horizontal" action="{{ route('activities.update', $activity->id) }}" method="POST" enctype="multipart/form-data">
            <input name="_method" type="hidden" value="PUT">
        	@csrf
            <div class="panel-body">

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="bg_color">{{translate('Order Number')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                        <input type="number" min="1" step="1" placeholder="{{translate('Order Number')}}" name="order_number" class="form-control" required value="{{ $activity->order_number }}">
                    </div>
                </div>
                
                <div class="form-group">
                    <label class="col-sm-2 control-label" for="title">{{translate('Title')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                        <input type="text" placeholder="{{translate('Title')}}" id="title" name="title" class="form-control" required value="{{ $activity->title }}">
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-sm-2 control-label" for="subtitle">{{translate('Sub Title')}} </label>
                    <div class="col-sm-10">
                        <input type="text" placeholder="{{translate('Sub Title')}}" id="subtitle" name="subtitle" class="form-control" value="{{ $activity->subtitle }}">
                    </div>
                </div>
                
                <div class="form-group">
                    <label class="col-lg-2 control-label">{{translate('Description')}} <span class="red">*</span></label>
                    <div class="col-lg-10">
                        <textarea class="editor" name="description" required>{{ $activity->description }}</textarea>
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="text_color">{{translate('Text Color')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                        <input type="text" placeholder="{{translate('Text Color')}}" id="text_color" name="text_color" class="form-control" required value="{{ $activity->text_color }}">
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="bg_color">{{translate('Background Color')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                        <input type="text" placeholder="{{translate('Background Color')}}" id="bg_color" name="bg_color" class="form-control" required value="{{ $activity->bg_color }}">
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-lg-2 control-label">{{translate('Upload Images')}} <small>(Max 6 Images)</small></label>
                    <div class="col-lg-7">
                        <div id="images">
                            @if(is_array(json_decode($activity->images)))
                                @foreach (json_decode($activity->images) as $key => $img)
                                    <div class="col-md-4 col-sm-4 col-xs-6">
                                        <div class="img-upload-preview">
                                            <img loading="lazy" onclick="window.open(this.src)" src="{{ my_asset($img) }}" src="{{ my_asset($img) }}" alt="" class="img-responsive">
                                            <input type="hidden" name="previous_images[]" value="{{ $img }}">
                                            <button type="button" class="btn btn-danger close-btn remove-files"><i class="fa fa-times"></i></button>
                                        </div>
                                    </div>
                                @endforeach
                            @endif
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="img_1_link">{{translate('Image 1 Link')}} </label>
                    <div class="col-sm-10">
                        <input type="text" placeholder="{{translate('Image 1 Link')}}" id="img_1_link" name="img_1_link" class="form-control" value="{{ $activity->img_1_link }}">
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-sm-2 control-label" for="img_2_link">{{translate('Image 2 Link')}} </label>
                    <div class="col-sm-10">
                        <input type="text" placeholder="{{translate('Image 2 Link')}}" id="img_2_link" name="img_2_link" class="form-control" value="{{ $activity->img_2_link }}">
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="img_3_link">{{translate('Image 3 Link')}} </label>
                    <div class="col-sm-10">
                        <input type="text" placeholder="{{translate('Image 3 Link')}}" id="img_3_link" name="img_3_link" class="form-control" value="{{ $activity->img_3_link }}">
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-sm-2 control-label" for="img_4_link">{{translate('Image 4 Link')}} </label>
                    <div class="col-sm-10">
                        <input type="text" placeholder="{{translate('Image 4 Link')}}" id="img_4_link" name="img_4_link" class="form-control" value="{{ $activity->img_4_link }}">
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="img_5_link">{{translate('Image 5 Link')}} </label>
                    <div class="col-sm-10">
                        <input type="text" placeholder="{{translate('Image 5 Link')}}" id="img_5_link" name="img_5_link" class="form-control" value="{{ $activity->img_5_link }}">
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-sm-2 control-label" for="img_6_link">{{translate('Image 6 Link')}} </label>
                    <div class="col-sm-10">
                        <input type="text" placeholder="{{translate('Image 6 Link')}}" id="img_6_link" name="img_6_link" class="form-control" value="{{ $activity->img_6_link }}">
                    </div>
                </div>
            </div>
            <div class="panel-footer text-right">
                <button class="btn btn-success" type="submit">{{translate('Save')}}</button>
                <a href="{{ route('activities.index') }}" name="buttonBack" class="btn btn-danger">{{ translate('Back') }}</a>
            </div>
        </form>
        <!--===================================================-->
        <!--End Horizontal Form-->

    </div>
</div>

@endsection

@section('script')

<script type="text/javascript">
	$(document).ready(function(){
		$("#images").spartanMultiImagePicker({
			fieldName:        'images[]',
			maxCount:         6,
			rowHeight:        '200px',
			groupClassName:   'col-md-4 col-sm-4 col-xs-6',
			maxFileSize:      '',
			dropFileLabel : "",
			onExtensionErr : function(index, file){
				console.log(index, file,  'extension err');
				alert('Please only input png, jpg or webp type file')
			},
			onSizeErr : function(index, file){
				console.log(index, file,  'file size too big');
				alert('File size too big');
			}
		});

		$('.remove-files').on('click', function(){
            $(this).parents(".col-md-4").remove();
        });
	});
</script>

@endsection
