@extends('layouts.app')

@section('content')

<div class="row">
    <div class="col-sm-12">
        <a href="{{ route('activities.create')}}" class="btn btn-rounded btn-info pull-right">{{translate('Add New Activity')}}</a>
    </div>
</div>

<br>

<!-- Basic Data Tables -->
<!--===================================================-->
<div class="panel">
    <div class="panel-heading bord-btm clearfix pad-all h-100">
        <h3 class="panel-title pull-left pad-no">{{translate('Activities')}}</h3>
    </div>
    <div class="panel-body">
        <table id="dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
            <thead>
                <tr>
                    <th>{{ translate('Order Number') }}</th>
                    <th>{{ translate('Title') }}</th>
                    <th>{{ translate('Subtitle') }}</th>
                    <th>{{ translate('Text Color') }}</th>
                    <th>{{ translate('Background Color') }}</th>
                    <th>{{ translate('Published') }}</th>
                    <th>{{ translate('Created At') }}</th>
                    <th width="16%">{{ translate('Options') }}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($activities as $key => $activity)
                    <tr>
                        <td>{{ $activity->order_number }}</td>
                        <td>{{ $activity->title }}</td>
                        <td>{{ $activity->subtitle ? $activity->subtitle : '-' }}</td>
                        <td>{{ $activity->text_color }}</td>
                        <td>{{ $activity->bg_color }}</td>
                        <td>
                            <label class="switch">
                            <input onchange="update_published(this)" value="{{ $activity->id }}" type="checkbox" <?php if($activity->published == 1) echo "checked";?> >
                            <span class="slider round"></span></label>
                        </td>
                        <td>{{ date('F d, Y h:i:s A', strtotime($activity->created_at)) }}</td>
                        <td>
                            <a class="btn btn-success" href="{{route('activities.edit', encrypt($activity->id))}}">{{ translate('Edit') }}</a>
                            <a class="btn btn-danger" onclick="confirm_modal('{{route('activities.destroy', $activity->id)}}');">{{ translate('Delete') }}</a>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

@endsection
@section('script')
    <script type="text/javascript">
        $(document).ready(function() {
            if ( $.fn.dataTable.isDataTable( '#dt-selection' ) ) {
                $('#dt-selection').DataTable( {
                    destroy: true,
                    "responsive": true,
                    "language": {
                        "paginate": {
                        "previous": '<i class="demo-psi-arrow-left"></i>',
                        "next": '<i class="demo-psi-arrow-right"></i>'
                        }
                    },
                    columnDefs: [
                        { orderable: false, targets: 5 },
                        { orderable: false, targets: 7 }
                    ],
                    order: [[0, 'asc']],
                } );
            }
        } );

        function update_published(el){
            if(el.checked){
                var published = 1;
            } else {
                var published = 0;
            }
            $.post('{{ route('activities.published') }}', {_token:'{{ csrf_token() }}', id:el.value, published:published}, function(data){
                if(data == 1){
                    if(published == 1){
                        showAlert('success', 'Activity published successfully');
                    } else {
                        showAlert('success', 'Activity unpublished successfully');
                    }
                } else {
                    showAlert('danger', 'Something went wrong');
                }
            });
        }
    </script>
@endsection

@section('css')
<style>
    .dataTables_wrapper .dataTables_paginate .paginate_button {
        padding: 0 0;
    }
</style>
@endsection