@extends('layouts.app')

@section('content')

<!-- Basic Data Tables -->
<!--===================================================-->
<div class="panel pad-btm-34">
    <div class="panel-heading bord-btm clearfix pad-all h-100">
        <h3 class="panel-title pull-left pad-no">{{translate('Activity Logs')}}</h3>
    </div>
    <div class="panel-body">
        <table id="dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
            <thead>
                <tr>
                    <td>{{translate('User')}}</td>
                    <td>{{translate('Action')}}</td>
                    <td>{{translate('Created At')}}</td>
                    <th width="15%">{{translate('Options')}}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($activityLogs as $key => $activityLog)
                    <tr>
                        <td>{{ $activityLog->user->name }}</td>
                        <td>{{ $activityLog->action }}</td>
                        <td>{{ date('F d, Y h:i:s A', strtotime($activityLog->created_at)) }}</td>
                        <td class="text-center">
                            <a class="btn btn-danger" onclick="confirm_modal('{{route('activity-logs.destroy', $activityLog->id)}}');">{{ translate('Delete') }}</a>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection

@section('script')
    <script type="text/javascript">
        $(document).ready(function() {
            if ( $.fn.dataTable.isDataTable( '#dt-selection' ) ) {
                $('#dt-selection').DataTable( {
                    destroy: true,
                    "responsive": true,
                    "language": {
                        "paginate": {
                        "previous": '<i class="demo-psi-arrow-left"></i>',
                        "next": '<i class="demo-psi-arrow-right"></i>'
                        }
                    },
                    columnDefs: [
                        { orderable: false, targets: 3 }
                    ],
                    order: [[2, 'asc']],
                } );
            }
        } );
    </script>
@endsection

@section('css')
    <style>
        .dataTables_wrapper .dataTables_paginate .paginate_button {
            padding: 0 0;
        }
    </style>
@endsection