@extends('layouts.login')

@section('content')

@php
    $generalsetting = \App\GeneralSetting::first();
@endphp

<!-- <div class="flex-row"> -->
    <!-- <div class="flex-col-xl-6 blank-index d-flex align-items-center justify-content-center left-logo">
        @if ($generalsetting->admin_login_sidebar != null)
            <img loading="lazy" width="97%" src="{{ my_asset($generalsetting->admin_login_sidebar) }}">
        @endif
    </div> -->
    <div class="bg-light-white center-block flex-col-xl-6">
        <div class="pad-all">
            <div class="text-center mb-3">
                @if($generalsetting->logo != null)
                    <img loading="lazy" class="top-logo" src="{{ my_asset($generalsetting->logo) }}" height="33">
                @endif
                <br>
                <br>
                <span class="sign-text">Sign in to start your session</span>
            </div>
            <br>
            <form class="pad-hor" method="POST" role="form" action="{{ route('login') }}">
                @csrf
                <div class="form-group">
                    <input id="email" type="email" class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}" name="email" value="{{ old('email') }}" required autofocus placeholder="{{ translate('Email') }}">
                    @if ($errors->has('email'))
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $errors->first('email') }}</strong>
                        </span>
                    @endif
                </div>
                <div class="form-group">
                    <input id="password" type="password" class="form-control{{ $errors->has('password') ? ' is-invalid' : '' }}" name="password" required placeholder="{{ translate('Password') }}">
                    @if ($errors->has('password'))
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $errors->first('password') }}</strong>
                        </span>
                    @endif
                </div>
                <div class="row">
                    <div class="col-sm-6">
                        <div class="checkbox pad-btm text-left">
                            <input id="demo-form-checkbox" class="magic-checkbox" type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
                            <label for="demo-form-checkbox">
                                {{ translate('Remember Me') }}
                            </label>
                        </div>
                    </div>
                    
                    @if(false && (config('mail.username') != null || config('mail.username') != "") && (config('mail.password') != null || config('mail.password') != ""))
                        <div class="col-sm-6">
                            <div class="checkbox pad-btm text-right">
                                <a href="{{ route('password.request') }}" class="btn-link">{{translate('Forgot password')}} ?</a>
                            </div>
                        </div>
                    @endif
                </div>
                <button type="submit" class="btn btn-primary btn-lg btn-block">
                    {{ translate('Login') }}
                </button>
            </form>
        </div>
    </div>
<!-- </div> -->


@endsection
