@extends('layouts.app')

@section('content')
    <div class="row">
        <div class="col-lg-12">
            <div class="panel">
                <div class="panel-heading">
                    <h3 class="panel-title text-center">{{translate('About Location Informations')}}</h3>
                </div>
                <div class="panel-body">
                    <form class="form-horizontal" action="{{ route('banners.update') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="about_location_slug">{{translate('About location Slug or Location')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('About location Slug or Location')}}" id="about_location_slug" name="about_location_slug" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'about_location_slug')->first()->value }}">
                            </div>
                        </div>

                        @if(isset(\App\BusinessSetting::where('type', 'banners_about_location_desktop')->first()->value))
                        <div class="form-group">
                            <div class="widget-image-box text-center">
                                <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'banners_about_location_desktop')->first()->value) }}" alt="Display Picture">
                            </div>
                        </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="banners_about_location_desktop">{{translate('Desktop Banner')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="banners_about_location_desktop" name="banners_about_location_desktop" class="form-control">
                            </div>
                        </div>

                        @if(isset(\App\BusinessSetting::where('type', 'banners_about_location_mobile')->first()->value))
                        <div class="form-group">
                            <div class="widget-image-box text-center">
                                <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'banners_about_location_mobile')->first()->value) }}" alt="Display Picture">
                            </div>
                        </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="banners_about_location_mobile">{{translate('Mobile Banner')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="banners_about_location_mobile" name="banners_about_location_mobile" class="form-control">
                            </div>
                        </div>

                        <br>
                        <h3 class="panel-title text-center">{{translate('About Location Details')}}</h3>
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="about_location_title">{{translate('Title')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Title')}}" id="about_location_title" name="about_location_title" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'about_location_title')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="about_location_details">{{translate('Details')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <textarea class="form-control simple-editor" name="about_location_details" required>{{ \App\BusinessSetting::where('type', 'about_location_details')->first()->value }}</textarea>
                            </div>
                        </div>

                        @if(isset(\App\BusinessSetting::where('type', 'about_location_collage')->first()->value))
                        <div class="form-group">
                            <div class="widget-image-box text-center">
                                <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'about_location_collage')->first()->value) }}" alt="Display Picture">
                            </div>
                        </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="about_location_collage">{{translate('Collage Picture')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="about_location_collage" name="about_location_collage" class="form-control">
                            </div>
                        </div>

                        <br>
                        <h3 class="panel-title text-center">{{translate('Useful Link')}}</h3>
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="about_location_useful_article_title">{{translate('Useful Article Title')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Useful Article Title')}}" id="about_location_useful_article_title" name="about_location_useful_article_title" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'about_location_useful_article_title')->first()->value }}">
                            </div>
                        </div>

                        <h3 class="panel-title text-center">{{translate('First Useful Link')}}</h3>
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="about_location_useful_article_link_1">{{translate('Useful Article Link 1')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Useful Article Title')}}" id="about_location_useful_article_link_1" name="about_location_useful_article_link_1" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'about_location_useful_article_link_1')->first()->value }}">
                            </div>
                        </div>

                        @if(isset(\App\BusinessSetting::where('type', 'about_location_useful_article_bg_img_1')->first()->value))
                        <div class="form-group">
                            <div class="widget-image-box text-center">
                                <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'about_location_useful_article_bg_img_1')->first()->value) }}" alt="Display Picture">
                            </div>
                        </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="about_location_useful_article_bg_img_1">{{translate('Useful Article Background Image 1')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="about_location_useful_article_bg_img_1" name="about_location_useful_article_bg_img_1" class="form-control">
                            </div>
                        </div>

                        <h3 class="panel-title text-center">{{translate('Second Useful Link')}}</h3>
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="about_location_useful_article_link_2">{{translate('Useful Article Link 2')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Useful Article Title')}}" id="about_location_useful_article_link_2" name="about_location_useful_article_link_2" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'about_location_useful_article_link_2')->first()->value }}">
                            </div>
                        </div>

                        @if(isset(\App\BusinessSetting::where('type', 'about_location_useful_article_bg_img_2')->first()->value))
                        <div class="form-group">
                            <div class="widget-image-box text-center">
                                <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'about_location_useful_article_bg_img_2')->first()->value) }}" alt="Display Picture">
                            </div>
                        </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="about_location_useful_article_bg_img_2">{{translate('Useful Article Background Image 2')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="about_location_useful_article_bg_img_2" name="about_location_useful_article_bg_img_2" class="form-control">
                            </div>
                        </div>

                        <h3 class="panel-title text-center">{{translate('Third Useful Link')}}</h3>
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="about_location_useful_article_link_3">{{translate('Useful Article Link 3')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Useful Article Title')}}" id="about_location_useful_article_link_3" name="about_location_useful_article_link_3" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'about_location_useful_article_link_3')->first()->value }}">
                            </div>
                        </div>

                        @if(isset(\App\BusinessSetting::where('type', 'about_location_useful_article_bg_img_3')->first()->value))
                        <div class="form-group">
                            <div class="widget-image-box text-center">
                                <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'about_location_useful_article_bg_img_3')->first()->value) }}" alt="Display Picture">
                            </div>
                        </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="about_location_useful_article_bg_img_3">{{translate('Useful Article Background Image 3')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="about_location_useful_article_bg_img_3" name="about_location_useful_article_bg_img_3" class="form-control">
                            </div>
                        </div>

                        <h3 class="panel-title text-center">{{translate('Fourth Useful Link')}}</h3>
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="about_location_useful_article_link_4">{{translate('Useful Article Link 4')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Useful Article Title')}}" id="about_location_useful_article_link_4" name="about_location_useful_article_link_4" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'about_location_useful_article_link_4')->first()->value }}">
                            </div>
                        </div>

                        @if(isset(\App\BusinessSetting::where('type', 'about_location_useful_article_bg_img_4')->first()->value))
                        <div class="form-group">
                            <div class="widget-image-box text-center">
                                <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'about_location_useful_article_bg_img_4')->first()->value) }}" alt="Display Picture">
                            </div>
                        </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="about_location_useful_article_bg_img_4">{{translate('Useful Article Background Image 4')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="about_location_useful_article_bg_img_4" name="about_location_useful_article_bg_img_4" class="form-control">
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-lg-12 text-right">
                                <button class="btn btn-success" type="submit">{{translate('Save')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
