@extends('layouts.app')

@section('content')
    <div class="row">
        <div class="col-lg-12">
            <div class="panel">
                <div class="panel-heading">
                    <h3 class="panel-title text-center">{{translate('After Movie Section')}}</h3>
                </div>
                <div class="panel-body">
                    <form class="form-horizontal" action="{{ route('aftermovie_section.update') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="aftermovie_section_title">{{translate('Title')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Title')}}" id="aftermovie_section_title" name="aftermovie_section_title" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'aftermovie_section_title')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="aftermovie_section_descriptions">{{translate('Description')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <textarea class="form-control simple-editor" name="aftermovie_section_descriptions" required>{{ \App\BusinessSetting::where('type', 'aftermovie_section_descriptions')->first()->value }}</textarea>
                            </div>
                        </div>

                        @if(isset(\App\BusinessSetting::where('type', 'aftermovie_section_display_image')->first()->value))
                            <div class="form-group">
                                <div class="widget-image-box text-center">
                                    <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'aftermovie_section_display_image')->first()->value) }}" alt="Display Picture">
                                </div>
                            </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="aftermovie_section_display_image">{{translate('Display Image')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="aftermovie_section_display_image" name="aftermovie_section_display_image" class="form-control">
                            </div>
                        </div>

                        <!-- @if(isset(\App\BusinessSetting::where('type', 'aftermovie_section_bg_image')->first()->value))
                            <div class="form-group">
                                <div class="widget-image-box text-center">
                                    <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'aftermovie_section_bg_image')->first()->value) }}" alt="Display Picture">
                                </div>
                            </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="aftermovie_section_bg_image">{{translate('Background Image')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="aftermovie_section_bg_image" name="aftermovie_section_bg_image" class="form-control">
                            </div>
                        </div> -->

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="aftermovie_section_btn_name">{{translate('Button Name')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Button Name')}}" id="aftermovie_section_btn_name" name="aftermovie_section_btn_name" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'aftermovie_section_btn_name')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="aftermovie_section_btn_link">{{translate('Button Link')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Button Link')}}" id="aftermovie_section_btn_link" name="aftermovie_section_btn_link" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'aftermovie_section_btn_link')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-lg-12 text-right">
                                <button class="btn btn-success" type="submit">{{translate('Save')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
