@extends('layouts.app')

@section('content')

<div class="col-lg-10 col-lg-offset-1 pad-btm-34">
    <div class="panel">
        <div class="panel-heading">
            <h3 class="panel-title">{{translate('Update Benefit Information')}}</h3>
        </div>

        <!--Horizontal Form-->
        <!--===================================================-->
        <form class="form-horizontal" action="{{ route('benefits.update', $benefit->id) }}" method="POST" enctype="multipart/form-data">
            <input name="_method" type="hidden" value="PUT">
        	@csrf
            <div class="panel-body">

                @if(isset($benefit->icons))
                    <div class="form-group">
                        <div class="widget-image-box text-center">
                            <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset($benefit->icons) }}" alt="Icons">
                        </div>
                    </div>
                @endif

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="icons">{{translate('Icons')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                        <input type="file" id="icons" name="icons" class="form-control">
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="details">{{translate('Details')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                        <input type="text" placeholder="{{translate('Details')}}" id="details" name="details" class="form-control" required value="{{ $benefit->details }}">
                    </div>
                </div>
                
                <div class="form-group">
                    <label class="col-sm-2 control-label" for="order_number">{{translate('Order Number')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                        <input type="number" placeholder="{{translate('Order Number')}}" id="order_number" name="order_number" class="form-control" required value="{{ $benefit->order_number }}">
                    </div>
                </div>
                
            </div>
            <div class="panel-footer text-right">
                <button class="btn btn-success" type="submit">{{translate('Save')}}</button>
                <a href="{{ route('benefits.index') }}" name="buttonBack" class="btn btn-danger">{{ translate('Back') }}</a>
            </div>
        </form>
        <!--===================================================-->
        <!--End Horizontal Form-->

    </div>
</div>

@endsection