@extends('layouts.app')

@section('content')

<div class="row">
    <div class="col-sm-12">
        <a href="{{ route('dietaries.create')}}" class="btn btn-rounded btn-info pull-right">{{translate('Add New Dietaries')}}</a>
    </div>
</div>

<br>

<!-- Basic Data Tables -->
<!--===================================================-->
<div class="panel">
    <div class="panel-heading bord-btm clearfix pad-all h-100">
        <h3 class="panel-title pull-left pad-no">{{translate('Dietaries')}}</h3>
    </div>
    <div class="panel-body">
        <table id="dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
            <thead>
                <tr>
                    <th>{{ translate('Name') }}</th>
                    <th>{{ translate('Published') }}</th>
                    <th>{{ translate('Created At') }}</th>
                    <th width="16%">{{ translate('Options') }}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($dietaries as $key => $dietary)
                    <tr>
                        <td>{{ $dietary->name }}</td>
                        <td>
                            <label class="switch">
                            <input onchange="published(this)" value="{{ $dietary->id }}" type="checkbox" <?php if($dietary->published == 1) echo "checked";?> >
                            <span class="slider round"></span></label>
                        </td>
                        <td>{{ date('F d, Y h:i:s A', strtotime($dietary->created_at)) }}</td>
                        <td>
                            <a class="btn btn-success" href="{{route('dietaries.edit', encrypt($dietary->id))}}">{{ translate('Edit') }}</a>
                            <a class="btn btn-danger" onclick="confirm_modal('{{route('dietaries.destroy', $dietary->id)}}');">{{ translate('Delete') }}</a>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

@endsection
@section('script')

<script type="text/javascript">
    $(document).ready(function() {
        if ( $.fn.dataTable.isDataTable( '#dt-selection' ) ) {
            $('#dt-selection').DataTable( {
                destroy: true,
                "responsive": true,
                "language": {
                    "paginate": {
                    "previous": '<i class="demo-psi-arrow-left"></i>',
                    "next": '<i class="demo-psi-arrow-right"></i>'
                    }
                },
                columnDefs: [
                    { orderable: false, targets: 1 },
                    { orderable: false, targets: 3 }
                ],
                order: [[2, 'desc']],
            } );
        }
    } );

    function published(el){
        if(el.checked){
            var published = 1;
        } else {
            var published = 0;
        }
        $.post('{{ route('dietaries.published') }}', {_token:'{{ csrf_token() }}', id:el.value, published:published}, function(data){
            if(data == 1){
                showAlert('success', 'Dietary published status changed successfully');
            }
            else{
                showAlert('danger', 'Something went wrong');
            }
        });
    }

</script>

@endsection

@section('css')

<style>
    .dataTables_wrapper .dataTables_paginate .paginate_button {
        padding: 0 0;
    }
</style>

@endsection