@extends('layouts.app')

@section('content')
    <div class="row">
        <div class="col-lg-12">
            <div class="panel">
                <div class="panel-heading">
                    <h3 class="panel-title text-center">{{translate('Director Section')}}</h3>
                </div>
                <div class="panel-body">
                    <form class="form-horizontal" action="{{ route('director_section.update') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="director_section_title">{{translate('Title')}}   </label>
                            <div class="col-sm-10">
                                <textarea class="form-control simple-editor" name="director_section_title">{{ \App\BusinessSetting::where('type', 'director_section_title')->first()->value }}</textarea>
                            </div>
                        </div>

                        @if(isset(\App\BusinessSetting::where('type', 'director_section_photo')->first()->value))
                        <div class="form-group">
                            <div class="widget-image-box text-center">
                                <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'director_section_photo')->first()->value) }}" alt="Display Picture">
                            </div>
                        </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="director_section_photo">{{translate('Director Image')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="director_section_photo" name="director_section_photo" class="form-control">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="director_section_name">{{translate('Name')}} </label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Name')}}" id="director_section_name" name="director_section_name" class="form-control" value="{{ \App\BusinessSetting::where('type', 'director_section_name')->first()->value }}">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="director_section_designation">{{translate('Designation')}} </label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Designation')}}" id="director_section_designation" name="director_section_designation" class="form-control" value="{{ \App\BusinessSetting::where('type', 'director_section_designation')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="director_section_message">{{translate('Director Message')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <textarea class="form-control editor" name="director_section_message" required>{{ \App\BusinessSetting::where('type', 'director_section_message')->first()->value }}</textarea>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-lg-12 text-right">
                                <button class="btn btn-success" type="submit">{{translate('Save')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection