@extends('layouts.app')

@section('content')
    <div class="row">
        <div class="col-lg-12">
            <div class="panel">
                <div class="panel-heading">
                    <h3 class="panel-title text-center">{{translate('Hotel Page')}}</h3>
                </div>
                <div class="panel-body">
                    <form class="form-horizontal" action="{{ route('hotel_section.update') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        @if(isset(\App\BusinessSetting::where('type', 'banners_hotel_desktop')->first()->value))
                        <div class="form-group">
                            <div class="widget-image-box text-center">
                                <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'banners_hotel_desktop')->first()->value) }}" alt="Display Picture">
                            </div>
                        </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="banners_hotel_desktop">{{translate('Desktop Banner')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="banners_hotel_desktop" name="banners_hotel_desktop" class="form-control">
                            </div>
                        </div>

                        @if(isset(\App\BusinessSetting::where('type', 'banners_hotel_mobile')->first()->value))
                        <div class="form-group">
                            <div class="widget-image-box text-center">
                                <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'banners_hotel_mobile')->first()->value) }}" alt="Display Picture">
                            </div>
                        </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="banners_hotel_mobile">{{translate('Mobile Banner')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="banners_hotel_mobile" name="banners_hotel_mobile" class="form-control">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="hotel_section_main_title">{{translate('Title')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Title')}}" id="hotel_section_main_title" name="hotel_section_main_title" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'hotel_section_main_title')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="hotel_section_description">{{translate('Description')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <textarea class="form-control" rows="10" name="hotel_section_description" required>{{ \App\BusinessSetting::where('type', 'hotel_section_description')->first()->value }}</textarea>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="hotel_section_location">{{translate('Location')}} </label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Location')}}" id="hotel_section_location" name="hotel_section_location" class="form-control" value="{{ \App\BusinessSetting::where('type', 'hotel_section_location')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="hotel_section_contact_number">{{translate('Contact Number')}} </label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Contact Number')}}" id="hotel_section_contact_number" name="hotel_section_contact_number" class="form-control" value="{{ \App\BusinessSetting::where('type', 'hotel_section_contact_number')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="hotel_section_email">{{translate('Email')}} </label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Email')}}" id="hotel_section_email" name="hotel_section_email" class="form-control" value="{{ \App\BusinessSetting::where('type', 'hotel_section_email')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="hotel_section_room_rates">{{translate('Room Rates')}} </label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Room Rates')}}" id="hotel_section_room_rates" name="hotel_section_room_rates" class="form-control" value="{{ \App\BusinessSetting::where('type', 'hotel_section_room_rates')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="hotel_section_inclusions">{{translate('Inclusions')}} </label>
                            <div class="col-sm-10">
                                <textarea class="form-control editor" name="hotel_section_inclusions">{{ \App\BusinessSetting::where('type', 'hotel_section_inclusions')->first()->value }}</textarea>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="hotel_section_note">{{translate('Notes')}} </label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Notes')}}" id="hotel_section_note" name="hotel_section_note" class="form-control" value="{{ \App\BusinessSetting::where('type', 'hotel_section_note')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-lg-12 text-right">
                                <button class="btn btn-success" type="submit">{{translate('Save')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
