@extends('layouts.app')

@section('content')
    <div class="row">
        <div class="col-lg-12">
            <div class="panel">
                <div class="panel-heading">
                    <h3 class="panel-title text-center">{{translate('Hotel Section')}}</h3>
                </div>
                <div class="panel-body">
                    <form class="form-horizontal" action="{{ route('hotel_section.update') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="hotel_section_home_title">{{translate('Home Page Title')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Title')}}" id="hotel_section_home_title" name="hotel_section_home_title" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'hotel_section_home_title')->first()->value }}">
                            </div>
                        </div>

                        <!-- <div class="form-group">
                            <label class="col-sm-2 control-label" for="hotel_section_short_description">{{translate('Hotel Section Short Description')}} </label>
                            <div class="col-sm-10">
                                <textarea class="form-control" rows="5" name="hotel_section_short_description">{{ \App\BusinessSetting::where('type', 'hotel_section_short_description')->first()->value }}</textarea>
                            </div>
                        </div> -->

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="hotel_section_home_description">{{translate('Home Section Description')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <textarea class="form-control" rows="8" name="hotel_section_home_description" required>{{ \App\BusinessSetting::where('type', 'hotel_section_home_description')->first()->value }}</textarea>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-lg-12 text-right">
                                <button class="btn btn-success" type="submit">{{translate('Save')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="panel">
                <div class="panel-heading">
                    <h3 class="panel-title text-center">{{translate('Hotel Images')}}</h3>
                </div>
                <div class="panel-body">
                    <form class="form-horizontal" action="{{ route('hotel_section.update') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        @if(isset(\App\BusinessSetting::where('type', 'hotel_section_image1')->first()->value))
                            <div class="form-group">
                                <div class="widget-image-box text-center">
                                    <img loading="lazy" style="max-width: 100% !important; height: 255px !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'hotel_section_image1')->first()->value) }}" alt="Banner">
                                </div>
                            </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="hotel_section_image1">{{translate('First Hotel Image')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="hotel_section_image1" name="hotel_section_image1" class="form-control" required>
                            </div>
                        </div>

                        @if(isset(\App\BusinessSetting::where('type', 'hotel_section_image2')->first()->value))
                            <div class="form-group">
                                <div class="widget-image-box text-center">
                                    <img loading="lazy" style="max-width: 100% !important; height: 255px !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'hotel_section_image2')->first()->value) }}" alt="Banner">
                                </div>
                            </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="hotel_section_image2">{{translate('Second Hotel Image')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="hotel_section_image2" name="hotel_section_image2" class="form-control" required>
                            </div>
                        </div>

                        @if(isset(\App\BusinessSetting::where('type', 'hotel_section_image3')->first()->value))
                            <div class="form-group">
                                <div class="widget-image-box text-center">
                                    <img loading="lazy" style="max-width: 100% !important; height: 255px !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'hotel_section_image3')->first()->value) }}" alt="Banner">
                                </div>
                            </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="hotel_section_image3">{{translate('Third Hotel Image')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="hotel_section_image3" name="hotel_section_image3" class="form-control" required>
                            </div>
                        </div>

                        @if(isset(\App\BusinessSetting::where('type', 'hotel_section_image4')->first()->value))
                            <div class="form-group">
                                <div class="widget-image-box text-center">
                                    <img loading="lazy" style="max-width: 100% !important; height: 255px !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'hotel_section_image4')->first()->value) }}" alt="Banner">
                                </div>
                            </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="hotel_section_image4">{{translate('Fourth Hotel Image')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="hotel_section_image4" name="hotel_section_image4" class="form-control" required>
                            </div>
                        </div>

                        @if(isset(\App\BusinessSetting::where('type', 'hotel_section_image5')->first()->value))
                            <div class="form-group">
                                <div class="widget-image-box text-center">
                                    <img loading="lazy" style="max-width: 100% !important; height: 255px !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'hotel_section_image5')->first()->value) }}" alt="Banner">
                                </div>
                            </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="hotel_section_image5">{{translate('Fifth Hotel Image')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="hotel_section_image5" name="hotel_section_image5" class="form-control" required>
                            </div>
                        </div>

                        @if(isset(\App\BusinessSetting::where('type', 'hotel_section_image6')->first()->value))
                            <div class="form-group">
                                <div class="widget-image-box text-center">
                                    <img loading="lazy" style="max-width: 100% !important; height: 255px !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'hotel_section_image6')->first()->value) }}" alt="Banner">
                                </div>
                            </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="hotel_section_image6">{{translate('Sixth Hotel Image')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="hotel_section_image6" name="hotel_section_image6" class="form-control" required>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-lg-12 text-right">
                                <button class="btn btn-success" type="submit">{{translate('Save')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
