@extends('layouts.app')

@section('content')

<!-- Basic Data Tables -->
<!--===================================================-->
<div class="panel">
    <div class="panel-heading bord-btm clearfix pad-all h-100">
        <h3 class="panel-title pull-left pad-no">{{translate('Emails from contact us')}}</h3>
    </div>
    <div class="panel-body">
        <table id="dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
            <thead>
                <tr>
                    <th>{{ translate('Company Name') }}</th>
                    <th>{{ translate('Full Name') }}</th>
                    <th>{{ translate('Email Address') }}</th>
                    <th>{{ translate('Phone Number') }}</th>
                    <th>{{ translate('Mobile Number') }}</th>
                    <th>{{ translate('Website URL') }}</th>
                    <th>{{ translate('Message') }}</th>
                    <th>{{ translate('Created At') }}</th>
                    <th width="16%">{{ translate('Options') }}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($emails as $key => $email)
                    <tr>
                        <td>{{ $email->company_name }}</td>
                        <td>{{ $email->name }}</td>
                        <td><a href="mailto:{{ $email->email }}">{{ $email->email }}</a></td>
                        <td>{{ $email->phone_number }}</td>
                        <td>{{ $email->mobile_number }}</td>
                        <td><a href="{{ $email->website_url }}">{{ $email->website_url }}</a></td>
                        <td>{{ $email->message }}</td>
                        <td>{{ date('F d, Y h:i:s A', strtotime($email->created_at)) }}</td>
                        <td>
                            <a class="btn btn-success" href="{{route('inquiry.view', encrypt($email->id))}}">{{ translate('View') }}</a>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

@endsection
@section('script')

<script type="text/javascript">
    $(document).ready(function() {
        if ( $.fn.dataTable.isDataTable( '#dt-selection' ) ) {
            $('#dt-selection').DataTable( {
                destroy: true,
                "responsive": true,
                "language": {
                    "paginate": {
                    "previous": '<i class="demo-psi-arrow-left"></i>',
                    "next": '<i class="demo-psi-arrow-right"></i>'
                    }
                },
                columnDefs: [
                    { orderable: false, targets: 8 },
                ],
                order: [[7, 'desc']],
            } );
        }
    } );

</script>

@endsection

@section('css')

<style>
    .dataTables_wrapper .dataTables_paginate .paginate_button {
        padding: 0 0;
    }
</style>

@endsection