@extends('layouts.app')

@section('content')

<div class="col-lg-10 col-lg-offset-1 pad-btm-34">
    <div class="panel">
        <div class="panel-heading">
            <h3 class="panel-title">{{translate('Update Meeting Cost Information')}}</h3>
        </div>

        <!--Horizontal Form-->
        <!--===================================================-->
        <form class="form-horizontal" action="{{ route('meeting_costs.update', $meetingCost->id) }}" method="POST" enctype="multipart/form-data">
            <input name="_method" type="hidden" value="PUT">
        	@csrf
            <div class="panel-body">

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="title">{{translate('Title')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                        <input type="text" placeholder="{{translate('Title')}}" id="title" name="title" class="form-control" required value="{{ $meetingCost->title }}">
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="early_bird_rate_price">{{translate('Early Bird Rate')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                        <input type="number" placeholder="{{translate('Early Bird Rate')}}" id="early_bird_rate_price" name="early_bird_rate_price" class="form-control" required value="{{ $meetingCost->early_bird_rate_price }}">
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="early_bird_rate_date">{{translate('Early Bird Valid Until')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                        <input type="text" placeholder="{{translate('Early Bird Valid Until')}}" id="early_bird_rate_date" name="early_bird_rate_date" class="form-control" required value="{{ $meetingCost->early_bird_rate_date }}">
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="regular_rate_price">{{translate('Regular Rate')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                        <input type="number" placeholder="{{translate('Regular Rate')}}" id="regular_rate_price" name="regular_rate_price" class="form-control" required value="{{ $meetingCost->regular_rate_price }}">
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="meeting_cost_details">{{translate('Details')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                        <textarea class="form-control editor" name="meeting_cost_details" required>{{ $meetingCost->meeting_cost_details }}</textarea>
                    </div>
                </div>
                
            </div>
            <div class="panel-footer text-right">
                <button class="btn btn-success" type="submit">{{translate('Save')}}</button>
                <a href="{{ route('meeting_costs.index') }}" name="buttonBack" class="btn btn-danger">{{ translate('Back') }}</a>
            </div>
        </form>
        <!--===================================================-->
        <!--End Horizontal Form-->

    </div>
</div>

@endsection