@extends('layouts.app')

@section('content')
    <div class="row">
        <div class="col-lg-12">
            <div class="panel">
                <div class="panel-heading">
                    <h3 class="panel-title text-center">{{translate('Meeting Scheduler Informations')}}</h3>
                </div>
                <div class="panel-body">
                    <form class="form-horizontal" action="{{ route('banners.update') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="meeting_scheduler_title">{{translate('Title')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Title')}}" id="meeting_scheduler_title" name="meeting_scheduler_title" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'meeting_scheduler_title')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="meeting_scheduler_details">{{translate('Details')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <textarea class="form-control simple-editor" name="meeting_scheduler_details" required>{{ \App\BusinessSetting::where('type', 'meeting_scheduler_details')->first()->value }}</textarea>
                            </div>
                        </div>

                        @if(isset(\App\BusinessSetting::where('type', 'banners_meeting_scheduler_desktop')->first()->value))
                        <div class="form-group">
                            <div class="widget-image-box text-center">
                                <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'banners_meeting_scheduler_desktop')->first()->value) }}" alt="Display Picture">
                            </div>
                        </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="banners_meeting_scheduler_desktop">{{translate('Desktop Banner')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="banners_meeting_scheduler_desktop" name="banners_meeting_scheduler_desktop" class="form-control">
                            </div>
                        </div>

                        @if(isset(\App\BusinessSetting::where('type', 'banners_meeting_scheduler_mobile')->first()->value))
                        <div class="form-group">
                            <div class="widget-image-box text-center">
                                <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'banners_meeting_scheduler_mobile')->first()->value) }}" alt="Display Picture">
                            </div>
                        </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="banners_meeting_scheduler_mobile">{{translate('Mobile Banner')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="banners_meeting_scheduler_mobile" name="banners_meeting_scheduler_mobile" class="form-control">
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-lg-12 text-right">
                                <button class="btn btn-success" type="submit">{{translate('Save')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-lg-12">
            <div class="panel">
                <div class="panel-heading">
                    <h3 class="panel-title text-center">{{translate('Meeting Schedulers Icons and Name')}}</h3>
                </div>
                <div class="panel-body">
                    <form class="form-horizontal" action="{{ route('meeting_scheduler.update') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        <h3 class="panel-title text-center">{{translate('First Icon')}}</h3>
                        @if(isset(\App\BusinessSetting::where('type', 'meeting_scheduler_icon_1')->first()->value))
                        <div class="form-group">
                            <div class="widget-image-box text-center">
                                <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'meeting_scheduler_icon_1')->first()->value) }}" alt="Display Picture">
                            </div>
                        </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="meeting_scheduler_icon_1">{{translate('Icon 1')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="meeting_scheduler_icon_1" name="meeting_scheduler_icon_1" class="form-control">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="meeting_scheduler_title_1">{{translate('Icon 1 Description')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Title')}}" id="meeting_scheduler_title_1" name="meeting_scheduler_title_1" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'meeting_scheduler_title_1')->first()->value }}">
                            </div>
                        </div>

                        <h3 class="panel-title text-center">{{translate('Second Icon')}}</h3>
                        @if(isset(\App\BusinessSetting::where('type', 'meeting_scheduler_icon_2')->first()->value))
                        <div class="form-group">
                            <div class="widget-image-box text-center">
                                <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'meeting_scheduler_icon_2')->first()->value) }}" alt="Display Picture">
                            </div>
                        </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="meeting_scheduler_icon_2">{{translate('Icon 2')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="meeting_scheduler_icon_2" name="meeting_scheduler_icon_2" class="form-control">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="meeting_scheduler_title_2">{{translate('Icon 2 Description')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Title')}}" id="meeting_scheduler_title_2" name="meeting_scheduler_title_2" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'meeting_scheduler_title_2')->first()->value }}">
                            </div>
                        </div>

                        <h3 class="panel-title text-center">{{translate('Third Icon')}}</h3>
                        @if(isset(\App\BusinessSetting::where('type', 'meeting_scheduler_icon_3')->first()->value))
                        <div class="form-group">
                            <div class="widget-image-box text-center">
                                <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'meeting_scheduler_icon_3')->first()->value) }}" alt="Display Picture">
                            </div>
                        </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="meeting_scheduler_icon_3">{{translate('Icon 3')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="meeting_scheduler_icon_3" name="meeting_scheduler_icon_3" class="form-control">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="meeting_scheduler_title_3">{{translate('Icon 3 Description')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Title')}}" id="meeting_scheduler_title_3" name="meeting_scheduler_title_3" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'meeting_scheduler_title_3')->first()->value }}">
                            </div>
                        </div>

                        <h3 class="panel-title text-center">{{translate('Fourth Icon')}}</h3>
                        @if(isset(\App\BusinessSetting::where('type', 'meeting_scheduler_icon_4')->first()->value))
                        <div class="form-group">
                            <div class="widget-image-box text-center">
                                <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'meeting_scheduler_icon_4')->first()->value) }}" alt="Display Picture">
                            </div>
                        </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="meeting_scheduler_icon_4">{{translate('Icon 4')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="meeting_scheduler_icon_4" name="meeting_scheduler_icon_4" class="form-control">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="meeting_scheduler_title_4">{{translate('Icon 4 Description')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Title')}}" id="meeting_scheduler_title_4" name="meeting_scheduler_title_4" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'meeting_scheduler_title_4')->first()->value }}">
                            </div>
                        </div>

                        <h3 class="panel-title text-center">{{translate('Fifth Icon')}}</h3>
                        @if(isset(\App\BusinessSetting::where('type', 'meeting_scheduler_icon_5')->first()->value))
                        <div class="form-group">
                            <div class="widget-image-box text-center">
                                <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'meeting_scheduler_icon_5')->first()->value) }}" alt="Display Picture">
                            </div>
                        </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="meeting_scheduler_icon_5">{{translate('Icon 4')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="meeting_scheduler_icon_5" name="meeting_scheduler_icon_5" class="form-control">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="meeting_scheduler_title_5">{{translate('Icon 4 Description')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Title')}}" id="meeting_scheduler_title_5" name="meeting_scheduler_title_5" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'meeting_scheduler_title_5')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-lg-12 text-right">
                                <button class="btn btn-success" type="submit">{{translate('Save')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
