@extends('layouts.app')

@section('content')
    <div class="row">
        <div class="col-lg-12">
            <div class="panel">
                <div class="panel-heading">
                    <h3 class="panel-title text-center">{{translate('Nav Section')}}</h3>
                </div>
                <div class="panel-body">
                    <form class="form-horizontal" action="{{ route('nav_section.update') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        <h3 class="panel-title text-center">{{translate('Main Page Nav Button')}}</h3>
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="nav_main_page_link">{{translate('Main Page Link')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Main Page Link')}}" id="nav_main_page_link" name="nav_main_page_link" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'nav_main_page_link')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="nav_main_page_css_style">{{translate('Main Page CSS Style')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Main Page CSS Style')}}" id="nav_main_page_css_style" name="nav_main_page_css_style" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'nav_main_page_css_style')->first()->value }}">
                            </div>
                        </div>

                        <h3 class="panel-title text-center">{{translate('Agenda Nav Button')}}</h3>
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="nav_agenda_css_style">{{translate('Agenda CSS Style')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Agenda CSS Style')}}" id="nav_agenda_css_style" name="nav_agenda_css_style" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'nav_agenda_css_style')->first()->value }}">
                            </div>
                        </div>

                        <h3 class="panel-title text-center">{{translate('Contact US Nav Button')}}</h3>
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="nav_contact_us_css_style">{{translate('Contact US CSS Style')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Contact US CSS Style')}}" id="nav_contact_us_css_style" name="nav_contact_us_css_style" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'nav_contact_us_css_style')->first()->value }}">
                            </div>
                        </div>

                        <h3 class="panel-title text-center">{{translate('Register Nav Button')}}</h3>
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="nav_register_now_css_style">{{translate('Register CSS Style')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Register CSS Style')}}" id="nav_register_now_css_style" name="nav_register_now_css_style" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'nav_register_now_css_style')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-lg-12 text-right">
                                <button class="btn btn-purple" type="submit">{{translate('Save')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
