@extends('layouts.app')

@section('content')

<!-- Basic Data Tables -->
<!--===================================================-->
<div class="panel">
    <div class="panel-heading bord-btm clearfix pad-all h-100">
        <h3 class="panel-title pull-left pad-no">{{translate('Registrants')}}</h3>
    </div>
    <div class="panel-body">
        <table id="dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
            <thead>
                <tr>
                    <th>{{ translate('Title') }}</th>
                    <th>{{ translate('Firstname') }}</th>
                    <th>{{ translate('Lastname') }}</th>
                    <th>{{ translate('Designation') }}</th>
                    <th>{{ translate('Email') }}</th>
                    <th>{{ translate('Mobile') }}</th>

                    <th>{{ translate('Shirt Size') }}</th>

                    <th>{{ translate('Company') }}</th>
                    <th>{{ translate('Telephone') }}</th>
                    <th>{{ translate('Website') }}</th>
                    <th>{{ translate('IATA Number') }}</th>
                    <th>{{ translate('Address') }}</th>
                    <th>{{ translate('City') }}</th>
                    <th>{{ translate('Country') }}</th>

                    <th>{{ translate('Early Bird') }}</th>

                    <th>{{ translate('Is Joining our city tour activity on day 3?') }}</th>

                    <th>{{ translate('Total Price') }}</th>

                    <th>{{ translate('Status') }}</th>

                    <th>{{ translate('Created At') }}</th>

                    <th>{{ translate('Options') }}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($registrations as $key => $registration)
                    @php
                        if($registration->status == 1){
                            $status = 'Pending Payment';
                        } elseif($registration->status == 2) {
                            $status = 'Paid for Confirmation';
                        } else {
                            $status = 'Confirmed';
                        }
                    @endphp
                    <tr>
                        <td>{{ $registration->salutation }}</td>
                        <td>{{ $registration->firstname }}</td>
                        <td>{{ $registration->lastname }}</td>
                        <td>{{ $registration->position }}</td>
                        <td>{{ $registration->email }}</td>
                        <td>{{ $registration->mobile }}</td>
                        
                        <td>{{ $registration->shirt_size }}</td>

                        <td>{{ $registration->company }}</td>
                        <td>{{ $registration->telephone }}</td>
                        <td>{{ $registration->website }}</td>
                        <td>{{ $registration->iata ? $registration->iata : '-' }}</td>
                        <td>{{ $registration->address }}</td>
                        <td>{{ $registration->city }}</td>
                        <td>{{ $registration->country }}</td>

                        <td>{{ $registration->early_bird == 1 ? 'Yes' : 'No' }}</td>

                        <td>{{ $registration->is_joining_city_tour }}</td>

                        <td>{{ number_format($registration->total_price,2) }}</td>
                        
                        <td>{{ $status }}</td>
                            
                        <td>{{ date('F d, Y h:i:s A', strtotime($registration->created_at)) }}</td>

                        <td>
                            <a class="btn btn-success" href="{{route('registrations.view', encrypt($registration->id))}}">{{ translate('View More Details') }}</a>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

@endsection
@section('script')

<script type="text/javascript">
    $(document).ready(function() {
        if ( $.fn.dataTable.isDataTable( '#dt-selection' ) ) {
            $('#dt-selection').DataTable( {
                destroy: true,
                "responsive": true,
                "language": {
                    "paginate": {
                    "previous": '<i class="demo-psi-arrow-left"></i>',
                    "next": '<i class="demo-psi-arrow-right"></i>'
                    }
                },
                columnDefs: [
                    { orderable: false, targets: 19 },
                ],
                order: [[18, 'desc']],
            } );
        }
    } );

</script>

@endsection

@section('css')

<style>
    .dataTables_wrapper .dataTables_paginate .paginate_button {
        padding: 0 0;
    }
</style>

@endsection