@extends('layouts.app')

@section('content')

<div class="col-lg-12 pad-btm-34">
    <div class="panel">
        <div class="panel-heading">
            <h3 class="panel-title">{{translate('Registrants Information')}}</h3>
        </div>

        <!--Horizontal Form-->
        <!--===================================================-->
        <form class="form-horizontal" action="" method="POST" enctype="multipart/form-data">
            
            <div class="panel-body">

                <p>
                    Below are the details that have registered online to the RW Expos 2024.
                    Please get in touch with them shortly.
                </p>
                <p>
                    The following is the details of your online registration
                </p>

                <table width="100%" style="border-collapse: collapse;">
                    <tr class="header">
                        <td style="text-align:center" colspan="2">Personal Information</td>
                    </tr>
                    <tr class="header">
                        <td style="text-align: center">Title</td>
                        <td style="text-align: center">Description</td>
                    </tr>
                    <tr>
                        <td>First Name:</td>
                        <td>{{ $data['personal']['firstname'] }}</td>
                    </tr>
                    <tr>
                        <td>Last Name:</td>
                        <td>{{ $data['personal']['lastname'] }}</td>
                    </tr>
                    <tr>
                        <td>T-shirt size:</td>
                        <td>{{ $data['personal']['shirt_size'] }}</td>
                    </tr>
                    <tr>
                        <td>Joining our city tour activity on day 3:</td>
                        <td>{{ $data['company_data']['is_joining_city_tour'] }}</td>
                    </tr>
                    <tr>
                        <td>Dietary Restrictions:</td>
                        <td>
                            @if (count($data['dietaries']) > 0)
                                @foreach ($data['dietaries'] as $diet)
                                    {{ $diet->dietary }} 
                                    @if (count($data['dietaries']) > 1)
                                        ,
                                    @endif
                                @endforeach
                            @endif
                        </td>
                    </tr>
                </table>

                <table width="100%" style="border-collapse: collapse; margin-top: 10px">
                    <tr class="header">
                        <td style="text-align:center" colspan="2">Company Information</td>
                    </tr>
                    <tr class="header">
                        <td style="text-align: center">Title</td>
                        <td style="text-align: center">Description</td>
                    </tr>
                    <tr>
                        <td>Company:</td>
                        <td>{{ $data['company_data']['company_name'] }}</td>
                    </tr>
                    <tr>
                        <td>Position:</td>
                        <td>{{ $data['personal']['designation'] }}</td>
                    </tr>
                    <tr>
                        <td>Email:</td>
                        <td>{{ $data['personal']['email'] }}</td>
                    </tr>
                    <tr>
                        <td>Telephone:</td>
                        <td>{{ $data['company_data']['telephone'] }}</td>
                    </tr>
                    <tr>
                        <td>Mobile no:</td>
                        <td>{{ $data['personal']['mobile'] }}</td>
                    </tr>
                    <tr>
                        <td>Website:</td>
                        <td>{{ $data['company_data']['website'] }}</td>
                    </tr>
                    <tr>
                        <td>IATA Number:</td>
                        <td>{{ $data['company_data']['iata'] }}</td>
                    </tr>
                    <tr>
                        <td>Address:</td>
                        <td>{{ $data['company_data']['address'] }}</td>
                    </tr>
                    <tr>
                        <td>City:</td>
                        <td>{{ $data['company_data']['city'] }}</td>
                    </tr>
                    <tr>
                        <td>Country:</td>
                        <td>{{ $data['company_data']['country'] }}</td>
                    </tr>
                    @if (count($data['specializations']) > 0)
                    <tr>
                        <td>Specialization:</td>
                        <td>
                            @if (count($data['specializations']) > 0)
                                @foreach ($data['specializations'] as $specialization)
                                    {{ $specialization->name }}
                                    @if (count($data['specializations']) > 1)
                                        ,
                                    @endif
                                @endforeach
                            @else
                                N/A
                            @endif
                        </td>
                    </tr>
                    @endif
                    @if (count($data['softwares']) > 0)
                    <tr>
                        <td>RW Networks</td>
                        <td>
                            @if (count($data['softwares']) > 0)
                                @foreach ($data['softwares'] as $software)
                                    {{ $software->name }}
                                    @if (count($data['softwares']) > 1)
                                        ,
                                    @endif
                                @endforeach
                            @else
                                N/A
                            @endif
                        </td>
                    </tr>
                    @endif
                    @if (count($data['services']) > 0)
                    <tr>
                        <td>What services do you offer?</td>
                        <td>
                            @if (count($data['services']) > 0)
                                @foreach ($data['services'] as $service)
                                    {{ $service->name }}
                                    @if (count($data['services']) > 1)
                                        ,
                                    @endif
                                @endforeach
                                @if(isset($other_services))
                                    , {{ $other_services }}
                                @endif
                            @else
                                N/A
                            @endif
                        </td>
                    </tr>
                    @endif
                </table>

                <table width="100%" style="border-collapse: collapse; margin-top: 10px">
                    <tr class="header">
                        <td style="text-align:center" colspan="4">Selected Sponsorship and Others(s)</td>
                    </tr>
                    <tr class="header">
                        <td>Category</td>
                        <td>Name</td>
                        <td>Quantity</td>
                        <td class="text-right">Price</td>
                    </tr>

                    @if(!$data['vip'] == '')
                        <tr>
                            <td>Registration</td>
                            @if($data['checker'] == 1)
                                <td>Signed as VIP Early Bird Registration Fee</td>
                            @else
                                <td>Signed as VIP Regular Registration Fee</td>
                            @endif
                            <td>1</td>
                            <td class="text-right">${{ number_format($data['vip'], 2) }}</td>
                        </tr>
                    @endif

                    @if(isset($data['registered_name']))
                        @foreach($data['registered_name'] as $register)
                            <tr>
                                <td>Registration</td>
                                @if( $data['checker'] == 1)
                                    <td>Early Bird Registration Fee</td>
                                @else
                                    <td>Regular Registration Fee</td>
                                @endif
                                <td>1</td>
                                <td class="text-right">{{ $register->fee }}</td>
                            </tr>
                        @endforeach
                    @endif

                    @foreach($data['sponsors'] as $sponsor)
                    
                        @if($sponsor->id < 4) 
                            <tr>
                                <td>Premium Sponsorship</td>
                                <td>{{ $sponsor->name }}</td>
                                <td>1</td>
                                <td class="text-right">${{ number_format($sponsor->price, 2) }}</td>
                            </tr>
                        @elseif($sponsor->id >= 4) 
                            <tr>
                                <td>Onsite Branding Sponsorship</td>
                                <td>{{ $sponsor->name }}</td>
                                <td>1</td>
                                <td class="text-right">${{ number_format($sponsor->price, 2) }}</td>
                            </tr>
                        @endif

                    @endforeach

                    

                    @foreach($data['advertisements'] as $advertisement)
                        <tr>
                            <td>Advertisements</td>
                            <td>{{ $advertisement->name }}</td>
                            <td>1</td>
                            <td class="text-right">${{ number_format($advertisement->price, 2) }}</td>
                        </tr>
                    @endforeach

                    <tr>
                        <td colspan="3" class="border text-right font-bold" align="right">Total</td>
                        <td class="text-right font-bold" align="right">${{ number_format($data['total_price'], 2) }}</td>
                    </tr>
                </table>

                <table width="100%" style="border-collapse: collapse; margin-top: 10px;">
                    <tr class="header">
                        <td style="text-align:center" colspan="2">How did you learn about us?</td>
                    </tr>
                    <tr class="header">
                        <td style="text-align: center"></td>
                        <td style="text-align: center">Message</td>
                    </tr>
                    <tr>
                        <td>{{ $data['learn_about_us'] }}</td>
                        <td>{{ $data['comment'] }}</td>
                    </tr>
                </table>

            </div>
            <div class="panel-footer text-right">
                <a href="{{ route('registrations.index') }}" name="buttonBack" class="btn btn-danger">{{ translate('Back') }}</a>
            </div>
        </form>
        <!--===================================================-->
        <!--End Horizontal Form-->

    </div>
</div>

@endsection

@section('css')

<style>
    td {
        border: 1px solid #dddddd;
        text-align: left;
        padding: 8px;
    }

    .header td {
        font-weight: bold;
    }

    .borderless {
        border: none;
    }

    .text-right {
        text-align: right;
    }

    .font-bold {
        font-weight: bold;
    }
</style>

@endsection