@extends('layouts.app')

@section('content')

<div class="row">
    <div class="col-lg-12">
        <div class="panel">
            <div class="panel-heading">
                <h3 class="panel-title text-center">{{translate('Sliders Section')}}</h3>
            </div>
            <div class="panel-body">
                <form class="form-horizontal" action="{{ route('slider_section.update') }}" method="POST" enctype="multipart/form-data">
                    @csrf

                    @if(isset(\App\BusinessSetting::where('type', 'sliders_logo')->first()->value))
                    <div class="form-group">
                        <div class="bg-gray text-center widget-image-box">
                            <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'sliders_logo')->first()->value) }}" alt="Display Picture">
                        </div>
                    </div>
                    @endif
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="sliders_logo">{{translate('Sliders Logo')}} <span class="red">*</span></label>
                        <div class="col-sm-10">
                            <input type="file" id="sliders_logo" name="sliders_logo" class="form-control">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="sliders_title">{{translate('Title')}} <span class="red">*</span></label>
                        <div class="col-sm-10">
                            <textarea class="form-control editor" name="sliders_title" required>{{ \App\BusinessSetting::where('type', 'sliders_title')->first()->value }}</textarea>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="sliders_sub_title">{{translate('Sub Title')}} </label>
                        <div class="col-sm-10">
                            <input type="text" placeholder="{{translate('Sub Title')}}" id="sliders_sub_title" name="sliders_sub_title" class="form-control" value="{{ \App\BusinessSetting::where('type', 'sliders_sub_title')->first()->value }}">
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="sliders_network_hash">{{translate('Networks Hash')}} </label>
                        <div class="col-sm-10">
                            <input type="text" placeholder="{{translate('Networks Hash')}}" id="sliders_network_hash" name="sliders_network_hash" class="form-control" value="{{ \App\BusinessSetting::where('type', 'sliders_network_hash')->first()->value }}">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="sliders_teaser_video">{{translate('Teaser Video')}} </label>
                        <div class="col-sm-10">
                            <input type="text" placeholder="{{translate('Teaser Video')}}" id="sliders_teaser_video" name="sliders_teaser_video" class="form-control" value="{{ \App\BusinessSetting::where('type', 'sliders_teaser_video')->first()->value }}">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="sliders_hotel_book_link">{{translate('Hotel Book Link')}} </label>
                        <div class="col-sm-10">
                            <input type="text" placeholder="{{translate('Hotel Book Link')}}" id="sliders_hotel_book_link" name="sliders_hotel_book_link" class="form-control" value="{{ \App\BusinessSetting::where('type', 'sliders_hotel_book_link')->first()->value }}">
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-lg-12 text-right">
                            <button class="btn btn-success" type="submit">{{translate('Save')}}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-sm-12">
        <a href="{{ route('sliders.create')}}" class="btn btn-rounded btn-info pull-right">{{translate('Add New Slider')}}</a>
    </div>
</div>

<br>

<!-- Basic Data Tables -->
<!--===================================================-->
<div class="panel pad-btm-34">
    <div class="panel-heading bord-btm clearfix pad-all h-100">
        <h3 class="panel-title pull-left pad-no">{{translate('Sliders')}}</h3>
    </div>
    <div class="panel-body">
        <table id="dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
            <thead>
                <tr>
                    <th>#</th>
                    <th>{{translate('Photo')}}</th>
                    <th>{{translate('Published')}}</th>
                    <th width="20%">{{translate('Options')}}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($sliders as $key => $slider)
                    <tr>
                        <td>{{ $slider->orders }}</td>
                        <td>
                            <div class="media-left">
                                <img loading="lazy"  class="img-md" src="{{ my_asset($slider->photo)}}" alt="Image">
                            </div>
                        </td>
                        <td>
                            <label class="switch">
                            <input onchange="update_published(this)" value="{{ $slider->id }}" type="checkbox" <?php if($slider->published == 1) echo "checked";?> >
                            <span class="slider round"></span></label>
                        </td>
                        <td class="text-center">
                            <a class="btn btn-success" href="{{route('sliders.edit', encrypt($slider->id))}}">{{ translate('Edit') }}</a>
                            <a class="btn btn-danger" onclick="confirm_modal('{{route('sliders.destroy', $slider->id)}}');">{{ translate('Delete') }}</a>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection

@section('script')
    <script type="text/javascript">
        $(document).ready(function() {
            if ( $.fn.dataTable.isDataTable( '#dt-selection' ) ) {
                $('#dt-selection').DataTable( {
                    destroy: true,
                    "responsive": true,
                    "language": {
                        "paginate": {
                        "previous": '<i class="demo-psi-arrow-left"></i>',
                        "next": '<i class="demo-psi-arrow-right"></i>'
                        }
                    },
                    columnDefs: [
                        { orderable: false, targets: 3 }
                    ],
                    // order: [[2, 'desc']],
                } );
            }
        } );

        function update_published(el){
            if(el.checked){
                var published = 1;
            } else {
                var published = 0;
            }
            $.post('{{ route('sliders.published') }}', {_token:'{{ csrf_token() }}', id:el.value, published:published}, function(data){
                if(data == 1){
                    showAlert('success', 'Published sliders updated successfully');
                }
                else{
                    showAlert('danger', 'Something went wrong');
                }
            });
        }
    </script>
@endsection

@section('css')
    <style>
        .dataTables_wrapper .dataTables_paginate .paginate_button {
            padding: 0 0;
        }
    </style>
@endsection