@extends('layouts.app')

@section('content')

<div class="row">
    <div class="col-sm-12">
        <a href="{{ route('sponsors.create')}}" class="btn btn-rounded btn-info pull-right">{{translate('Add New Sponsor')}}</a>
    </div>
</div>

<br>

<!-- Basic Data Tables -->
<!--===================================================-->
<div class="panel">
    <div class="panel-heading bord-btm clearfix pad-all h-100">
        <h3 class="panel-title pull-left pad-no">{{translate('Sponsors Per Sponsorship')}}</h3>
    </div>
    <div class="panel-body">
        <table id="dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
            <thead>
                <tr>
                    <th>{{ translate('Logo') }}</th>
                    <th>{{ translate('Website Link') }}</th>
                    <th>{{ translate('Sponsorships') }}</th>
                    <th>{{ translate('Created At') }}</th>
                    <th width="16%">{{ translate('Options') }}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($sponsors as $key => $sponsor)
                    <tr>
                        <td><img width="100" src="{{ my_asset($sponsor->logo) }}" alt="icons"></td>
                        <td>{{ $sponsor->website_link }}</td>
                        <td>{{ $sponsor->sponsorship->name }}</td>
                        <td>{{ date('F d, Y h:i:s A', strtotime($sponsor->created_at)) }}</td>
                        <td>
                            <a class="btn btn-success" href="{{route('sponsors.edit', encrypt($sponsor->id))}}">{{ translate('Edit') }}</a>
                            <a class="btn btn-danger" onclick="confirm_modal('{{route('sponsors.destroy', $sponsor->id)}}');">{{ translate('Delete') }}</a>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

@endsection
@section('script')

<script type="text/javascript">
    $(document).ready(function() {
        if ( $.fn.dataTable.isDataTable( '#dt-selection' ) ) {
            $('#dt-selection').DataTable( {
                destroy: true,
                "responsive": true,
                "language": {
                    "paginate": {
                    "previous": '<i class="demo-psi-arrow-left"></i>',
                    "next": '<i class="demo-psi-arrow-right"></i>'
                    }
                },
                columnDefs: [
                    { orderable: false, targets: 0 },
                    { orderable: false, targets: 3 }
                ],
                order: [[2, 'desc']],
            } );
        }
    } );

</script>

@endsection

@section('css')

<style>
    .dataTables_wrapper .dataTables_paginate .paginate_button {
        padding: 0 0;
    }
</style>

@endsection