@extends('layouts.app')

@section('content')

<div class="col-lg-12 pad-btm-34">
    <div class="panel">
        <div class="panel-heading">
            <h3 class="panel-title">{{translate('Sponsorship Information')}}</h3>
        </div>

        <!--Horizontal Form-->
        <!--===================================================-->
        <form class="form-horizontal" action="{{ route('sponsorships.store') }}" method="POST" enctype="multipart/form-data">
        	@csrf
            <div class="panel-body">

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="name">{{translate('Name')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                    <input type="name" placeholder="{{translate('Name')}}" id="name" name="name" class="form-control" required>
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="price">{{translate('Price')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                        <input type="number" placeholder="{{translate('Price')}}" id="price" name="price" class="form-control" required>
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="slots">{{translate('Slots')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                        <input type="number" placeholder="{{translate('Slots')}}" id="slots" name="slots" class="form-control" required>
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="total_free_conference_pass">{{translate('Total free pass to the conference')}}</label>
                    <div class="col-sm-10">
                        <input type="number" placeholder="{{translate('Free Pass')}}" id="total_free_conference_pass" name="total_free_conference_pass" class="form-control">
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="inclusions">{{translate('Inclusions')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                        <textarea class="form-control editor" name="inclusions" required></textarea>
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="type">{{translate('Type')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                        <select name="type" id="type" class="form-control demo-select2-placeholder" required>
                            <option value="2">Regular</option>
                            <option value="1">Premium</option>
                        </select>
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="order_number">{{translate('Order Number')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                        <input type="number" placeholder="{{ $sponsor->order_number + 1 }}" id="order_number" name="order_number" class="form-control" required>
                    </div>
                </div>
                
            </div>
            <div class="panel-footer text-right">
                <button class="btn btn-success" type="submit">{{translate('Save')}}</button>
                <a href="{{ route('sponsorships.index') }}" name="buttonBack" class="btn btn-danger">{{ translate('Back') }}</a>
            </div>
        </form>
        <!--===================================================-->
        <!--End Horizontal Form-->

    </div>
</div>

@endsection
