@extends('layouts.app')

@section('content')
    <div class="row">
        <div class="col-lg-12">
            <div class="panel">
                <div class="panel-heading">
                    <h3 class="panel-title text-center">{{translate('Statistics Section')}}</h3>
                </div>
                <div class="panel-body">
                    <form class="form-horizontal" action="{{ route('statistics.update') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        <div class="form-group">
                            <div class="col-sm-12">
                                <h3 class="panel-title text-center">{{translate('First Statistics')}}</h3>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="statistics_icon">{{translate('Icon')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Icon')}}" id="statistics_icon" name="statistics_icon" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'statistics_icon')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="statistics_title">{{translate('Title')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Title')}}" id="statistics_title" name="statistics_title" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'statistics_title')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="statistics_data">{{translate('Counter')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Counter')}}" id="statistics_data" name="statistics_data" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'statistics_data')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="statistics_with_plus_icon">{{translate('With Plus Icon')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <label class="switch">
                                    <input value="1" name="statistics_with_plus_icon" type="checkbox" @if (\App\BusinessSetting::where('type', 'statistics_with_plus_icon')->first()->value == 1)
                                        checked
                                    @endif>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-sm-12">
                                <h3 class="panel-title text-center">{{translate('Second Statistics')}}</h3>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="statistics_icon_1">{{translate('Icon')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Icon')}}" id="statistics_icon_1" name="statistics_icon_1" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'statistics_icon_1')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="statistics_title_1">{{translate('Title')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Title')}}" id="statistics_title_1" name="statistics_title_1" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'statistics_title_1')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="statistics_data_1">{{translate('Counter')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Counter')}}" id="statistics_data_1" name="statistics_data_1" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'statistics_data_1')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="statistics_with_plus_icon_1">{{translate('With Plus Icon')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <label class="switch">
                                    <input value="1" name="statistics_with_plus_icon_1" type="checkbox" @if (\App\BusinessSetting::where('type', 'statistics_with_plus_icon_1')->first()->value == 1)
                                        checked
                                    @endif>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-sm-12">
                                <h3 class="panel-title text-center">{{translate('Third Statistics')}}</h3>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="statistics_icon_2">{{translate('Icon')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Icon')}}" id="statistics_icon_2" name="statistics_icon_2" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'statistics_icon_2')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="statistics_title_2">{{translate('Title')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Title')}}" id="statistics_title_2" name="statistics_title_2" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'statistics_title_2')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="statistics_data_2">{{translate('Counter')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Counter')}}" id="statistics_data_2" name="statistics_data_2" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'statistics_data_2')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="statistics_with_plus_icon_2">{{translate('With Plus Icon')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <label class="switch">
                                    <input value="1" name="statistics_with_plus_icon_2" type="checkbox" @if (\App\BusinessSetting::where('type', 'statistics_with_plus_icon_2')->first()->value == 1)
                                        checked
                                    @endif>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-sm-12">
                                <h3 class="panel-title text-center">{{translate('Fourth Statistics')}}</h3>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="statistics_icon_3">{{translate('Icon')}} </label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Icon')}}" id="statistics_icon_3" name="statistics_icon_3" class="form-control" value="{{ \App\BusinessSetting::where('type', 'statistics_icon_3')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="statistics_title_3">{{translate('Title')}} </label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Title')}}" id="statistics_title_3" name="statistics_title_3" class="form-control" value="{{ \App\BusinessSetting::where('type', 'statistics_title_3')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="statistics_data_3">{{translate('Counter')}} </label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Counter')}}" id="statistics_data_3" name="statistics_data_3" class="form-control" value="{{ \App\BusinessSetting::where('type', 'statistics_data_3')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="statistics_with_plus_icon_3">{{translate('With Plus Icon')}} </label>
                            <div class="col-sm-10">
                                <label class="switch">
                                    <input value="1" name="statistics_with_plus_icon_3" type="checkbox" @if (\App\BusinessSetting::where('type', 'statistics_with_plus_icon_3')->first()->value == 1)
                                        checked
                                    @endif>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-sm-12">
                                <h3 class="panel-title text-center">{{translate('Background Color and Text Color Statistics')}}</h3>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="statistics_bg_color">{{translate('Background Color')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Background Color')}}" id="statistics_bg_color" name="statistics_bg_color" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'statistics_bg_color')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="statistics_color">{{translate('Text Color')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Text Color')}}" id="statistics_color" name="statistics_color" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'statistics_color')->first()->value }}">
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <div class="col-lg-12 text-right">
                                <button class="btn btn-success" type="submit">{{translate('Save')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
