@extends('layouts.app')

@section('content')
    <div class="row">
        <div class="col-lg-12">
            <div class="panel">
                <div class="panel-heading">
                    <h3 class="panel-title text-center">{{translate('Google reCAPTCHA Setting')}}</h3>
                </div>
                <div class="panel-body">
                    <form class="form-horizontal" action="{{ route('google_recaptcha.update') }}" method="POST">
                        @csrf
                        <div class="form-group">
                            <input type="hidden" name="types[]" value="CAPTCHA_KEY">
                            <div class="col-lg-2">
                                <label class="control-label">{{translate('Site KEY')}} <span class="red">*</span></label>
                            </div>
                            <div class="col-lg-10">
                                <input type="text" class="form-control" name="CAPTCHA_KEY" value="{{ config('services.recaptcha.sitekey') }}" placeholder="{{ translate('Site KEY') }}" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-lg-12 text-right">
                                <button class="btn btn-purple" type="submit">{{translate('Save')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
