@extends('layouts.app')

@section('content')

<h3 class="text-center">{{translate('Cache Management')}}</h3>
<div class="row">
    <div class="col-lg-3">
        <div class="panel">
            <div class="panel-heading">
                <h3 class="panel-title text-center">{{translate('Clear Cache')}}</h3>
            </div>
            <div class="panel-body text-center">
                <button class="btn btn-purple" type="button" onclick="updateSettings('cache:clear')">Clear</button>
            </div>
        </div>
    </div>
    <div class="col-lg-3">
        <div class="panel">
            <div class="panel-heading">
                <h3 class="panel-title text-center">{{translate('Cache Route')}}</h3>
            </div>
            <div class="panel-body text-center">
                <button class="btn btn-purple" type="button" onclick="updateSettings('route:cache')">Cache</button>
            </div>
        </div>
    </div>
    <div class="col-lg-3">
        <div class="panel">
            <div class="panel-heading">
                <h3 class="panel-title text-center">{{translate('Cache Config')}}</h3>
            </div>
            <div class="panel-body text-center">
                <button class="btn btn-purple" type="button" onclick="updateSettings('config:cache')">Cache</button>
            </div>
        </div>
    </div>
    <div class="col-lg-3">
        <div class="panel">
            <div class="panel-heading">
                <h3 class="panel-title text-center">{{translate('Clear View')}}</h3>
            </div>
            <div class="panel-body text-center">
                <button class="btn btn-purple" type="button" onclick="updateSettings('view:clear')">Clear</button>
            </div>
        </div>
    </div>
</div>

@endsection

@section('script')
    <script type="text/javascript">
        function updateSettings(type){
            $.post('{{ route('cache.website') }}', {_token:'{{ csrf_token() }}', type:type}, function(data){
                if(data == '1'){
                    showAlert('success', 'Cache successfully');
                }
                else{
                    showAlert('danger', 'Something went wrong');
                }
            });
        }
    </script>
@endsection