@extends('layouts.app')

@section('content')
@if(false)
@if((config('mail.username') == null || config('mail.username') == "") && (config('mail.password') == null || config('mail.password') == ""))
    <div class="row">
        <div class="col-sm-12">
            <div class="bg-danger pad-all text-center mar-btm">
                <h4 class="text-light mar-btm">{{translate('Please Configure SMTP Setting to work all email sending funtionality')}}.</h4>
                <a class="btn btn-info btn-rounded" href="{{ route('smtp_settings.index') }}">Configure Now</a>
            </div>
        </div>
    </div>
@endif
@endif

<div class="row">
    <div class="col-lg-12">
        <div class="panel">
            <div class="panel-heading">
                <h3 class="panel-title">{{ translate('Welcome to ') }} {{ config('app.name') }}</h3>
            </div>
        </div>
    </div>
</div>

@if(false)
<div class="bg-dark-blue mb-3 pad-all text-center">
    <form class="" action="{{ route('admin.dashboard') }}" method="GET">
        <div class="box-inline mar-btm pad-rgt">
            <div class="col-md-5">
                <div class="row">
                    <div class="col-md-2">
                        <label class="control-label">From date</label>
                    </div>
                    <div class="col-md-10">
                        <div class="input-group date">
                            <div class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </div>
                            <div id="demo-dp-range">
                                <div class="input-daterange" id="datepicker">
                                    <input type="text" class="form-control date" readonly id="from_date" value="{{ date('m/d/Y', strtotime($from_date)) }}" name="from_date">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-5">
                <div class="row">
                    <div class="col-md-2">
                        <label class="control-label">To date</label>
                    </div>
                    <div class="col-md-10">
                        <div class="input-group date">
                            <div class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </div>
                            <div id="demo-dp-range">
                                <div class="input-daterange" id="datepicker">
                                    <input type="text" class="form-control date" readonly id="to_date" value="{{ date('m/d/Y', strtotime($to_date)) }}" name="to_date">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <button class="btn btn-default" type="submit">Filter</button>

        </div>
    </form>
</div>
<div class="row">
    @if(Auth::user()->user_type == 'admin' || in_array('1', json_decode(Auth::user()->staff->role->permissions)))
    <div class="col-lg-3 col-md-6 col-xs-12">
        <div class="small-box" style="background: #96D38D; color: #fff !important;">
            <div class="inner">
                <h3>{{ $orders_pending_count }}</h3>
                <p>Orders Pending</p>
            </div>
            <div class="icon">
                <i class="ion-android-cart"></i>
            </div>
            <a href="{{ route('orders.index.pending') }}" class="small-box-footer">View All Pending Orders <i class="fa fa-arrow-circle-right"></i></a>
        </div>
    </div>
    <div class="col-lg-3 col-md-6 col-xs-12">
        <div class="small-box" style="background: #fb8072; color: #fff !important;">
            <div class="inner">
                <h3>{{ $orders_on_review_count }}</h3>
                <p>Orders On Review</p>
            </div>
            <div class="icon">
                <i class="ion-compose"></i>
            </div>
            <a href="{{ route('orders.index.onreview') }}" class="small-box-footer">View All On Review Orders <i class="fa fa-arrow-circle-right"></i></a>
        </div>
    </div>
    <div class="col-lg-3 col-md-6 col-xs-12">
        <div class="small-box" style="background-color: #7fb0e2 !important; color: #fff !important;">
            <div class="inner">
                <h3>{{ $orders_on_delivery_count }}</h3>
                <p>Orders On Delivery</p>
            </div>
            <div class="icon">
                <i class="fa fa-truck"></i>
            </div>
            <a href="{{ route('orders.index.ondelivery') }}" class="small-box-footer">View All On Delivery Orders <i class="fa fa-arrow-circle-right"></i></a>
        </div>
    </div>
    <div class="col-lg-3 col-md-6 col-xs-12">
        <div class="small-box bg-green">
            <div class="inner">
                <h3>{{ $orders_delivered_count }}</h3>
                <p>Orders Delivered</p>
            </div>
            <div class="icon">
                <i class="ion-ios-checkmark-outline"></i>
            </div>
            <a href="{{ route('orders.index.deivered') }}" class="small-box-footer">View All Delivered Orders <i class="fa fa-arrow-circle-right"></i></a>
        </div>
    </div>
    @endif
    <div class="col-lg-4 col-md-6 col-xs-12">
        <div class="info-box">
            <span class="info-box-icon bg-green"><i class="fa fa-users"></i></span>
            <div class="info-box-content">
                <span class="text-bold text-uppercase">Total Customer</span>
                <span class="info-box-number">{{ $total_customer }}</span>
            </div>
            <!-- /.info-box-content -->
        </div>
    </div>
    <div class="col-lg-4 col-md-6 col-xs-12">
        <div class="info-box">
            <span class="info-box-icon bg-red"><i class="fa fa-cubes"></i></span>
            <div class="info-box-content">
                <span class="text-bold text-uppercase">Total Products</span>
                <span class="info-box-number">{{ $total_product }}</span>
            </div>
            <!-- /.info-box-content -->
        </div>
    </div>
    <div class="col-lg-4 col-md-6 col-xs-12">
        <div class="info-box">
            <span class="info-box-icon bg-dark-blue"><i class="fa fa-shopping-cart"></i></span>
            <div class="info-box-content">
                <span class="text-bold text-uppercase">Total Orders</span>
                <span class="info-box-number">{{ $total_order }}</span>
            </div>
            <!-- /.info-box-content -->
        </div>
    </div>
    <div class="col-lg-4 col-md-6 col-xs-12">
        <div class="info-box">
            <span class="info-box-icon bg-green"><i class="fa fa-money"></i></span>
            <div class="info-box-content">
                <span class="text-bold text-uppercase">Gross Sale</span>
                <span class="info-box-number">{{ single_price($gross_sale,2) }}</span>
            </div>
            <!-- /.info-box-content -->
        </div>
    </div>
    <div class="col-lg-4 col-md-6 col-xs-12">
        <div class="info-box">
            <span class="info-box-icon bg-red"><i class="fa fa-minus-circle"></i></span>
            <div class="info-box-content">
                <span class="text-bold text-uppercase">Total Expenses</span>
                <span class="info-box-number">{{ single_price($expenses,2) }}</span>
            </div>
            <!-- /.info-box-content -->
        </div>
    </div>
    <div class="col-lg-4 col-md-6 col-xs-12">
        <div class="info-box">
            <span class="info-box-icon bg-dark-blue"><i class="fa fa-dollar"></i></span>
            <div class="info-box-content">
                <span class="text-bold text-uppercase">Net Income</span>
                <span class="info-box-number">{{ single_price($net_income,2) }}</span>
            </div>
            <!-- /.info-box-content -->
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title">{{__('Top 5 Selling Products')}}</h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body text-center">
                <div class="table-responsive">
                    <table class="table table-striped mar-no">
                        <tbody>
                            @if(\App\Product::select('id')->where('add_on',0)->where('num_of_sale','!=',0)->count() > 0)
                                @foreach (\App\Product::orderBy('num_of_sale', 'DESC')->select('id','name', 'num_of_sale', 'thumbnail_img')->where('add_on',0)->where('num_of_sale','!=',0)->limit(5)->get() as $key => $product)
                                    <tr>
                                        <td>
                                            <div>
                                                <img src="{{ my_asset($product->thumbnail_img) }}" alt="product image" width="50" height="50">
                                            </div>
                                        </td>
                                        <td><a style="color: blue; font-weight: 600; float: left;" href="{{route('products.seller.edit', encrypt($product->id))}}">{{ __($product->name) }}</a></td>
                                        <td><span class="label bg-yellow pull-right">{{ $product->num_of_sale }} sold</span></td>
                                    </tr>
                                @endforeach
                            @else
                                <tr><td>No Data Found.</td></tr>
                            @endif
                        </tbody>
                    </table>
                </div>
                <a href="{{ route('products.admin') }}" class="btn btn-primary mar-top btn-block top-border-radius-no">{{__('View All Products')}}</a>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title">{{__('5 Recently Added Products')}}</h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body text-center">
                <div class="table-responsive">
                    <table class="table table-striped mar-no">
                        <tbody>
                            @if(\App\Product::select('id')->count() > 0)
                                @foreach (\App\Product::orderBy('created_at', 'DESC')->select('id','name', 'unit_price', 'thumbnail_img')->where('add_on',0)->limit(5)->get() as $key => $product)
                                    <tr>
                                        <td>
                                            <div>
                                                <img src="{{ my_asset($product->thumbnail_img) }}" alt="product image" width="50" height="50">
                                            </div>
                                        </td>
                                        <td><a style="color: blue; font-weight: 600; float: left;" href="{{route('products.seller.edit', encrypt($product->id))}}">{{ __($product->name) }}</a></td>
                                        <td><span class="label bg-yellow pull-right">{{ single_price($product->unit_price,2) }}</span></td>
                                    </tr>
                                @endforeach
                            @else
                                <tr><td>No Data Found.</td></tr>
                            @endif
                        </tbody>
                    </table>
                </div>
                <a href="{{ route('products.admin') }}" class="btn btn-primary mar-top btn-block top-border-radius-no">{{__('View All Products')}}</a>
            </div>
        </div>
    </div>
</div>
@endif
@endsection


@section('script')
<script type="text/javascript">
    $(document).ready(function(){
       $('#demo-dp-range .input-daterange').datepicker({
            startDate: '-0d',
            todayBtn: "linked",
            autoclose: true,
            todayHighlight: true,
            format: 'mm/dd/yyyy'
        });
    });
</script>
@endsection