<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        @php
            $seosetting = \App\SeoSetting::first();
            $siteMotto = \App\BusinessSetting::where('type','site_motto')->first();
            $generalsetting = \App\GeneralSetting::first();
        @endphp

        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>@yield('meta_title', config('app.name', 'Laravel'))</title>

        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta name="robots" content="index, follow">
        <meta name="description" content="@yield('meta_description', $seosetting->description)" />
        <meta name="keywords" content="@yield('meta_keywords', $seosetting->keyword)">
        <meta name="author" content="{{ $seosetting->author }}">
        <meta name="sitemap_link" content="{{ $seosetting->sitemap_link }}">

        @yield('meta')

        <!-- Schema.org markup for Google+ -->
        <meta itemprop="name" content="{{ config('app.name', 'Laravel') }}">
        <meta itemprop="description" content="{{ $seosetting->description }}">
        <meta itemprop="image" content="{{ my_asset($generalsetting->favicon) }}">

        <!-- Twitter Card data -->
        <meta name="twitter:card" content="product">
        <meta name="twitter:site" content="@publisher_handle">
        <meta name="twitter:title" content="{{ config('app.name', 'Laravel') }}">
        <meta name="twitter:description" content="{{ $seosetting->description }}">
        <meta name="twitter:creator" content="@author_handle">
        <meta name="twitter:image" content="{{ my_asset($generalsetting->favicon) }}">

        <!-- Open Graph data -->
        <meta property="og:title" content="{{ config('app.name', 'Laravel') }}" />
        <meta property="og:type" content="website" />
        <meta property="og:url" content="{{ route('home') }}" />
        <meta property="og:image" content="{{ my_asset($generalsetting->favicon) }}" />
        <meta property="og:description" content="{{ $seosetting->description }}" />
        <meta property="og:site_name" content="{{ config('app.name') }}" />

        <!-- Favicon -->
        <link type="image/x-icon" href="{{ my_asset($generalsetting->favicon) }}" rel="shortcut icon" />
        <link rel="canonical" href="{{config('app.url')}}" />

        <link href="{{ my_asset('event-website-assets/css/app.css?v=1') }}" rel="stylesheet" type="text/css">
        <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.5.0/css/all.css" integrity="sha384-B4dIYHKNBt8Bc12p+WXckhzcICo0wtJAoU8YZTY5qE0Id1GSseTk6S+L3BlXeVIU" crossorigin="anonymous">
        <link rel="stylesheet" type="text/css" href="{{ my_asset('event-website-assets/css/daterangepicker.css') }}">

        <script type="text/javascript" src="https://cdn.jsdelivr.net/jquery/latest/jquery.min.js"></script>

        <link href="{{ my_asset('event-website-assets/css/easy-autocomplete.min.css') }}" rel="stylesheet" type="text/css">
        <link href="{{ my_asset('event-website-assets/css/easy-autocomplete.themes.min.css') }}" rel="stylesheet" type="text/css">
        <link href="{{ my_asset('event-website-assets/css/TimeCircles.css') }}" rel="stylesheet" type="text/css">

        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.css">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick-theme.min.css">

        <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
        <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/moment-timezone/0.5.23/moment-timezone-with-data-2012-2022.js"></script>

        <script src="{{ my_asset('event-website-assets/js/TimeCircles.js') }}" defer></script>
        <script src="{{ my_asset('event-website-assets/js/app.js') }}" defer></script>
        

        <script src="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.js"></script>
        
    </head>
    <body id="page-top">

        <!-- Page Wrapper Starts -->
        <div class="wrapper">
            @yield('content')

            @include('frontend.inc.footer')
            
            @if (\App\Models\BusinessSetting::where('type', 'facebook_chat')->first()->value == 1)
                <!-- Messenger Chat plugin Code -->
                    <div id="fb-root"></div>

                <!-- Your Chat plugin code -->
                <div id="fb-customer-chat" class="fb-customerchat"
                    logged_in_greeting="Hi! How can we help you?" 
                    logged_out_greeting="Hi! How can we help you?"
                    attribution=setup_tool>
                </div>

                <script>
                var chatbox = document.getElementById('fb-customer-chat');
                chatbox.setAttribute("page_id", "{{ config('services.FACEBOOK_PAGE_ID') }}");
                chatbox.setAttribute("attribution", "biz_inbox");
                </script>

                <!-- Your SDK code -->
                <script>
                window.fbAsyncInit = function() {
                    FB.init({
                    xfbml            : true,
                    version          : 'v17.0'
                    });
                };

                (function(d, s, id) {
                    var js, fjs = d.getElementsByTagName(s)[0];
                    if (d.getElementById(id)) return;
                    js = d.createElement(s); js.id = id;
                    js.src = 'https://connect.facebook.net/en_US/sdk/xfbml.customerchat.js';
                    fjs.parentNode.insertBefore(js, fjs);
                }(document, 'script', 'facebook-jssdk'));
                </script>
            @endif
        </div>
        <!-- Wrapper Ends -->

        <script src='https://www.google.com/recaptcha/api.js'></script>
        <script src="{{ my_asset('event-website-assets/js/jquery.easy-autocomplete.min.js') }}" defer></script>
        <script src="https://cdn.jsdelivr.net/jquery.validation/1.16.0/jquery.validate.min.js"></script>

        @yield('script')

        @yield('css')

        <style>
            {!! \App\BusinessSetting::where('type', 'custom_css')->first()->value !!}
        </style>

    </body>
</html>
