@extends('frontend.layouts.app')

@section('content')

@php
    //check fee if earlybird
    $dateToday = date('F d, Y, h:i:s a');
    $price_ends = date('F d, Y', strtotime($conference_cost->early_bird_rate_date))." 12:00:00 pm"; //June 22, 2023
    $checker_for_early_bird = ( strtotime($dateToday) < strtotime($price_ends) ) ? 1 : 0 ;

    $regs_fee_eb = ($checker_for_early_bird == 1 ? $conference_cost->early_bird_rate_price : $conference_cost->regular_rate_price);

    //check vip fee if earlybird
    $dateToday = date('F d, Y, h:i:s a');
    $vip_price_ends = date('F d, Y', strtotime($vip_cost->early_bird_rate_date))." 12:00:00 pm"; //June 22, 2023
    $checker_for_vip_early_bird = ( strtotime($dateToday) < strtotime($vip_price_ends) ) ? 1 : 0 ;

    $regs_fee_vip = ($checker_for_vip_early_bird == 1 ? $vip_cost->early_bird_rate_price : $vip_cost->regular_rate_price);
    
    $end_of_reg = \App\BusinessSetting::where('type', 'end_of_registration')->first()->value;
@endphp
<section class="container gb nopadtop overflow-hidden">
    <div class="row">
        <div class="col-md-12 section-title text-center">
            @if ($message = Session::get('error'))
            <div class="alert alert-danger alert-block">
                <button type="button" class="close" data-dismiss="alert">×</button>
                <strong>{{ $message }}</strong>
            </div>
            @endif

            @if ($errors->any())
            <div class="alert alert-danger">
                <button type="button" class="close" data-dismiss="alert">×</button>
                Please check the form below for errors
            </div>
            @endif
        </div><!-- end title -->
    </div>
    <form id="registrationForm" action="{{ route('registration.submit') }}" method="post">
        <input type="hidden" name="_token" value="{{csrf_token()}}"><br>
        <div class="row">
     
            <div class="col-md-10 pt-5 m-auto boxed">
            <img src="../images/IndiaBanner5.png" width="auto" height="140" alt="banner" class="responsive">
            <center><h1 class="py-3 regs-title">India International Cargo Show Registration</h1></center>
                <div class="responsive">
              <div><br>
                
                <h4>* Personal Information</h4>
                </div>
                </div>
                <div id="dynamic_field">
                <div class="row">
                        <div class="form-group col-md-3">
                            <label for="inputState">Title</label>
                            <select id="inputState" "class="form-control1" style="width: 180px; height:48px;" name="salutation[]" @if($end_of_reg == 1) disabled @endif>
                                <option value="Mr." selected>Mr.</option>
                                <option value="Mrs.">Mrs.</option>
                                <option value="Ms.">Ms.</option>
                            </select>
                        </div>
                        <div class="form-group col-md-3">
                            <label for="inputFirstname">Firstname <small class="required">required *</small></label>
                            <input type="text" class="form-control1" id="inputFirstname" name="firstname[]" placeholder="Firstname" required @if($end_of_reg == 1) disabled @endif/>
                        </div>
                        <div class="form-group col-md-3">
                            <label for="inputLastname">Lastname <small class="required">*</small></label>
                            <input type="text" class="form-control1" id="inputLastname" name="lastname[]" placeholder="Lastname" required @if($end_of_reg == 1) disabled @endif/>
                        </div>
                        <div class="form-group col-md-3">
                            <label for="inputShirt"><p hidden>Shirt size</p></label>
                            <select id="inputShirt" class="col" style="width: 200px; height:48px;" name="shirt_size[]" required @if($end_of_reg == 1) disabled @endif>
                                <option selected><p hidden>Choose...</option>
                                <option value="XS">XS</option>
                                <option value="S">S</option>
                                <option value="M">M</option>
                                <option value="L">L</option>
                                <option value="XL">XL</option>
                                <option value="XXL">2XL</option>
                                <option value="XXXL">3XL</option>
                                <option value="XXXL">4XL</option>
                            </select></p>
                        
                        

                        </div>
                    </div>
                </div>
                <div class="responsive">
                    <div><br>
            
                    <h4>* Company Information</h4>
                    
                </div>     
                </div>
                <div class="row">
                    <div class="form-group col-md-3">
                        <label>Company <small class="required">*</small></label>
                        <input type="text" class="form-control1 step1Required" placeholder="Enter Company Name" name="company" required @if($end_of_reg == 1) disabled @endif/>
                    </div>
                    <div class="form-group col-md-3">
                        <label>Position</label>
                        <input type="text" class="form-control1 step1Required" id="designation" placeholder="Position" name="designation[]" @if($end_of_reg == 1) disabled @endif/>
                    </div>
                    <div class="form-group col-md-3">
                        <label>Email <small class="required"> *</small></label>
                        <input type="text" class="form-control1 step1Required" id="iptEmail" placeholder="Enter Email" name="email[]" required @if($end_of_reg == 1) disabled @endif/>
                    </div>
                    <div class="form-group col-md-3">
                        <label>Telephone <small class="required">*</small></label>
                        <input type="text" class="form-control1 step1Required" placeholder="Enter Telephone" name="telephone" required @if($end_of_reg == 1) disabled @endif/>
                    </div>
                    <div class="form-group col-md-3">
                        <label>Mobile <small class="required">*</small></label>
                        <input type="text" class="form-control1 step1Required" placeholder="Enter Mobile" name="mobile[]" required @if($end_of_reg == 1) disabled @endif/>
                    </div>
                    <div class="form-group col-md-3">
                        <label>Website <small class="required">*</small></label>
                        <input type="text" class="form-control1 step1Required" placeholder="Enter website" name="website" required @if($end_of_reg == 1) disabled @endif/>
                    </div>
                   <div class="form-group col-md-3">
                        <label>IATA Number </label>
                        <input type="text" class="form-control1" placeholder="Enter IATA Number" name="iata" @if($end_of_reg == 1) disabled @endif/>
                    </div> 
                    <div class="form-group col-md-3 ">
                        <label>Address <small class="required">*</small></label>
                        <input type="text" class="form-control1 step1Required" placeholder="Enter Address" name="address" required @if($end_of_reg == 1) disabled @endif/>
                    </div>
                    <div class="form-group col-md-3">
                        <label>City <small class="required">*</small></label>
                        <input type="text" class="form-control1 step1Required" placeholder="Enter City" name="city" required @if($end_of_reg == 1) disabled @endif/>
                    </div>
                    <div class="form-group col-md-3">
                        <label>Country <small class="required">required *</small></label>
                        <input class="form-control1 empty" id="country" style="width: 180px; height:48px;"  name="country" placeholder="Country" required @if($end_of_reg == 1) disabled @endif/>
                    </div>


                    <br>
                    
                    <div class="row"><br></br>
                    &nbsp; &nbsp;   &nbsp; &nbsp;<h3>* RW Networks</h3>
                    
                    <div class="col-9 col-md-11">
                        @foreach($softwares as $software)
                            <div class="form-check mr-4">
                              &nbsp; &nbsp;   &nbsp; &nbsp;  <input class="form-check-input" style="height:35px;" type="checkbox" id="software{{ $software->id }}" @if($end_of_reg == 1) enabled @endif
                                    value="{{ $software->id }}" name="softwares[]">
                                 &nbsp; &nbsp; <label class="form-check-label"
                                   for="software{{ $software->id }}">{{ $software->name }}</label>
                            </div>
                        @endforeach <br>
                    </div>
                </div><br>
                    <div class="row"><br>
                   &nbsp; &nbsp;&nbsp; &nbsp;   <h4>* Tickets</h4>
                
                    
                    <div class="col-12 col-md-12">
                        
               
                       <p><strong> &nbsp; &nbsp;&nbsp; &nbsp;Please select your spot:</strong></p><div>
                    <div class="col-8 col-md-24">
                      
                            @foreach($sponsorships as $sponsorship)
                                @if($sponsorship->type == 2)
                                    <div class="form-check">
                                        @if($sponsorship->is_sold_out == 0)
                                            <div class="sponsorship-package">
                                                <input class="form-check-input chkSponsorship" type="checkbox" id="sponsor{{ $sponsorship->id }}" @if($end_of_reg == 1) disabled @endif
                                                    value="{{ $sponsorship->id }}" name="sponsorship[]" data-name="{{ $sponsorship->name }}"
                                                    data-price="{{ $sponsorship->price }}" data-free="{{ $sponsorship->total_free_conference_pass }}">
                                                <!-- <strong> -->
                                                    <label class="form-check-label"
                                                        for="sponsor{{ $sponsorship->id }}"> <strong>{{ $sponsorship->name }} </strong> 
                                                        <span>
                                                            (USD {{ $sponsorship->price }})
                                                                 
                                                            @if($sponsorship->slots != 0)
                                                                -
                                                                @if($sponsorship->slots == 1)
                                                                    LIMITED TO
                                                                @else
                                                                    MAXIMUM OF
                                                                @endif
                                                                {{ $sponsorship->slots }}
                                                            
                                                            @endif
                                                           
                                                        </span>
                                                         <details class="accordion-item">
        <summary class="accordion-trigger">
          <span class="accordion-title">
          CLICK HERE TO SEE THE INCLUSIONS
          </span>
          <span class="accordion-icon" aria-hidden="true">
            &check;
          </span>

        </summary>
        <div class="sponsorship-package">
          <p> {!! $sponsorship->inclusions !!} </p>
        </div>
                                                       <!-- {!! $sponsorship->inclusions !!} -->
                                                    </label>
                                                <!-- </strong> -->
                                                
                                            </div>
                                        @else
                                            <s>
                                                <input enabled class="form-check-input chkSponsorship" type="checkbox" id="sponsor{{ $sponsorship->id }}" @if($end_of_reg == 1) enabled @endif
                                                    value="{{ $sponsorship->id }}" name="sponsorship[]" data-name="{{ $sponsorship->name }}"
                                                    data-price="{{ $sponsorship->price }}">
                                                    <s class="form-check-label"
                                                        for="sponsor{{ $sponsorship->id }}">{{ $sponsorship->name }}
                                                        <span>
                                                            (USD {{ $sponsorship->price }})
                                                            @if($sponsorship->slots != 0)
                                                                -
                                                                @if($sponsorship->slots == 1)
                                                                    LIMITED TO
                                                                @else
                                                                    MAXIMUM OF
                                                                @endif
                                                                {{ $sponsorship->slots }}
                                                            @endif
                                                        </span>
                                                    </s>
                                                <span class="sold" style="color: red;"> - <b> SOLD OUT </b></span>
                                              <!-- {!! $sponsorship->inclusions !!} -->
                                            </s>
                                        @endif
                                    </div>
                                @endif
                            @endforeach
                        
                           
    

                        <div>
                        <div class="row justify-content-md-center">
                                                    <div class="total_div">
                        <hr style="background-color: rgba(163, 159, 159, 0.7);">
                            <div class="col-12 text-center">
                                <div class="total_div">
                                    <h3> Total: USD 
                                     <span class="total">{{ number_format($regs_fee_eb,2) }}</span>
                                    </h3>
                                </div>
                            </div>
                        </div>
                     
                                <div class="center py-4">
                                    <input type="hidden" name="conference_fee" class="conference_fee" value="{{ $regs_fee_eb }}">
                                    <input type="hidden" class="total_price" value="{{ $regs_fee_eb }}" name="total_price" />
                                    <input type="hidden" value="{{ $checker_for_early_bird }}" name="earlybird_status" />
                                    <input type="hidden" value="{{ $conference_cost->early_bird_rate_price }}" name="earlybird_fee" />
                                    <input type="hidden" value="1" id="dynamic_count" name="dynamic_count" />
                                    <input type="hidden" value="0" id="hdnReturning" name="hdnReturning" />
                                    <input type="hidden" value="0" id="hdnReturningValue"
                                        name="hdnReturningValue" />
                                    <div class="m-auto @if($end_of_reg == 1) d-none @endif">
                                      <div class="m-auto g-recaptcha" data-sitekey="{{ config('services.recaptcha.sitekey') }}"></div>
                                    </div>
                                    <button type="submit" href="#" id="btnSubmit" class="btn btn-primary mt-0 m-auto" enabled>Submit</button>&nbsp;
                                    <button type="button" value="Reset" id="btnReset" onclick="window.location = 'registration';" class="btn btn-danger mt-0 m-auto" @if($end_of_reg == 1) enabled @endif>Reset</button>
                                </div>
                            </div>
                        </div>

                    </div>

                    
                </div>
            </div>
        </div>

    </form>


                </div>
            </div>
        </div>
                </div>
            </div>
                </div>
            </div>
        </div>

        
             


                </div>
            </div>
        </div>

        
                           


@if ($message = Session::get('success'))
<div class="modal fade" id="mdlPayment" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg show" role="document">
        <div class="modal-content">
            <div class="modal-header border-0 bg-white">
                <h2 class="modal-title text-success text-center w-100" id="exampleModalLongTitle">
                    You have successfully submitted your registration!
                </h2>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body text-center modal-message">
                <div class="row align-items-center pb-5 px-4">
                    <div class="col-12 payment-header">
                        <p class="p-4">
                       <!--     Thank you for registering for {{ $generalsetting->conference_name }} in Brazil. Please also check your inbox for the confirmation email. Kindly choose which payment method you prefer: -->
                        </p>
                    </div>

                    <form action="https://www.paypal.com/cgi-bin/webscr" method="post" target="_top" id="paypalForm">
                        <input type="hidden" name="cmd" value="_cart">
                        <input type="hidden" name="upload" value="1">
                        <input type="hidden" name="business" value="6X2E4H5XKXVW6">
                        <input type="hidden" name="lc" value="HK">
                        <input type="hidden" name="item_name_1" value="{{ $generalsetting->conference_name }}">
                        <input type="hidden" name="amount_1" value="{{ session()->get( 'total_price' ) }}">
                        <input type="hidden" name="item_number" value="hanoi-{{ $generalsetting->site_year }}">
                        <input type="hidden" name="button_subtype" value="services">
                        <input type="hidden" name="no_note" value="0">
                        <input type="hidden" name="cn" value="Add special instructions to the seller:">
                        <input type="hidden" name="no_shipping" value="2">
                        <input type="hidden" name="currency_code" value="USD">
                        <input type="hidden" name="tax_rate" value="0.045">
                        <input type="hidden" name="bn" value="PP-BuyNowBF:btn_buynowCC_LG_wCUP.gif:NonHosted">
                    </form>

                    <div class="col-4 col-md text-center py-2">
                     <!--   <a href="#" class="wire">
                            <img src="{{ my_asset('event-website-assets/images/payment-logo/wire-transfer-logo.png') }}"
                                alt="" class="img-fluid">
                        </a>
                    </div>
                    <div class="col-4 col-md text-center py-2">
                        <img style="cursor: pointer;" src="{{ my_asset('event-website-assets/images/payment-logo/paypal.png') }}"
                            alt="" class="img-fluid btnPaypal">
                    </div>
                    <div class="col-4 col-md text-center py-2">
                        <img style="cursor: pointer;" src="{{ my_asset('event-website-assets/images/payment-logo/Former_Visa_(company)_logo.svg') }}"
                            alt="" class="img-fluid btnPaypal">
                    </div>
                    <div class="col-4 offset-2 offset-md-0 col-md text-center py-2">
                        <img style="cursor: pointer;" src="{{ my_asset('event-website-assets/images/payment-logo/https___blogs-images.forbes.com_steveolenski_files_2016_07_Mastercard_new_logo-1200x865.jpg') }}"
                            alt="" class="img-fluid btnPaypal">
                    </div>
                    <div class="col-4 col-md text-center py-2">
                        <img style="cursor: pointer;" src="{{ my_asset('event-website-assets/images/payment-logo/american_express_logo_wordmark_detail.png') }}"
                            alt="" class="img-fluid btnPaypal">
                    </div> -->
                    <div class="col-12 text-center okay d-none">
                        <p>Please see the Bank Details we sent to your Email</p>
                        <button class="btn btn-light border">Okay</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<script>
    try {
        window.addEventListener('DOMContentLoaded', function() {
            $('#mdlPayment').modal({
                backdrop: 'static',
                keyboard: false
            }, 'show');
            $('.wire').on('click', function() {
                $('.col-4, .payment-header').remove();
                $('.okay').addClass('d-block').removeClass('d-none');
            });
            $('.btn').on('click', function() {
                window.location.replace('registration');
            });

            $('.btnPaypal').on('click', function() {
                $('#paypalForm').submit();
            });
        });
    } catch (error) {
        window.location.href = "/";
    }
</script>
@endif

<div class="modal fade" id="mdlReturning" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-0 bg-white">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body text-left returning-modal-content">
                Please enter the voucher code we sent to your email. If you haven't received it yet, you may contact us
                at {{ config('mail.inquiry') }}.
                <div class="form-group pt-3">
                    <input type="text" class="form-control voucher-code" id="iptReturning" aria-describedby="emailHelp"
                        placeholder="Enter Voucher Code">
                </div>
            </div>
            <div class="modal-footer bg-white border-0 text-center" align="center">
                <div class="col-12 text-right">
                    <button type="button" class="btn btn-light shadow-sm border btn-sm" data-dismiss="modal">
                        <i class="fas fa-ban text-danger"></i> 
                        Cancel
                    </button>
                    <button type="button" class="btn btn-light shadow-sm border btn-sm" data-dismiss="modal" id="btnSubmitReturning">
                        <i class="fas fa-check text-primary"></i> 
                        Submit
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="errorModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-0 bg-white">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body text-center modal-message">
                Please fill all the required fields
            </div>
            <div class="modal-footer bg-white border-0 text-center" align="center">
                <div class="col-12 text-center">
                    <button type="button" class="btn btn-light shadow-sm border btn-sm" data-dismiss="modal"><i
                            class="fas fa-check text-primary"></i> Okay</button>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')

<script>

$(document).ready(function () {

    var options = {
        url: "{{ my_asset('event-website-assets/js/country-by-name.json') }}",
        getValue: "country",
        list: {
            match: {
                enabled: true
            }
        }
    };
    $("#country").easyAutocomplete(options);
    $("#toCountry").easyAutocomplete(options);
    $("#fromCountry").easyAutocomplete(options);
    
    $('#learn').on('change', function() {
        var learn = $('#learn').val();
        if(learn == 'Others') {
            $('#learnOthers').show()
        } else {
            $('#learnOthers').hide()
        }
    });
});
    
</script>



@endsection

@section('css')

<style>
    .boxed {
        border-radius: 25px !important;
    }

    .form-control {
        height: calc(1.6em + 0.75rem + 2px);
        padding: 0.375rem 0.75rem;
        font-size: 0.9rem;
        font-weight: 400;
        line-height: 1.6;
        border-radius: 20px !important;
    }

    .btn-primary.enabled, .btn-primary:enabled {
        cursor: default;
    }

    #btnSubmit:hover {
        color: #007ac1 !important;
    }

    #btnReset:hover {
        color: #c82333 !important;
    }
</style>

<style>
   .p {

  justify-content: center;
  align-items: center;
}
</style>

<script>

        $("#btnSubmit").on("click", function(evt)
        {
            var response = grecaptcha.getResponse();
            if(response.length == 0) {
                //reCaptcha not verified
                alert("please verify you are humann!");
                evt.preventDefault();
                return false;
            } else {
                //captcha verified
                //do the rest of your validations here
                $('#contact_form').validate({
                    rules: {
                        company_name: {
                            required: true,
                        },
                        name: {
                            required: true,
                        },
                        email: {
                            required: true,
                            email: true
                        },
                        phone_number:{
                            required: true,
                        },
                        mobile_number:{
                            required: true,
                        },
                        website_url:{
                            required: true,
                        },
                        message: {
                            required: true,
                        }
                    },
                    errorElement: "span",
                    messages: {
                        name: "Please enter your full name",
                        email: "Please enter valid email address",
                        message: "Please enter message",
                        phone_number: "Please enter phone number",
                        mobile_number: "Please enter mobile number",
                        website_url: "Please enter website url",
                        company_name: "Please enter company name",
                    },
                    submitHandler: function (form) {
                        var dataparam = $('#contact_form').serialize();

                        if (true) {
                            $.ajax({
                                type: 'POST',
                                url: "{{ route('contact.send') }}",
                                data : dataparam ,
                                dataType: 'json',
                                success: function (res) {

                                    if (res.res_code == 0)
                                    {
                                        $('.msg-response').html('<div class="alert alert-success alert-block"><button type="button" class="close" data-dismiss="alert">×</button><strong>'+res.res_msg+'</strong></div>');
                                        $('#contact_form')[0].reset();
                                    }
                                    else
                                    {
                                        $('.msg-response').html('<div class="alert alert-success alert-block"><button type="button" class="close" data-dismiss="alert">×</button><strong>'+res.res_msg+'</strong></div>');
                                    }

                                },
                                error: function (error) {
                                    $('.msg-response').html('<div class="alert alert-success alert-block"><button type="button" class="close" data-dismiss="alert">×</button><strong>'+error.res_msg+'</strong></div>');
                                }
                            });
                        }else{
                            $('.msg-response').html('<div class="alert alert-warning alert-block"><button type="button" class="close" data-dismiss="alert">×</button><strong>'+res.res_msg+'</strong></div>');
                        }

                    }
                });
            }
            
        });
</script>
    
     <script src="https://www.google.com/recaptcha/api.js"></script>
      <script>
   function onSubmit(token) {
     document.getElementById("demo-form").submit();
   }
 </script>
  <script>
      function onClick(e) {
        e.preventDefault();
        grecaptcha.ready(function() {
          grecaptcha.execute('reCAPTCHA_site_key', {action: 'submit'}).then(function(token) {
              // Add your logic to submit to your backend server here.
          });
        });
      }
  </script>
  <style>
* {
  box-sizing: border-box;
}

input[type=text], select, textarea {
  width: 100%;
  padding: 10px;
  border: 1px solid #ccc;
  border-radius: 4px;
  resize: vertical;
}

label {
  padding: 10px 10px 10px 0;
  display: inline-block;
}

input[type=submit] {
  background-color: #04AA6D;
  color: white;
  padding: 10px 20px;
  border: none;
  border-radius: 4px;
  cursor: pointer;
  float: right;
}

input[type=submit]:hover {
  background-color: #45a049;
}

.container-responsive {
  border-radius: 5px;
  background-color: #f2f2f2;
  padding: 20px;
}

.col-25 {
  float: left;
  width: 25%;
  margin-top: 6px;
}

.col-75 {
  float: left;
  width: 75%;
  margin-top: 6px;
}

/* Clear floats after the columns */
.row:after {
  content: "";
  display: table;
  clear: both;
}

.responsive {
  width: 100%;
  height: auto;
}

</style>

<style>
    @import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;700&display=swap');

* {
  box-sizing: border-box;
}

body {
  margin: 0;
  font-family: "Inter", sans-serif;
}

main {
  min-height: 100vh;    
}

h1 {
  text-align: center;
  margin-top: 72px;
  margin-bottom: 48px;
}

.accordion {
  margin-bottom: 24px;
}

.accordion-container {
  width: 90%;
  max-width: 1240px;
  margin: 0 auto;
  border: 3px solid #e0e0e0;
  border-radius: 24px;
  overflow: hidden;
}


.accordion-item {
  width: 100%;
}

.accordion-trigger {
  width: 100%;
  display: block;
  background-color: rgb(250, 250, 250);
  color: rgb(0, 0, 0);
  padding: 10px;
  font-size: 12px;
  font-weight: 500;
  font-family: 'Inter', sans-serif;
  text-align: left;
  border: none;
  display: flex;
  gap: 16px;
  justify-content: space-between;
  cursor: pointer;
}

.accordion-icon {
  transition: transform 0.5s;
}

.accordion-item[open] .accordion-icon {
  transform: rotate(45deg);
}

.accordion-item:not(:first-of-type) .accordion-trigger {
  border-top: 3px solid #eaeaea;
}

.accordion-content p {
  margin: 24px;
}

footer {
  bottom: 0;
  width: 100%;
  padding: 1rem;
  text-align: center;
  background-color: #ffdfb9;
}

footer a {
  color: inherit;
  text-decoration: none;
}

footer .heart {
  color: #dc143c;
}
.col {
    visibility:hidden;
}

.col span {
    visibility:visible;
}
</style>

@endsection