@extends('frontend.layouts.app')

@section('content')

@include('frontend.inc.nav')

@include('frontend.inc.nav-mobile')

<div>
    <img src="{{ my_asset(\App\BusinessSetting::where('type', 'banners_sponsorship_desktop')->first()->value) }}" srcset="{{ my_asset(\App\BusinessSetting::where('type', 'banners_sponsorship_desktop')->first()->value) }}"
        class="w-100 img-fluid d-none d-sm-block" />
    <img src="{{ my_asset(\App\BusinessSetting::where('type', 'banners_sponsorship_mobile')->first()->value) }}" srcset="{{ my_asset(\App\BusinessSetting::where('type', 'banners_sponsorship_mobile')->first()->value) }}"
        class="w-100 img-fluid d-sm-none mt-5" />
</div>

<section class="gb nopadtop">
    <div class="container">
        <div class="boxed boxedp4">
            <div class="col-md-12 section-title text-center mb-5">
                <h3>{{ \App\BusinessSetting::where('type', 'sponsorships_page_title')->first()->value }}</h3>
                <p class="text-justify mt-3">
                    {{ \App\BusinessSetting::where('type', 'sponsorships_page_details')->first()->value }}
                </p>
            </div>
            @if(isset(\App\BusinessSetting::where('type', 'sponsorships_page_whatsapp_number')->first()->value))
            <div class="col-12 text-center pb-5">
                <h3 class="title section-title"> Sponsorships are now available!<br> Inquire now </h3> 
                <a href="https://wa.me/{{ \App\BusinessSetting::where('type', 'sponsorships_page_whatsapp_number')->first()->value }}" class="btn btn-primary btn-lg shadow">WhatsApp</a> 
                <a href="mailto:{{ config('mail.inquiry') }}?subject=2024 LATAM Event Sponsorship Inquiry" class="btn btn-warning btn-lg shadow">Email</a>
            </div>
            @endif
            <div class="row">
                @php
                    $counter = 1;
                    $total = count($sponsorships);
                    $remaining = $total;
                @endphp
                @foreach ($sponsorships as $sponsorship)
                    <div class="col-md-6 px-2 pb-md-4 d-flex">
                        <div class="card-deck">
                            <div class="card sponsorship">
                                @if($sponsorship->is_sold_out == 0)
                                    <div align="center" class="card-header">
                                        <h5 class="text-uppercase">
                                            <span class="">
                                                <strong style="color: white;"> 
                                                    {{ $sponsorship->name }} (USD {{ $sponsorship->price }}) 
                                                    @if($sponsorship->slots != 0)
                                                        -
                                                        @if($sponsorship->slots == 1)
                                                            LIMITED TO
                                                        @else
                                                            MAXIMUM OF
                                                        @endif
                                                        {{ $sponsorship->slots }}
                                                    @endif
                                                </strong>
                                            </span> 
                                        </h5>
                                    </div>
                                @else
                                    <s>
                                        <div align="center" class="card-header">
                                            <h5 class="text-uppercase">
                                                <span class="line-through">
                                                    <strong style="color: white;">
                                                        {{ $sponsorship->name }} (USD {{ $sponsorship->price }})
                                                        @if($sponsorship->slots != 0)
                                                            - 
                                                            @if($sponsorship->slots == 1)
                                                                LIMITED TO
                                                            @else
                                                                MAXIMUM OF
                                                            @endif
                                                            {{ $sponsorship->slots }}
                                                        @endif
                                                    </strong>
                                                </span> 
                                                <span class="sold" style="color: red;">- SOLD OUT</span>
                                            </h5>
                                        </div>
                                    </s>
                                @endif
                                <div class="card-body">
                                    <div class="row">
                                        @php
                                            $sponsors = \App\Sponsor::select('id','sponsorship_id','logo','website_link','created_at')->where('sponsorship_id', $sponsorship->id)->orderby('created_at','asc')->get();
                                        @endphp
                                        @foreach ($sponsors as $sponsor)
                                            <div align="center" class="col-md-6 m-auto pb-3 pl-4 pr-4" style="margin-top: -20px;">
                                                <a href="{{ $sponsor->website_link }}" target="_blank" rel="noopener noreferrer">
                                                    <img width="170" src="{{ my_asset($sponsor->logo) }}" class="img-fluid">
                                                </a>
                                            </div>
                                        @endforeach
                                    </div>
                                    {!! $sponsorship->inclusions !!}
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div><!-- end container -->
    </div>
</section>

@include('frontend.common.conference')

@endsection

@section('css')
<style>

    .title {
        font-size: 24px !important;
        font-weight: bold !important;
    }

    .btn-primary {
        color: #fff !important;
        background: #007ac1;
        /* padding: 6px 20px !important; */
        border-radius: 50px;
        border: 3px solid #007ac1;
        transition: all ease-in-out 0.3s;
        font-weight: 500;
        margin-left: 8px;
        margin-top: 10px;
        line-height: 1;
        font-size: 16px;
        margin-bottom: 10px !important;
    }

    .btn-primary:hover {
        color: #007ac1 !important;
        background-color: rgba(255, 255, 255, 0) !important;
        font-weight: 700 !important;
        border-radius: 30px !important;
        border: 3px solid #007ac1;
    }

    .text-widget h3, .section-title h3 {
        margin: 0 0 25px;
        padding: 0;
        line-height: 1;
        font-size: 30px;
        font-weight: 700;
    }

    .card {
        border: 2px solid var(--main-color);
    }

    .header-sponsor {
        background-color: var(--main-color);
    }
    
</style>
@endsection