@if(\App\BusinessSetting::where('type', 'video-or-slideshow-banner')->first()->value == 0)
<!-- video banner -->
<section data-aos="fade" data-aos-duration="500">
    <video width="100%" class="d-sm-none" id="myVideo" poster="" controls="controls" controlsList="nodownload"
        preload="metadata" playsinline autoplay muted loop>
        <source src="" type="video/mp4">
        Your browser does not support HTML5 video. </video>
    <video width="100%" class="d-none d-sm-block" id="myVideo2" preload="metadata" playsinline autoplay muted
        loop>
        <source src="" type="video/mp4">
        Your browser does not support HTML5 video. </video>
</section>
<!-- end video banner -->
@else
<!-- slideshow banner -->
<section data-aos="zoom-out" data-aos-duration="500">

	<div id="carouselExampleIndicators" class="carousel slide" data-ride="carousel">
	<ol class="carousel-indicators">
        @foreach (\App\Slider::where('published', 1)->get() as $key => $slider)
            <li data-target="#carouselExampleIndicators" data-slide-to="{{ $key }}" class=" @if($key == 0) active @endif"></li>
        @endforeach
	</ol>
	<div class="carousel-inner">
        @foreach ($sliders as $key => $slider)
            <div class="carousel-item @if($key == 0) active @endif">
                <img src="{{ my_asset($slider->photo) }}" class="w-100 img-fluid" alt="Image">
            </div>
        @endforeach
		<a class="carousel-control-prev" href="#carouselExampleIndicators" role="button" data-slide="prev">
			<span class="carousel-control-prev-icon" aria-hidden="true"></span>
			<span class="sr-only">Previous</span>
		</a>
		<a class="carousel-control-next" href="#carouselExampleIndicators" role="button" data-slide="next">
			<span class="carousel-control-next-icon" aria-hidden="true"></span>
			<span class="sr-only">Next</span>
		</a>
	</div>
</section>
<!-- end slideshow banner -->
@endif

<!-- section 2 -->
<section style="color: {{ \App\BusinessSetting::where('type', 'section2_color')->first()->value }}; background-color: {{ \App\BusinessSetting::where('type', 'section2_bg_color')->first()->value }};" class="py-sm-4 pt-3">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8 border-right text-center text-sm-left py-2" align="LEFT">
                <span class="text-uppercase event-title">
                    {{ \App\BusinessSetting::where('type', 'section2_title')->first()->value }}
                </span>
                <br>
                <span class="stats-main">
                    {{ \App\BusinessSetting::where('type', 'section2_sub_title')->first()->value }}
                </span>
            </div>
            <div class="col-lg-4 text-center text-sm-left py-2">
                <span class="venue">
                    {{ \App\BusinessSetting::where('type', 'section2_location')->first()->value }}
                </span><br>
                <span class="">
                    {{ \App\BusinessSetting::where('type', 'section2_date')->first()->value }}
                </span>
            </div>
        </div>
    </div>
</section>
<!-- end section 2 -->

@if(\App\BusinessSetting::where('type', 'statistics')->first()->value == 1)
<!-- statistics section -->
<section id="statistics" style="color: {{ \App\BusinessSetting::where('type', 'statistics_color')->first()->value }}; background-color: {{ \App\BusinessSetting::where('type', 'statistics_bg_color')->first()->value }};" class="pb-3">
    <div class="container">
        <div class="row">
            <div class="col-12 border-top pt-3">

            </div>
        </div>
        <div class="row">
            <div class="col-lg-3 col-6 py-3" align="center">
                <span class="stats-sub">
                    <i class="{{ \App\BusinessSetting::where('type', 'statistics_icon')->first()->value }}"></i> {{ \App\BusinessSetting::where('type', 'statistics_title')->first()->value }}
                </span>
                <br>
                <span class="stats-main counter">
                    {{ \App\BusinessSetting::where('type', 'statistics_data')->first()->value }}
                </span>
                @if (\App\BusinessSetting::where('type', 'statistics_with_plus_icon')->first()->value == 1)
                    <span class="stats-main">
                        +
                    </span>
                @endif
            </div>
            <div class="col-lg-3 col-6 pt-3" align="center">
                <span class="stats-sub">
                    <i class="{{ \App\BusinessSetting::where('type', 'statistics_icon_1')->first()->value }}"></i> {{ \App\BusinessSetting::where('type', 'statistics_title_1')->first()->value }}
                </span>
                <br>
                <span class="stats-main counter">
                    {{ \App\BusinessSetting::where('type', 'statistics_data_1')->first()->value }}
                </span>
                @if (\App\BusinessSetting::where('type', 'statistics_with_plus_icon_1')->first()->value == 1)
                    <span class="stats-main">
                        +
                    </span>
                @endif
            </div>
            <div class="col-lg-3 col-6 py-3" align="center">
                <span class="stats-sub">
                    <i class="{{ \App\BusinessSetting::where('type', 'statistics_icon_2')->first()->value }}"></i> {{ \App\BusinessSetting::where('type', 'statistics_title_2')->first()->value }}
                </span>
                <br>
                <span class="stats-main counter">
                    {{ \App\BusinessSetting::where('type', 'statistics_data_2')->first()->value }}
                </span>
                @if (\App\BusinessSetting::where('type', 'statistics_with_plus_icon_2')->first()->value == 1)
                    <span class="stats-main">
                        +
                    </span>
                @endif
            </div>
            <div class="col-lg-3 col-6 py-3" align="center">
                <span class="stats-sub">
                    <i class="{{ \App\BusinessSetting::where('type', 'statistics_icon_3')->first()->value }}"></i> {{ \App\BusinessSetting::where('type', 'statistics_title_3')->first()->value }}
                </span>
                <br>
                <span class="stats-main counter">
                    {{ \App\BusinessSetting::where('type', 'statistics_data_3')->first()->value }}
                </span>
                @if (\App\BusinessSetting::where('type', 'statistics_with_plus_icon_3')->first()->value == 1)
                    <span class="stats-main">
                        +
                    </span>
                @endif
            </div>
        </div>
    </div>
</section>
<!-- end statistics section -->
@endif

<!-- activities section -->
@foreach ($activities as $key => $activity)
    <section id="{{ $activity->slug }}" style="color: {{ $activity->text_color }}; background-color: {{ $activity->bg_color }};" class="py-sm-5 py-2">
        <div class="container pb-4 pb-sm-5">
            <div class="row">
                <div class="col-lg-12 text-left pt-4">
                    <span class="section-heading section-title text-uppercase">{{ $activity->title }}</span>
                </div>
                @if(isset($activity->subtitle))
                    <div class="col-lg-12">
                        <span class="subtitle">
                            {{ $activity->subtitle }}
                        </span>
                    </div>
                @endif
                <div class="col-lg-12 text-left pt-4">
                    {!! $activity->description !!}
                </div>
            </div>
            <div class="row">
                <div class="col-12 px-xl-4">
                    <div class="row" uk-lightbox="animation: slide">
                        @foreach (json_decode($activity->images) as $key => $img)
                            <div class="col-6 col-sm-4 px-1 py-1">
                                @if($key == 0)
                                    <a class="uk-inline" @if(isset($activity->img_1_link)) href="{{ $activity->img_1_link }}" @else href="{{ my_asset($img) }}" @endif>
                                        <img src="{{ my_asset($img) }}" class="img-fluid">
                                    </a>
                                @elseif($key == 1)
                                    <a class="uk-inline" @if(isset($activity->img_2_link)) href="{{ $activity->img_2_link }}" @else href="{{ my_asset($img) }}" @endif>
                                        <img src="{{ my_asset($img) }}" class="img-fluid">
                                    </a>
                                @elseif($key == 2)
                                    <a class="uk-inline" @if(isset($activity->img_3_link)) href="{{ $activity->img_3_link }}" @else href="{{ my_asset($img) }}" @endif>
                                        <img src="{{ my_asset($img) }}" class="img-fluid">
                                    </a>
                                @elseif($key == 3)
                                    <a class="uk-inline" @if(isset($activity->img_4_link)) href="{{ $activity->img_4_link }}" @else href="{{ my_asset($img) }}" @endif>
                                        <img src="{{ my_asset($img) }}" class="img-fluid">
                                    </a>
                                @elseif($key == 4)
                                    <a class="uk-inline" @if(isset($activity->img_5_link)) href="{{ $activity->img_5_link }}" @else href="{{ my_asset($img) }}" @endif>
                                        <img src="{{ my_asset($img) }}" class="img-fluid">
                                    </a>
                                @elseif($key == 5)
                                    <a class="uk-inline" @if(isset($activity->img_6_link)) href="{{ $activity->img_6_link }}" @else href="{{ my_asset($img) }}" @endif>
                                        <img src="{{ my_asset($img) }}" class="img-fluid">
                                    </a>
                                @endif
                            </div>
                        @endforeach
                    </div>
                </div>

            </div>
        </div>
    </section>
@endforeach
<!-- activities section -->

@if(\App\BusinessSetting::where('type', 'after_movie')->first()->value == 1)
<!-- after movie section -->
<section id="after-movie" style="color: {{ \App\BusinessSetting::where('type', 'after_movie_color')->first()->value }}; background-color: {{ \App\BusinessSetting::where('type', 'after_movie_bg_color')->first()->value }};" class="py-sm-5 py-2">
    <div class="container pt-4">
        <div class="row align-items-center">
            <div class="col-md-6 pt-3 pt-sm-0 @if(\App\BusinessSetting::where('type', 'after_movie_title_position')->first()->value == 'Left') order-1 @else order-2 @endif " style="text-align:center;">
                <span class="section-title after-movie">
                    {{ \App\BusinessSetting::where('type', 'after_movie_title')->first()->value }}
                </span>
            </div>
            <div class="col-md-6 @if(\App\BusinessSetting::where('type', 'after_movie_image_position')->first()->value == 'Left') order-1 @else order-2 @endif"> 
                <a href="{{ \App\BusinessSetting::where('type', 'after_movie_link')->first()->value }}" target="_blank">
                    <img src="{{ my_asset(\App\BusinessSetting::where('type', 'after_movie_image')->first()->value) }}" class="img-fluid shadow-lg">
                </a>
            </div>
        </div>
    </div>
</section>
<!-- end after movie section -->
@endif

@if(\App\BusinessSetting::where('type', 'testimonials')->first()->value == 1)
<!-- testimonials section -->
<section id="testimonials" style="color: {{ \App\BusinessSetting::where('type', 'testi_color')->first()->value }}; background-color: {{ \App\BusinessSetting::where('type', 'testi_bg_color')->first()->value }};" class="py-sm-5 py-2" >
    <div class="container pb-sm-5 pb-4">
        <div class="row">
            <div class="col-lg-12 center pt-2 pb-4" >
                <span class="section-heading section-title">{!! \App\BusinessSetting::where('type', 'testi_title')->first()->value !!}</span>
                <hr>
            </div>
            <!-- <div class="col-lg-12">
                <span class="subtitle">
                    HAPPY HOUR – SPONSORED BY ADVANTAGE WORLDWIDE (UK) LTD
                </span>
            </div> -->
        </div>
        <div class="row">
            <div class="col-12 px-xl-4">

                <div class="row" uk-lightbox="animation: slide">
                    @foreach($testimonials as $key => $testimonial)
                        <div class="{{ $testimonial->classes }}">
                            <a class="uk-inline" href="{{ $testimonial->name }}">
                                <img src="{{ my_asset($testimonial->photo) }}" class="img-fluid">
                            </a>
                        </div>
                    @endforeach
                </div>
            
            </div>
        </div>
    </div>
</section>
<!-- testimonials section -->
@endif

@if(\App\BusinessSetting::where('type', 'keynote')->first()->value == 1)
<!-- keynote section -->
<section id="keynote" style="color: {{ \App\BusinessSetting::where('type', 'keynote_color')->first()->value }}; background-color: {{ \App\BusinessSetting::where('type', 'keynote_bg_color')->first()->value }};" class="py-sm-5 py-2">
    <div class="container pt-4">
        <div class="row align-items-center">
            <div class="col-md-6 pt-3 pt-sm-0" style="text-align:center;">
                <span class="section-title2">
                    {!! \App\BusinessSetting::where('type', 'keynote_title')->first()->value !!}
                </span>
            </div>
            <div class="col-md-6">
                <a href="{{ my_asset(\App\BusinessSetting::where('type', 'keynote_link')->first()->value) }}" target="_blank">
                <img src="{{ my_asset(\App\BusinessSetting::where('type', 'keynote_image')->first()->value) }}" class="img-fluid shadow-lg"></a>
            </div>
        </div>
    </div>
</section>
<!-- keynote section -->
@endif

@if(\App\BusinessSetting::where('type', 'downloadables_photos')->first()->value == 1 || \App\BusinessSetting::where('type', 'downloadables_list')->first()->value == 1)
<!-- download section -->
<section id="download" style="color: {{ \App\BusinessSetting::where('type', 'downloadables_color')->first()->value }}; background-color: {{ \App\BusinessSetting::where('type', 'downloadables_bg_color')->first()->value }};" class="pb-5" >
    
    <div class="container">
        
        <div class="row pt-sm-5 pt-3 text-center">
            <div class="col-12 pb-5 border-top d-none d-sm-block"></div>
            @if(\App\BusinessSetting::where('type', 'downloadables_photos')->first()->value == 1)
                <div class="@if(\App\BusinessSetting::where('type', 'downloadables_list')->first()->value == 1) col-sm-6 @else col-sm-12 @endif text-sm-center text-left">
                    <a style="color:white;"
                        href="{{ \App\BusinessSetting::where('type', 'downloadables_photos_link')->first()->value }}" target="_blank">
                        <i class="fa fa-download fa-2x"  style="color: white"></i> &nbsp; {{ \App\BusinessSetting::where('type', 'downloadables_photos_title')->first()->value }}
                    </a>
                </div>
            @endif
            @if(\App\BusinessSetting::where('type', 'downloadables_list')->first()->value == 1)
                <div class="@if(\App\BusinessSetting::where('type', 'downloadables_photos')->first()->value == 1) col-sm-6 @else col-sm-12 @endif text-sm-center text-left">
                    <a style="color:white;"
                        href="{{ \App\BusinessSetting::where('type', 'downloadables_list_link')->first()->value }}"
                        target="_blank">
                        <i class="fa fa-file-download fa-2x" style="color: white"></i>&nbsp; {{ \App\BusinessSetting::where('type', 'downloadables_list_title')->first()->value }}
                    </a>
                </div>
            @endif
        </div>

    </div>

</section>
<!-- download section -->
@endif

<!-- sponsors section -->
<section id="sponsors" class="theme-color-sponsor pt-5 text-sponsor">
    <div class="container">

        <div class="row">
            <div class="col-lg-12 text-center pt-sm-4 pb-sm-5 py-4">
                <span class="section-heading section-title">Our Sponsors</span>
            </div>
        </div>

        @if(count($diamond_sponsors) > 0)
            <div class="row pb-sm-12 pt-sm-4 pt-0 center align-content-center">
                @foreach($diamond_sponsors as $key => $diamond_sponsor)
                    <div class="{{ $diamond_sponsor->column_size }} col-6 pb-4" align="center">
                        <a href="{{ $diamond_sponsor->website_link }}" target="_blank">
                            <img src="{{ my_asset( $diamond_sponsor->logo ) }}" style="height: {{ $diamond_sponsor->height }}px !important;" class="{{ $diamond_sponsor->image_class }}">
                        </a>
                        <p class="line-height-1p2"><strong>{{ $diamond_sponsor->name }}</strong></p>
                    </div>
                @endforeach
            </div>
        @endif

        <div class="row pb-sm-3 pt-sm-4 pt-0">

            @if(count($gold_sponsors) > 0)
                <div class="row justify-content-center w-100 mb-4" style="flex-grow: 1;">
                    @foreach($gold_sponsors as $key => $gold_sponsor)
                        <div class="{{ $gold_sponsor->column_size }} col-6 pb-4 align-self-center position-relative h-35 mb-3" align="center">
                            <a href="{{ $gold_sponsor->website_link }}" target="_blank">
                                <img src="{{ my_asset( $gold_sponsor->logo ) }}" style="height: {{ $gold_sponsor->height }}px !important;" class="{{ $gold_sponsor->image_class }}">
                            </a>
                            <!-- <p class="line-height-1p2 position-absolute pos-abs-center-bottom"><strong>{{ $gold_sponsor->name }}</strong></p> -->
                            <p style="{{ $gold_sponsor->sponsorship_name_css }}"><strong>{{ $gold_sponsor->name }}</strong></p>
                        </div>
                    @endforeach
                </div>
            @endif

            @if(count($others_sponsors) > 0)
                <div id="others_sponsors" class="row justify-content-center w-100">
                    @foreach($others_sponsors as $key => $others_sponsor)
                        <div class="{{ $others_sponsor->column_size }} col-6 pb-4 align-self-center position-relative h-35 mb-3" align="center">
                            <a href="{{ $others_sponsor->website_link }}" target="_blank">
                                <img src="{{ my_asset( $others_sponsor->logo ) }}" style="height: {{ $others_sponsor->height }}px !important;" class="{{ $others_sponsor->image_class }}">
                            </a>
                            <!-- <p class="line-height-1p2 position-absolute pos-abs-center-bottom"><strong>{{ $others_sponsor->name }}</strong></p> -->
                            <p style="{{ $others_sponsor->sponsorship_name_css }}"><strong>{{ $others_sponsor->name }}</strong></p>
                        </div>
                    @endforeach
                </div>
            @endif

        </div>

        @if(count($special_thanks) > 0)
            <div class="col-12 border-bottom pt-sm-5 pt-2 border-secondary">
            </div>

            <div class="row">
                <div class="col-lg-12 text-center pt-5 py-4">
                    <span class="section-heading section-title">Special Thanks To</span>
                </div>
            </div>
            <div class="row align-items-center center w-100">
                @foreach($special_thanks as $key => $special_thank)
                    <div class="{{ $special_thank->column_size }} col-6 pb-3" align="center">
                        <a href="{{ $special_thank->website_link }}" target="_blank">
                            <img src="{{ my_asset( $special_thank->logo ) }}" style="height: {{ $special_thank->height }}px !important;" class="img-fluid">
                        </a>
                    </div>
                @endforeach
            </div>
        @endif

    </div>
</section>
<!-- end sponsors section -->

<!-- Contact -->
<section style="color: {{ \App\BusinessSetting::where('type', 'bf_color')->first()->value }}; background-color: {{ \App\BusinessSetting::where('type', 'bf_bg_color')->first()->value }};" class="py-sm-5 py-2" >
    <div class="container">
        <div class="row align-items-center py-sm-4 py-2">
            <div class="col-sm-4 col-6 pt-4 offset-3 offset-sm-0 text-center">
                <img src="{{ my_asset(\App\BusinessSetting::where('type', 'bf_image')->first()->value) }}" class="img-fluid profile-img"><br>
                <span class="d-none d-sm-block" style="font-size:20px;">
                {{ \App\BusinessSetting::where('type', 'bf_name')->first()->value }}<br>
                </span>
                <span class="d-none d-sm-block">{{ \App\BusinessSetting::where('type', 'bf_position')->first()->value }}</span>
            </div>
            <div class="col-12 text-center d-sm-none">
                <span style="font-size:20px;">
                {{ \App\BusinessSetting::where('type', 'bf_name')->first()->value }}<br>
                </span>
                <span>{{ \App\BusinessSetting::where('type', 'bf_position')->first()->value }}</span>
            </div>
            <div class="col-lg-8 text-left pt-4">
                <p>{{ \App\BusinessSetting::where('type', 'bf_description')->first()->value }}
                    <span> <a style="text-decoration:none; font-weight:bold; color: {{ $generalsetting->frontend_color }};"
                            href="mailto:{{ \App\BusinessSetting::where('type', 'bf_email')->first()->value }}">{{ \App\BusinessSetting::where('type', 'bf_email')->first()->value }}
                        </a></span></p>
                <p class="subtitle">{{ \App\BusinessSetting::where('type', 'bf_greetings')->first()->value }}</p>
            </div>
        </div>
    </div>
</section>
<!-- Contact -->

<script type="text/javascript">

    $(document).ready(function() {
        @if(\App\BusinessSetting::where('type', 'video-or-slideshow-banner')->first()->value == 0)
            var scr = window.screen.width;
            if (scr < 576) {
                document.getElementById("myVideo").src = "{{ my_asset(\App\BusinessSetting::where('type', 'banner_video_mobile')->first()->value) }}";
            } else {
                document.getElementById("myVideo2").src = "{{ my_asset(\App\BusinessSetting::where('type', 'banner_video')->first()->value) }}";
                document.getElementById("myVideo2").poster = "";
            }
            video.addEventListener('loadedmetadata', function() {
                if (video.buffered.length === 0) return;

                var bufferedSeconds = video.buffered.end(0) - video.buffered.start(0);
                console.log(bufferedSeconds + ' seconds of video are ready to play!');
            });
        @endif
    });

    window.onresize = function() {

        @if(\App\BusinessSetting::where('type', 'video-or-slideshow-banner')->first()->value == 01)
            var scr = window.screen.width;
            if (scr < 576) {
                document.getElementById("myVideo").src = "{{ my_asset(\App\BusinessSetting::where('type', 'banner_video_mobile')->first()->value) }}";
            } else {
                document.getElementById("myVideo2").src = "{{ my_asset(\App\BusinessSetting::where('type', 'banner_video')->first()->value) }}";
                document.getElementById("myVideo2").poster = "";
            }
            video.addEventListener('loadedmetadata', function() {
                if (video.buffered.length === 0) return;

                var bufferedSeconds = video.buffered.end(0) - video.buffered.start(0);
                console.log(bufferedSeconds + ' seconds of video are ready to play!');
            });
        @endif

    };

</script>