<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <link name="favicon" type="image/x-icon" href="{{my_asset(\App\GeneralSetting::first()->favicon)}}" rel="shortcut icon" />

    <title>{{ config('app.name', 'Laravel') }}</title>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet" type="text/css">

    <!--Bootstrap Stylesheet [ REQUIRED ]-->
    <link href="{{ my_asset('css/bootstrap.min.css')}}" rel="stylesheet">

    <!--Font Awesome [ OPTIONAL ]-->
    <link href="{{ my_asset('plugins/font-awesome/css/font-awesome.min.css')}}" rel="stylesheet">

    <!--rahuyo Stylesheet [ REQUIRED ]-->
    <link href="{{ my_asset('css/rahuyo.min.css')}}" rel="stylesheet">

    <!--rahuyo Premium Icon [ DEMONSTRATION ]-->
    <link href="{{ my_asset('css/demo/rahuyo-icons.min.css')}}" rel="stylesheet">

    <!--Demo [ DEMONSTRATION ]-->
    <link href="{{ my_asset('css/demo/rahuyo-demo.min.css') }}" rel="stylesheet">

    <!--Theme [ DEMONSTRATION ]-->
    <link href="{{ my_asset('css/themes/type-c/theme-navy.min.css') }}" rel="stylesheet">

    <link href="{{ my_asset('css/custom.css') }}" rel="stylesheet">

</head>
<body>
    @php
        $generalsetting = \App\GeneralSetting::first();
    @endphp
    <div id="container" class="blank-index"
        @if ($generalsetting->admin_login_background != null)
            style="background-image:url('{{ my_asset($generalsetting->admin_login_background) }}');"
        @else
            style="background-image:url('{{ my_asset('img/bg-img/login-bg.jpg') }}');"
        @endif>
        <div class="cls-content">
            <div class="container">
                <div class="row">
                    <!-- <div class="col-md-10 col-md-offset-1">
                        <div class="panel">
                            <div class="panel-body pad-no"> -->
                                @yield('content')
                            <!-- </div>
                        </div>
                    </div> -->
                </div>
            </div>
        </div>
    </div>

    <!--JAVASCRIPT-->
    <!--=================================================-->

    <!--jQuery [ REQUIRED ]-->
    <script src=" {{my_asset('js/jquery.min.js') }}"></script>


    <!--BootstrapJS [ RECOMMENDED ]-->
    <script src="{{ my_asset('js/bootstrap.min.js') }}"></script>


    <!--rahuyo [ RECOMMENDED ]-->
    <script src="{{ my_asset('js/rahuyo.min.js') }}"></script>

    <!--Alerts [ SAMPLE ]-->
    <script src="{{my_asset('js/demo/ui-alerts.js') }}"></script>

    @yield('script')

</body>
</html>
