<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
// use App\Mail\SupportMailManager;
//demo
// Route::get('/demo/cron_1', 'DemoController@cron_1');
// Route::get('/demo/cron_2', 'DemoController@cron_2');

// Route::get('helloworld', function() {
// 	return new SupportMailManager();
// });

// Route::get('/refresh-csrf', function() {
//     return csrf_token();
// });

Auth::routes(['verify' => true]);

Route::get('/routeCache', 'HomeController@routeCache');
Route::get('/configClear', 'HomeController@configClear');
Route::get('/cacheClear', 'HomeController@cacheCleared');
Route::get('/configCache', 'HomeController@configCache');
Route::get('/viewClear', 'HomeController@viewClear');

Route::get('/logout', '\App\Http\Controllers\Auth\LoginController@logout');

//Home Page
Route::get('/', 'HomeController@index')->name('home');

Route::post('inquiry', 'HomeController@inquiry');

// Route::get('/sitemap.xml', 'HomeController@sitemap')->name('sitemap-xml');

Route::get('/about-us', 'HomeController@about_us')->name('about_us');
Route::get('/agenda', 'HomeController@agenda')->name('agenda');
Route::get('/meeting-cost', 'HomeController@meeting_cost')->name('meeting_cost');
Route::get('/meeting-scheduler', 'HomeController@meeting_scheduler')->name('meeting_scheduler');
Route::get('/visa-and-covid-info', 'HomeController@visa')->name('visa');
Route::get('/covid-info', 'HomeController@covid_info')->name('covid_info');
Route::get('/about-{slug}', 'HomeController@about_location')->name('about_location');
Route::get('/about-dubai', 'HomeController@about_dubai')->name('about_dubai');
Route::get('/about-bangkok', 'HomeController@about_bangkok')->name('about_bangkok');
Route::get('/hotel', 'HomeController@hotel')->name('hotel');
Route::get('/contact-us', 'HomeController@contact_us')->name('contact_us');
Route::get('/registration', 'HomeController@registration')->name('registration');
Route::get('/sponsorship', 'HomeController@sponsorship')->name('sponsorship');

Route::post('/send-contact', 'HomeController@sendEmail')->name('contact.send');

Route::post('/submit-registration', 'HomeController@submitRegistration')->name('registration.submit');