

<?php $__env->startSection('content'); ?>

<div class="row">
    <div class="col-lg-12">
        <div class="panel">
            <div class="panel-heading">
            <h3 class="panel-title text-center"><?php echo e(translate('Sponsorships Banners')); ?></h3> 
            </div>
            <div class="panel-body">
                <form class="form-horizontal" action="<?php echo e(route('banners.update')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    
                    <?php if(isset(\App\BusinessSetting::where('type', 'banners_sponsorship_desktop')->first()->value)): ?>
                    <div class="form-group">
                        <div class="widget-image-box text-center">
                            <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="<?php echo e(my_asset(\App\BusinessSetting::where('type', 'banners_sponsorship_desktop')->first()->value)); ?>" alt="Display Picture">
                        </div>
                    </div>
                    <?php endif; ?>
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="banners_sponsorship_desktop"><?php echo e(translate('Desktop Banner')); ?> <span class="red">*</span></label>
                        <div class="col-sm-10">
                            <input type="file" id="banners_sponsorship_desktop" name="banners_sponsorship_desktop" class="form-control">
                        </div>
                    </div>

                    <?php if(isset(\App\BusinessSetting::where('type', 'banners_sponsorship_mobile')->first()->value)): ?>
                    <div class="form-group">
                        <div class="widget-image-box text-center">
                            <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="<?php echo e(my_asset(\App\BusinessSetting::where('type', 'banners_sponsorship_mobile')->first()->value)); ?>" alt="Display Picture">
                        </div>
                    </div>
                    <?php endif; ?>
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="banners_sponsorship_mobile"><?php echo e(translate('Mobile Banner')); ?> <span class="red">*</span></label>
                        <div class="col-sm-10">
                            <input type="file" id="banners_sponsorship_mobile" name="banners_sponsorship_mobile" class="form-control">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="sponsorships_page_title"><?php echo e(translate('Title')); ?> <span class="red">*</span></label>
                        <div class="col-sm-10">
                            <input type="text" placeholder="<?php echo e(translate('Title')); ?>" id="sponsorships_page_title" name="sponsorships_page_title" class="form-control" required value="<?php echo e(\App\BusinessSetting::where('type', 'sponsorships_page_title')->first()->value); ?>">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="sponsorships_page_details"><?php echo e(translate('Description')); ?> <span class="red">*</span></label>
                        <div class="col-sm-10">
                            <textarea class="form-control" rows="4" name="sponsorships_page_details" required><?php echo e(\App\BusinessSetting::where('type', 'sponsorships_page_details')->first()->value); ?></textarea>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="sponsorships_page_whatsapp_number"><?php echo e(translate('WhatsApp Number')); ?> </label>
                        <div class="col-sm-10">
                            <input type="text" placeholder="<?php echo e(translate('WhatsApp Number')); ?>" id="sponsorships_page_whatsapp_number" name="sponsorships_page_whatsapp_number" class="form-control" value="<?php echo e(\App\BusinessSetting::where('type', 'sponsorships_page_whatsapp_number')->first()->value); ?>">
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-lg-12 text-right">
                            <button class="btn btn-success" type="submit"><?php echo e(translate('Update Banners')); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<br>

<div class="row">
    <div class="col-sm-12">
        <a href="<?php echo e(route('sponsorships.create')); ?>" class="btn btn-rounded btn-info pull-right"><?php echo e(translate('Add New Sponsorships')); ?></a>
    </div>
</div>

<br>

<!-- Basic Data Tables -->
<!--===================================================-->
<div class="panel">
    <div class="panel-heading bord-btm clearfix pad-all h-100">
        <h3 class="panel-title pull-left pad-no"><?php echo e(translate('Sponsorships')); ?></h3>
    </div>
    <div class="panel-body">
        <table id="dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
            <thead>
                <tr>
                    <th><?php echo e(translate('Name')); ?></th>
                    <th><?php echo e(translate('Price')); ?></th>
                    <th><?php echo e(translate('Slots')); ?></th>
                    <th><?php echo e(translate('Type')); ?></th>
                    <th><?php echo e(translate('Order Number')); ?></th>
                    <th><?php echo e(translate('Published')); ?></th>
                    <th><?php echo e(translate('Is Sold Out?')); ?></th>
                    <th><?php echo e(translate('Created At')); ?></th>
                    <th width="16%"><?php echo e(translate('Options')); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $sponsorships; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $sponsorship): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($sponsorship->name); ?></td>
                        <td><?php echo e($sponsorship->price); ?></td>
                        <td><?php echo e($sponsorship->slots); ?></td>
                        <td><?php echo e($sponsorship->type == 1 ? 'Premium' : 'Regular'); ?></td>
                        <td><?php echo e($sponsorship->order_number); ?></td>
                        <td>
                            <label class="switch">
                            <input onchange="published(this)" value="<?php echo e($sponsorship->id); ?>" type="checkbox" <?php if($sponsorship->published == 1) echo "checked";?> >
                            <span class="slider round"></span></label>
                        </td>
                        <td>
                            <label class="switch">
                            <input onchange="soldOut(this)" value="<?php echo e($sponsorship->id); ?>" type="checkbox" <?php if($sponsorship->is_sold_out == 1) echo "checked";?> >
                            <span class="slider round"></span></label>
                        </td>
                        <td><?php echo e(date('F d, Y h:i:s A', strtotime($sponsorship->created_at))); ?></td>
                        <td>
                            <a class="btn btn-success" href="<?php echo e(route('sponsorships.edit', encrypt($sponsorship->id))); ?>"><?php echo e(translate('Edit')); ?></a>
                            <a class="btn btn-danger" onclick="confirm_modal('<?php echo e(route('sponsorships.destroy', $sponsorship->id)); ?>');"><?php echo e(translate('Delete')); ?></a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>

<script type="text/javascript">
    $(document).ready(function() {
        if ( $.fn.dataTable.isDataTable( '#dt-selection' ) ) {
            $('#dt-selection').DataTable( {
                destroy: true,
                "responsive": true,
                "language": {
                    "paginate": {
                    "previous": '<i class="demo-psi-arrow-left"></i>',
                    "next": '<i class="demo-psi-arrow-right"></i>'
                    }
                },
                columnDefs: [
                    { orderable: false, targets: 5 },
                    { orderable: false, targets: 6 },
                    { orderable: false, targets: 8 }
                ],
                order: [[7, 'desc']],
            } );
        }
    } );

    function published(el){
        if(el.checked){
            var published = 1;
        } else {
            var published = 0;
        }
        $.post('<?php echo e(route('sponsorships.published')); ?>', {_token:'<?php echo e(csrf_token()); ?>', id:el.value, published:published}, function(data){
            if(data == 1){
                showAlert('success', 'Sponsorship published status changed successfully');
            }
            else{
                showAlert('danger', 'Something went wrong');
            }
        });
    }

    function soldOut(el){
        if(el.checked){
            var soldOut = 1;
        } else {
            var soldOut = 0;
        }
        $.post('<?php echo e(route('sponsorships.sold_out')); ?>', {_token:'<?php echo e(csrf_token()); ?>', id:el.value, soldOut:soldOut}, function(data){
            if(data == 1){
                if(soldOut == 1){
                    showAlert('success', 'Sponsorship is sold out');
                } else {
                    showAlert('success', 'Sponsorship is still available');
                }
            }
            else{
                showAlert('danger', 'Something went wrong');
            }
        });
    }
    
</script>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>

<style>
    .dataTables_wrapper .dataTables_paginate .paginate_button {
        padding: 0 0;
    }
</style>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/clnupdates/rwexpos.clnupdates.com/rw-regs/2024/resources/views/backend/sponsorships/index.blade.php ENDPATH**/ ?>