<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <link name="favicon" type="image/x-icon" href="<?php echo e(my_asset(\App\GeneralSetting::first()->favicon)); ?>" rel="shortcut icon" />

    <title><?php echo e(config('app.name', 'Laravel')); ?></title>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet" type="text/css">

    <!--Bootstrap Stylesheet [ REQUIRED ]-->
    <link type="text/css" href="<?php echo e(my_asset('css/bootstrap.min.css')); ?>" rel="stylesheet">

    <!--rahuyo Stylesheet [ REQUIRED ]-->
    <link type="text/css" href="<?php echo e(my_asset('css/rahuyo.css')); ?>" rel="stylesheet">
    <!-- <link type="text/css" href="<?php echo e(my_asset('css/rahuyo.min.css')); ?>" rel="stylesheet"> -->

    <!--rahuyo Premium Icon [ DEMONSTRATION ]-->
    <link type="text/css" href="<?php echo e(my_asset('css/demo/rahuyo-icons.min.css')); ?>" rel="stylesheet">

    <!--Font Awesome [ OPTIONAL ]-->
    <link type="text/css" href="<?php echo e(my_asset('plugins/font-awesome/css/font-awesome.min.css')); ?>" rel="stylesheet">

    <!--Switchery [ OPTIONAL ]-->
    <link type="text/css" href="<?php echo e(my_asset('plugins/switchery/switchery.min.css')); ?>" rel="stylesheet">

    <!--DataTables [ OPTIONAL ]-->
    <link type="text/css" href="<?php echo e(my_asset('plugins/datatables/media/css/dataTables.bootstrap.css')); ?>" rel="stylesheet">
    <link type="text/css" href="<?php echo e(my_asset('plugins/datatables/extensions/Responsive/css/responsive.dataTables.min.css')); ?>" rel="stylesheet">

    <!--Select2 [ OPTIONAL ]-->
    <link type="text/css" href="<?php echo e(my_asset('plugins/select2/css/select2.min.css')); ?>" rel="stylesheet">

    <link type="text/css" href="<?php echo e(my_asset('css/bootstrap-select.min.css')); ?>" rel="stylesheet">

    <!--Chosen [ OPTIONAL ]-->
    

    <link type="text/css" href="<?php echo e(my_asset('frontend/css/bootstrap-datepicker.min.css')); ?>" rel="stylesheet" media="none" onload="if(media!='all')media='all'">

    <!--Bootstrap Tags Input [ OPTIONAL ]-->
    <link type="text/css" href="<?php echo e(my_asset('plugins/bootstrap-tagsinput/bootstrap-tagsinput.min.css')); ?>" rel="stylesheet">

    <!--Summernote [ OPTIONAL ]-->
    <link type="text/css" href="<?php echo e(my_asset('css/jodit.min.css')); ?>" rel="stylesheet">

    <!--Admin Theme-->
    <link type="text/css" href="<?php echo e(my_asset('css/themes/type-a/theme-navy.min.css')); ?>" rel="stylesheet">

    <!--Spectrum Stylesheet [ REQUIRED ]-->
    <link type="text/css" href="<?php echo e(my_asset('css/spectrum.min.css')); ?>" rel="stylesheet">

    <!--Custom Stylesheet [ REQUIRED ]-->
    <link type="text/css" href="<?php echo e(my_asset('css/custom.css')); ?>" rel="stylesheet">

    <!-- Ionicons -->
    <link type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css" media="all" rel="stylesheet" type="text/css" />


    <!--JAVASCRIPT-->
    <!--=================================================-->

    <!--jQuery [ REQUIRED ]-->
    <script src=" <?php echo e(my_asset('js/jquery.min.js')); ?>"></script>

    <!--Bootstrap Datepicker -->
    <script src="<?php echo e(my_asset('plugins/bootstrap-datepicker/bootstrap-datepicker-2.min.js')); ?>"></script>
    <script src="<?php echo e(my_asset('plugins/bootstrap-wizard/jquery.bootstrap.wizard.min.js')); ?>"></script>
    <script src="<?php echo e(my_asset('plugins/bootstrap-validator/bootstrapValidator.min.js')); ?>"></script>
    <script src="<?php echo e(my_asset('plugins/bootstrap-tagsinput/bootstrap-tagsinput.min.js')); ?>"></script>

    <!--BootstrapJS [ RECOMMENDED ]-->
    <script src="<?php echo e(my_asset('js/bootstrap.min.js')); ?>"></script>

    <!--rahuyo [ RECOMMENDED ]-->
    <script src="<?php echo e(my_asset('js/rahuyo.min.js')); ?>"></script>

    <!--Alerts [ SAMPLE ]-->
    <script src="<?php echo e(my_asset('js/demo/ui-alerts.js')); ?>"></script>

    <!--Switchery [ OPTIONAL ]-->
    <script src="<?php echo e(my_asset('plugins/switchery/switchery.min.js')); ?>"></script>

    <!--DataTables [ OPTIONAL ]-->
    <script src="<?php echo e(my_asset('plugins/datatables/media/js/jquery.dataTables.js')); ?>"></script>
    <script src="<?php echo e(my_asset('plugins/datatables/media/js/dataTables.bootstrap.js')); ?>"></script>
    <script src="<?php echo e(my_asset('plugins/datatables/extensions/Responsive/js/dataTables.responsive.min.js')); ?>"></script>

    <!--DataTables Sample [ SAMPLE ]-->
    <script src="<?php echo e(my_asset('js/demo/tables-datatables.js')); ?>"></script>

    <!--Select2 [ OPTIONAL ]-->
    <script src="<?php echo e(my_asset('plugins/select2/js/select2.min.js')); ?>"></script>
    <script src="<?php echo e(my_asset('js/bootstrap-select.min.js')); ?>"></script>

    <!--Summernote [ OPTIONAL ]-->
    <script src="<?php echo e(my_asset('js/jodit.min.js')); ?>"></script>

    <!--Form Component [ SAMPLE ]-->
    <script src="<?php echo e(my_asset('js/demo/form-wizard.js')); ?>"></script>

    <!--Spectrum JavaScript [ REQUIRED ]-->
    <script src="<?php echo e(my_asset('js/spectrum.js')); ?>"></script>

    <!--Spartan Image JavaScript [ REQUIRED ]-->
    <script src="<?php echo e(my_asset('js/spartan-multi-image-picker-min.js')); ?>"></script>

    <!--Custom JavaScript [ REQUIRED ]-->
    <script src="<?php echo e(my_asset('js/custom.js')); ?>"></script>

    <script type="text/javascript">

        $( document ).ready(function() {
            //$('div.alert').not('.alert-important').delay(3000).fadeOut(350);
            if($('.active-link').parent().parent().parent().is('ul')){
                $('.active-link').parent().parent().addClass('in');
                $('.active-link').parent().parent().parent().addClass('in');
            }
            if($('.active-link').parent().parent().is('li')){
                $('.active-link').parent().parent().addClass('active-sub');
            }
            if($('.active-link').parent().is('ul')){
                $('.active-link').parent().addClass('in');
            }

        });

    </script>

    <!-- Global site tag (gtag.js) - Google Analytics -->
    <?php if(\App\BusinessSetting::where('type', 'google_analytics')->first()->value == 1): ?>
        <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e(config('services.TRACKING_ID')); ?>"></script>

        <script>
            window.dataLayer = window.dataLayer || [];
            function gtag(){dataLayer.push(arguments);}
            gtag('js', new Date());
            gtag('config', <?php config('services.TRACKING_ID') ?>);
        </script>
    <?php endif; ?>


</head>
<body>

    <?php $__currentLoopData = session('flash_notification', collect())->toArray(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <script type="text/javascript">
            $(document).on('nifty.ready', function() {
                showAlert('<?php echo e($message['level']); ?>', '<?php echo e($message['message']); ?>');
            });
        </script>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


    <div id="container" class="effect aside-float aside-bright mainnav-lg">

        <?php echo $__env->make('inc.admin_nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="boxed">

            <!--CONTENT CONTAINER-->
            <!--===================================================-->
            <div id="content-container">
                <div id="page-content">

                    <?php echo $__env->yieldContent('content'); ?>

                </div>
            </div>
        </div>

        <?php echo $__env->make('inc.admin_sidenav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php echo $__env->make('inc.admin_footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php echo $__env->make('partials.modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
        <?php echo $__env->yieldContent('modal'); ?>

    </div>

    <?php echo $__env->yieldContent('script'); ?>

    <?php echo $__env->yieldContent('css'); ?>

</body>
</html>
<?php /**PATH /home/clnupdates/rwexpos.clnupdates.com/rw-regs/2024/resources/views/layouts/app.blade.php ENDPATH**/ ?>