

<?php $__env->startSection('content'); ?>

<!-- Basic Data Tables -->
<!--===================================================-->
<div class="panel">
    <div class="panel-heading bord-btm clearfix pad-all h-100">
        <h3 class="panel-title pull-left pad-no"><?php echo e(translate('Registrants')); ?></h3>
    </div>
    <div class="panel-body">
        <table id="dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
            <thead>
                <tr>
                    <th><?php echo e(translate('Title')); ?></th>
                    <th><?php echo e(translate('Firstname')); ?></th>
                    <th><?php echo e(translate('Lastname')); ?></th>
                    <th><?php echo e(translate('Designation')); ?></th>
                    <th><?php echo e(translate('Email')); ?></th>
                    <th><?php echo e(translate('Mobile')); ?></th>

                    <th><?php echo e(translate('Shirt Size')); ?></th>

                    <th><?php echo e(translate('Company')); ?></th>
                    <th><?php echo e(translate('Telephone')); ?></th>
                    <th><?php echo e(translate('Website')); ?></th>
                    <th><?php echo e(translate('IATA Number')); ?></th>
                    <th><?php echo e(translate('Address')); ?></th>
                    <th><?php echo e(translate('City')); ?></th>
                    <th><?php echo e(translate('Country')); ?></th>

                    <th><?php echo e(translate('Early Bird')); ?></th>

                    <th><?php echo e(translate('Is Joining our city tour activity on day 3?')); ?></th>

                    <th><?php echo e(translate('Total Price')); ?></th>

                    <th><?php echo e(translate('Status')); ?></th>

                    <th><?php echo e(translate('Created At')); ?></th>

                    <th><?php echo e(translate('Options')); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $registrations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $registration): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        if($registration->status == 1){
                            $status = 'Pending Payment';
                        } elseif($registration->status == 2) {
                            $status = 'Paid for Confirmation';
                        } else {
                            $status = 'Confirmed';
                        }
                    ?>
                    <tr>
                        <td><?php echo e($registration->salutation); ?></td>
                        <td><?php echo e($registration->firstname); ?></td>
                        <td><?php echo e($registration->lastname); ?></td>
                        <td><?php echo e($registration->position); ?></td>
                        <td><?php echo e($registration->email); ?></td>
                        <td><?php echo e($registration->mobile); ?></td>
                        
                        <td><?php echo e($registration->shirt_size); ?></td>

                        <td><?php echo e($registration->company); ?></td>
                        <td><?php echo e($registration->telephone); ?></td>
                        <td><?php echo e($registration->website); ?></td>
                        <td><?php echo e($registration->iata ? $registration->iata : '-'); ?></td>
                        <td><?php echo e($registration->address); ?></td>
                        <td><?php echo e($registration->city); ?></td>
                        <td><?php echo e($registration->country); ?></td>

                        <td><?php echo e($registration->early_bird == 1 ? 'Yes' : 'No'); ?></td>

                        <td><?php echo e($registration->is_joining_city_tour); ?></td>

                        <td><?php echo e(number_format($registration->total_price,2)); ?></td>
                        
                        <td><?php echo e($status); ?></td>
                            
                        <td><?php echo e(date('F d, Y h:i:s A', strtotime($registration->created_at))); ?></td>

                        <td>
                            <a class="btn btn-success" href="<?php echo e(route('registrations.view', encrypt($registration->id))); ?>"><?php echo e(translate('View More Details')); ?></a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>

<script type="text/javascript">
    $(document).ready(function() {
        if ( $.fn.dataTable.isDataTable( '#dt-selection' ) ) {
            $('#dt-selection').DataTable( {
                destroy: true,
                "responsive": true,
                "language": {
                    "paginate": {
                    "previous": '<i class="demo-psi-arrow-left"></i>',
                    "next": '<i class="demo-psi-arrow-right"></i>'
                    }
                },
                columnDefs: [
                    { orderable: false, targets: 19 },
                ],
                order: [[18, 'desc']],
            } );
        }
    } );

</script>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>

<style>
    .dataTables_wrapper .dataTables_paginate .paginate_button {
        padding: 0 0;
    }
</style>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/clnupdates/rwexpos.clnupdates.com/rw-regs/2024/resources/views/backend/registrations/index.blade.php ENDPATH**/ ?>