

<?php $__env->startSection('content'); ?>

<div class="row">
    <div class="col-sm-12">
        <a href="<?php echo e(route('sponsors.create')); ?>" class="btn btn-rounded btn-info pull-right"><?php echo e(translate('Add New Sponsor')); ?></a>
    </div>
</div>

<br>

<!-- Basic Data Tables -->
<!--===================================================-->
<div class="panel">
    <div class="panel-heading bord-btm clearfix pad-all h-100">
        <h3 class="panel-title pull-left pad-no"><?php echo e(translate('Sponsors Per Sponsorship')); ?></h3>
    </div>
    <div class="panel-body">
        <table id="dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
            <thead>
                <tr>
                    <th><?php echo e(translate('Logo')); ?></th>
                    <th><?php echo e(translate('Website Link')); ?></th>
                    <th><?php echo e(translate('Sponsorships')); ?></th>
                    <th><?php echo e(translate('Created At')); ?></th>
                    <th width="16%"><?php echo e(translate('Options')); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $sponsors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $sponsor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><img width="100" src="<?php echo e(my_asset($sponsor->logo)); ?>" alt="icons"></td>
                        <td><?php echo e($sponsor->website_link); ?></td>
                        <td><?php echo e($sponsor->sponsorship->name); ?></td>
                        <td><?php echo e(date('F d, Y h:i:s A', strtotime($sponsor->created_at))); ?></td>
                        <td>
                            <a class="btn btn-success" href="<?php echo e(route('sponsors.edit', encrypt($sponsor->id))); ?>"><?php echo e(translate('Edit')); ?></a>
                            <a class="btn btn-danger" onclick="confirm_modal('<?php echo e(route('sponsors.destroy', $sponsor->id)); ?>');"><?php echo e(translate('Delete')); ?></a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>

<script type="text/javascript">
    $(document).ready(function() {
        if ( $.fn.dataTable.isDataTable( '#dt-selection' ) ) {
            $('#dt-selection').DataTable( {
                destroy: true,
                "responsive": true,
                "language": {
                    "paginate": {
                    "previous": '<i class="demo-psi-arrow-left"></i>',
                    "next": '<i class="demo-psi-arrow-right"></i>'
                    }
                },
                columnDefs: [
                    { orderable: false, targets: 0 },
                    { orderable: false, targets: 3 }
                ],
                order: [[2, 'desc']],
            } );
        }
    } );

</script>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>

<style>
    .dataTables_wrapper .dataTables_paginate .paginate_button {
        padding: 0 0;
    }
</style>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/clnupdates/rwexpos.clnupdates.com/rw-regs/2024/resources/views/backend/sponsors/index.blade.php ENDPATH**/ ?>