

<?php $__env->startSection('content'); ?>

<div class="row">
    <div class="col-lg-12">
        <div class="panel">
            <div class="panel-heading">
                <h3 class="panel-title text-center"><?php echo e(translate('Meeting Cost Banners and Title Section')); ?></h3>
            </div>
            <div class="panel-body">
                <form class="form-horizontal" action="<?php echo e(route('banners.update')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="meeting_cost_page_title"><?php echo e(translate('Title')); ?> </label>
                        <div class="col-sm-10">
                            <input type="text" placeholder="<?php echo e(translate('Title')); ?>" id="meeting_cost_page_title" name="meeting_cost_page_title" class="form-control" value="<?php echo e(\App\BusinessSetting::where('type', 'meeting_cost_page_title')->first()->value); ?>">
                        </div>
                    </div>

                    <?php if(isset(\App\BusinessSetting::where('type', 'banners_meeting_cost_desktop')->first()->value)): ?>
                    <div class="form-group">
                        <div class="widget-image-box text-center">
                            <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="<?php echo e(my_asset(\App\BusinessSetting::where('type', 'banners_meeting_cost_desktop')->first()->value)); ?>" alt="Display Picture">
                        </div>
                    </div>
                    <?php endif; ?>
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="banners_meeting_cost_desktop"><?php echo e(translate('Desktop Banner')); ?> <span class="red">*</span></label>
                        <div class="col-sm-10">
                            <input type="file" id="banners_meeting_cost_desktop" name="banners_meeting_cost_desktop" class="form-control">
                        </div>
                    </div>

                    <?php if(isset(\App\BusinessSetting::where('type', 'banners_meeting_cost_mobile')->first()->value)): ?>
                    <div class="form-group">
                        <div class="widget-image-box text-center">
                            <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="<?php echo e(my_asset(\App\BusinessSetting::where('type', 'banners_meeting_cost_mobile')->first()->value)); ?>" alt="Display Picture">
                        </div>
                    </div>
                    <?php endif; ?>
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="banners_meeting_cost_mobile"><?php echo e(translate('Mobile Banner')); ?> <span class="red">*</span></label>
                        <div class="col-sm-10">
                            <input type="file" id="banners_meeting_cost_mobile" name="banners_meeting_cost_mobile" class="form-control">
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-lg-12 text-right">
                            <button class="btn btn-success" type="submit"><?php echo e(translate('Update Banners and Title')); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<br>

<!-- <div class="row">
    <div class="col-sm-12">
        <a href="<?php echo e(route('meeting_costs.create')); ?>" class="btn btn-rounded btn-info pull-right"><?php echo e(translate('Add New Meeting Cost')); ?></a>
    </div>
</div>

<br> -->

<!-- Basic Data Tables -->
<!--===================================================-->
<div class="panel">
    <div class="panel-heading bord-btm clearfix pad-all h-100">
        <h3 class="panel-title pull-left pad-no"><?php echo e(translate('Meeting Costs')); ?></h3>
    </div>
    <div class="panel-body">
        <table id="dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
            <thead>
                <tr>
                    <th><?php echo e(translate('Title')); ?></th>
                    <th><?php echo e(translate('Early Bird Rate Price')); ?></th>
                    <th><?php echo e(translate('Early Bird Valid Until')); ?></th>
                    <th><?php echo e(translate('Regular Rate Price')); ?></th>
                    <th><?php echo e(translate('Is VIP')); ?></th>
                    <th><?php echo e(translate('Is Sold Out')); ?></th>
                    <th><?php echo e(translate('Created At')); ?></th>
                    <th width="16%"><?php echo e(translate('Options')); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $meetingCosts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $meetingCost): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($meetingCost->title); ?></td>
                        <td><?php echo e($meetingCost->early_bird_rate_price); ?></td>
                        <td><?php echo e($meetingCost->early_bird_rate_date); ?></td>
                        <td><?php echo e($meetingCost->regular_rate_price); ?></td>
                        <td>
                            <label class="switch">
                            <input onchange="update_is_vip(this)" value="<?php echo e($meetingCost->id); ?>" type="checkbox" <?php if($meetingCost->vip == 1) echo "checked";?> >
                            <span class="slider round"></span></label>
                        </td>
                        <td>
                            <label class="switch">
                            <input onchange="update_is_sold_out(this)" value="<?php echo e($meetingCost->id); ?>" type="checkbox" <?php if($meetingCost->is_sold_out == 1) echo "checked";?> >
                            <span class="slider round"></span></label>
                        </td>
                        <td><?php echo e(date('F d, Y h:i:s A', strtotime($meetingCost->created_at))); ?></td>
                        <td>
                            <a class="btn btn-success" href="<?php echo e(route('meeting_costs.edit', encrypt($meetingCost->id))); ?>"><?php echo e(translate('Edit')); ?></a>
                            <a class="btn btn-danger" onclick="confirm_modal('<?php echo e(route('meeting_costs.destroy', $meetingCost->id)); ?>');"><?php echo e(translate('Delete')); ?></a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>

<script type="text/javascript">
    $(document).ready(function() {
        if ( $.fn.dataTable.isDataTable( '#dt-selection' ) ) {
            $('#dt-selection').DataTable( {
                destroy: true,
                "responsive": true,
                "language": {
                    "paginate": {
                    "previous": '<i class="demo-psi-arrow-left"></i>',
                    "next": '<i class="demo-psi-arrow-right"></i>'
                    }
                },
                columnDefs: [
                    { orderable: false, targets: 4 },
                    { orderable: false, targets: 6 }
                ],
                order: [[5, 'desc']],
            } );
        }
    } );

    function update_is_vip(el){
        if(el.checked){
            var published = 1;
        } else {
            var published = 0;
        }
        $.post('<?php echo e(route('meeting_costs.is_vip')); ?>', {_token:'<?php echo e(csrf_token()); ?>', id:el.value, published:published}, function(data){
            if(data == 1){
                showAlert('success', 'VIP updated successfully');
            }
            else{
                showAlert('danger', 'Something went wrong');
            }
        });
    }

    function update_is_sold_out(el){
        if(el.checked){
            var status = 1;
        } else {
            var status = 0;
        }
        $.post('<?php echo e(route('meeting_costs.is_sold_out')); ?>', {_token:'<?php echo e(csrf_token()); ?>', id:el.value, status:status}, function(data){
            if(data == 1){
                showAlert('success', 'Sold out status updated successfully');
            }
            else{
                showAlert('danger', 'Something went wrong');
            }
        });
    }
</script>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>

<style>
    .dataTables_wrapper .dataTables_paginate .paginate_button {
        padding: 0 0;
    }
</style>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/clnupdates/rwexpos.clnupdates.com/rw-regs/2024/resources/views/backend/meeting_costs/index.blade.php ENDPATH**/ ?>