

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-lg-6">
        <div class="panel">
            <div class="panel-heading">
                <h3 class="panel-title text-center"><?php echo e(translate('SMTP Settings')); ?></h3>
            </div>
            <div class="panel-body">
                <form class="form-horizontal" action="<?php echo e(route('smtpSettings.update')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="form-group">
                        <input type="hidden" name="types[]" value="MAIL_DRIVER">
                        <div class="col-lg-3">
                            <label class="control-label"><?php echo e(translate('MAIL DRIVER')); ?></label>
                        </div>
                        <div class="col-lg-6">
                            <select class="demo-select2" name="MAIL_DRIVER" onchange="checkMailDriver()">
                                <option value="sendmail" <?php if(config('mail.driver') == "sendmail"): ?> selected <?php endif; ?>><?php echo e(translate('Sendmail')); ?></option>
                                <option value="smtp" <?php if(config('mail.driver') == "smtp"): ?> selected <?php endif; ?>><?php echo e(translate('SMTP')); ?></option>
                                <option value="mailgun" <?php if(config('mail.driver') == "mailgun"): ?> selected <?php endif; ?>><?php echo e(translate('Mailgun')); ?></option>
                            </select>
                        </div>
                    </div>
                    <div id="smtp">
                        <div class="form-group">
                            <input type="hidden" name="types[]" value="MAIL_HOST">
                            <div class="col-lg-3">
                                <label class="control-label"><?php echo e(translate('MAIL HOST')); ?></label>
                            </div>
                            <div class="col-lg-6">
                                <input type="text" class="form-control" name="MAIL_HOST" value="<?php echo e(config('mail.host')); ?>" placeholder="<?php echo e(translate('MAIL HOST')); ?>">
                            </div>
                        </div>
                        <div class="form-group">
                            <input type="hidden" name="types[]" value="MAIL_PORT">
                            <div class="col-lg-3">
                                <label class="control-label"><?php echo e(translate('MAIL PORT')); ?></label>
                            </div>
                            <div class="col-lg-6">
                                <input type="text" class="form-control" name="MAIL_PORT" value="<?php echo e(config('mail.port')); ?>" placeholder="<?php echo e(translate('MAIL PORT')); ?>">
                            </div>
                        </div>
                        <div class="form-group">
                            <input type="hidden" name="types[]" value="MAIL_USERNAME">
                            <div class="col-lg-3">
                                <label class="control-label"><?php echo e(translate('MAIL USERNAME')); ?></label>
                            </div>
                            <div class="col-lg-6">
                                <input type="text" class="form-control" name="MAIL_USERNAME" value="<?php echo e(config('mail.username')); ?>" placeholder="<?php echo e(translate('MAIL USERNAME')); ?>">
                            </div>
                        </div>
                        <div class="form-group">
                            <input type="hidden" name="types[]" value="MAIL_PASSWORD">
                            <div class="col-lg-3">
                                <label class="control-label"><?php echo e(translate('MAIL PASSWORD')); ?></label>
                            </div>
                            <div class="col-lg-6">
                                <input type="text" class="form-control" name="MAIL_PASSWORD" value="<?php echo e(config('mail.password')); ?>" placeholder="<?php echo e(translate('MAIL PASSWORD')); ?>">
                            </div>
                        </div>
                        <div class="form-group">
                            <input type="hidden" name="types[]" value="MAIL_ENCRYPTION">
                            <div class="col-lg-3">
                                <label class="control-label"><?php echo e(translate('MAIL ENCRYPTION')); ?></label>
                            </div>
                            <div class="col-lg-6">
                                <input type="text" class="form-control" name="MAIL_ENCRYPTION" value="<?php echo e(config('mail.encryption')); ?>" placeholder="<?php echo e(translate('MAIL ENCRYPTION')); ?>">
                            </div>
                        </div>
                        <div class="form-group">
                            <input type="hidden" name="types[]" value="MAIL_FROM_ADDRESS">
                            <div class="col-lg-3">
                                <label class="control-label"><?php echo e(translate('MAIL FROM ADDRESS')); ?></label>
                            </div>
                            <div class="col-lg-6">
                                <input type="text" class="form-control" name="MAIL_FROM_ADDRESS" value="<?php echo e(config('mail.from.address')); ?>" placeholder="<?php echo e(translate('MAIL FROM ADDRESS')); ?>">
                            </div>
                        </div>
                        <div class="form-group">
                            <input type="hidden" name="types[]" value="MAIL_FROM_NAME">
                            <div class="col-lg-3">
                                <label class="control-label"><?php echo e(translate('MAIL FROM NAME')); ?></label>
                            </div>
                            <div class="col-lg-6">
                                <input type="text" class="form-control" name="MAIL_FROM_NAME" value="<?php echo e(config('mail.from.name')); ?>" placeholder="<?php echo e(translate('MAIL FROM NAME')); ?>">
                            </div>
                        </div>
                        <div class="form-group">
                            <input type="hidden" name="types[]" value="INQUIRY_EMAIL_RECEIVER">
                            <div class="col-lg-3">
                                <label class="control-label"><?php echo e(translate('EVENT MAIL RECEIVER')); ?></label>
                            </div>
                            <div class="col-lg-6">
                                <input type="text" class="form-control" name="INQUIRY_EMAIL_RECEIVER" value="<?php echo e(config('mail.inquiry')); ?>" placeholder="<?php echo e(translate('EVENT MAIL RECEIVER')); ?>">
                            </div>
                        </div>
                    </div>
                    <div id="mailgun">
                        <div class="form-group">
                            <input type="hidden" name="types[]" value="MAILGUN_DOMAIN">
                            <div class="col-lg-3">
                                <label class="control-label"><?php echo e(translate('MAILGUN DOMAIN')); ?></label>
                            </div>
                            <div class="col-lg-6">
                                <input type="text" class="form-control" name="MAILGUN_DOMAIN" value="<?php echo e(config('services.mailgun.domain')); ?>" placeholder="<?php echo e(translate('MAILGUN DOMAIN')); ?>">
                            </div>
                        </div>
                        <div class="form-group">
                            <input type="hidden" name="types[]" value="MAILGUN_SECRET">
                            <div class="col-lg-3">
                                <label class="control-label"><?php echo e(translate('MAILGUN SECRET')); ?></label>
                            </div>
                            <div class="col-lg-6">
                                <input type="text" class="form-control" name="MAILGUN_SECRET" value="<?php echo e(config('services.mailgun.secret')); ?>" placeholder="<?php echo e(translate('MAILGUN SECRET')); ?>">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-lg-12 text-right">
                            <button class="btn btn-purple" type="submit"><?php echo e(translate('Save')); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-lg-6">
        <div class="panel bg-gray-light">
            <div class="panel-body">
                <h4><?php echo e(translate('Instruction')); ?></h4>
                <p class="text-danger"><?php echo e(translate('Please be carefull when you are configuring SMTP. For incorrect configuration you will get error at the time of order place, new registration, sending newsletter.')); ?></p>
                <hr>
                <p><?php echo e(translate('For Non-SSL')); ?></p>
                <ul class="list-group">
                    <li class="list-group-item text-dark"><?php echo e(translate('Select \'sendmail\' for Mail Driver if you face any issue after configuring \'smtp\' as Mail Driver ')); ?></li>
                    <li class="list-group-item text-dark"><?php echo e(translate('Set Mail Host according to your server Mail Client Manual Settings')); ?></li>
                    <li class="list-group-item text-dark"><?php echo e(translate('Set Mail port as \'587\'')); ?></li>
                    <li class="list-group-item text-dark"><?php echo e(translate('Set Mail Encryption as \'ssl\' if you face issue with \'tls\'')); ?></li>
                </ul>
                <p><?php echo e(translate('For SSL')); ?></p>
                <ul class="list-group mar-no">
                    <li class="list-group-item text-dark"><?php echo e(translate('Select \'sendmail\' for Mail Driver if you face any issue after configuring \'smtp\' as Mail Driver')); ?></li>
                    <li class="list-group-item text-dark"><?php echo e(translate('Set Mail Host according to your server Mail Client Manual Settings')); ?></li>
                    <li class="list-group-item text-dark"><?php echo e(translate('Set Mail port as \'465\'')); ?></li>
                    <li class="list-group-item text-dark"><?php echo e(translate('Set Mail Encryption as \'ssl\'')); ?></li>
                </ul>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>

    <script type="text/javascript">
        $(document).ready(function(){
            checkMailDriver();
        });
        function checkMailDriver(){
            if($('select[name=MAIL_DRIVER]').val() == 'mailgun'){
                $('#mailgun').show();
                $('#smtp').hide();
            }
            else{
                $('#mailgun').hide();
                $('#smtp').show();
            }
        }
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/clnupdates/rwexpos.clnupdates.com/rw-regs/2024/resources/views/business_settings/smtp_settings.blade.php ENDPATH**/ ?>