<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Events;

use Twilio\Domain;
use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Rest\Events\V1\SinkList;
use Twilio\Rest\Events\V1\SubscriptionList;
use Twilio\Version;

/**
 * @property SinkList $sinks
 * @property SubscriptionList $subscriptions
 * @method \Twilio\Rest\Events\V1\SinkContext sinks(string $sid)
 * @method \Twilio\Rest\Events\V1\SubscriptionContext subscriptions(string $sid)
 */
class V1 extends Version {
    protected $_sinks;
    protected $_subscriptions;

    /**
     * Construct the V1 version of Events
     *
     * @param Domain $domain Domain that contains the version
     */
    public function __construct(Domain $domain) {
        parent::__construct($domain);
        $this->version = 'v1';
    }

    protected function getSinks(): SinkList {
        if (!$this->_sinks) {
            $this->_sinks = new SinkList($this);
        }
        return $this->_sinks;
    }

    protected function getSubscriptions(): SubscriptionList {
        if (!$this->_subscriptions) {
            $this->_subscriptions = new SubscriptionList($this);
        }
        return $this->_subscriptions;
    }

    /**
     * Magic getter to lazy load root resources
     *
     * @param string $name Resource to return
     * @return \Twilio\ListResource The requested resource
     * @throws TwilioException For unknown resource
     */
    public function __get(string $name) {
        $method = 'get' . \ucfirst($name);
        if (\method_exists($this, $method)) {
            return $this->$method();
        }

        throw new TwilioException('Unknown resource ' . $name);
    }

    /**
     * Magic caller to get resource contexts
     *
     * @param string $name Resource to return
     * @param array $arguments Context parameters
     * @return InstanceContext The requested resource context
     * @throws TwilioException For unknown resource
     */
    public function __call(string $name, array $arguments): InstanceContext {
        $property = $this->$name;
        if (\method_exists($property, 'getContext')) {
            return \call_user_func_array(array($property, 'getContext'), $arguments);
        }

        throw new TwilioException('Resource does not have a context');
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.Events.V1]';
    }
}